﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
// File information
// Name: Program.cs
// Author: bis5
// Module: SupportTool
///////////////////////////////////////////////////////////////////////////////
using System;
using Microsoft.Win32;

namespace Bis5Products.SharpWebBrowser.SupportTool {
    class Program {

        const string KeyFeatureBrowserEmulation = "FEATURE_BROWSER_EMULATION";
        const string KeyFeatureControl = "FeatureControl";
        const string KeyPath = "Software\\Microsoft\\Internet Explorer\\Main";

        const int IE9 = 0x2328;
        const int IE8 = 0x1F40;
        const int IE7 = 0x1B58;

        const int ARGS_NOT_FOUND = 1;
        const int SUCCESS = 0;
        const int OPERATION_FAILED = 2;

        static int Main(string[] args) {
            try {
                switch (args[0]) {
                    case "/v":
                        if (args[1] == "9") SetEngineVersion(IE9);
                        if (args[1] == "8") SetEngineVersion(IE8);
                        if (args[1] == "7") SetEngineVersion(IE7);
                        break;
                    case "/h":
                        ShowHelp();
                        break;
                    default:
                        ShowHelp();
                        break;
                }
            } catch (IndexOutOfRangeException) {
                ShowHelp();
            }
            return 0;
        }

        static void ShowHelp() {
            Console.WriteLine("SharpWebBrowser サポートツール");
            Console.WriteLine("  Version 0.5.6 Alpha");
            Console.WriteLine();
            Console.WriteLine("コマンドラインオプション：");
            Console.WriteLine("\t/v [7-9]\tTridentエンジンのバージョンを変更します");
            Console.WriteLine("\t/h\t\tこのヘルプ文書を表示します");
            Console.WriteLine();
            Console.WriteLine("使用例：");
            Console.WriteLine("\tSupportTool /v 9");
            Console.WriteLine();
            Console.WriteLine("終了するには何かキーを押してください...");
            Console.ReadKey();
        }

        static int SetEngineVersion(int emumode) {
            try {
                int ver = 0;
                if (emumode == IE9) ver = IE9;
                if (emumode == IE8) ver = IE8;
                if (emumode == IE7) ver = IE7;

                var regCU = Registry.CurrentUser;
                var key = regCU.OpenSubKey(KeyPath, true);
                key = Program.GetRegistryKey(key, KeyFeatureControl);
                key = Program.GetRegistryKey(key, KeyFeatureBrowserEmulation);
                key.SetValue("SharpWebBrowser.exe", ver, RegistryValueKind.DWord);
            } catch (Exception ex) {
                Console.WriteLine(ex.ToString());
                return OPERATION_FAILED;
            }
            return SUCCESS;
        }

        static RegistryKey GetRegistryKey(RegistryKey parentKey, string target, bool ronly = false) {
            bool _found = false;
            RegistryKey ret = null;
            foreach (string subkey in parentKey.GetSubKeyNames()) {
                if (subkey == target) {
                    _found = true;
                    ret = parentKey.OpenSubKey(target, !ronly);
                    break;
                }
            }
            if (!_found) {
                ret = parentKey.CreateSubKey(target);
            }

            return ret ?? null;
        }
    }
}
