#pragma once

#include "SoundEditorPage.xaml.h"

namespace ShootingGame 
{
  namespace State {
    struct SoundEdit_ : msmf::state_machine_def<SoundEdit_>
    {
      template <class Event, class Fsm> 
      void on_entry(Event const&, Fsm&  fsm) 
      {
        gameMain_ = fsm.GameMain();
      };

      template <class Event, class Fsm> 
      void on_exit(Event const&, Fsm& )
      {

      };

      // I
      struct Exit : msmf::exit_pseudo_state<msmf::none> {};

      // ACh
      struct Idle : msmf::state<> 
      {
        template <class Event, class Fsm> 
        void on_entry(Event const&, Fsm&  fsm) 
        {
          gameMain_ = fsm.GameMain();
          SoundEditorPage^ page_ = ref new SoundEditorPage();
          gameMain_->Subframe(page_);
          gameMain_->IsBackButtonEnabled(true);
        }

        template <class Event, class Fsm> 
        void on_exit(Event const&, Fsm& )
        {
          gameMain_->Subframe(nullptr);
          page_ = nullptr;
        };
      private:
        ShootingGame::GameMain^ gameMain_;
        SoundEditorPage^ page_;
      };

      typedef boost::mpl::vector<Idle> initial_state;

      // ԑJڃe[u
      struct transition_table 
        : boost::mpl::vector<
        msmf::Row<Idle,Event::Back,Exit>
        >
      {};

      // No handled event handler
      template <class Fsm,class Event> 
      void no_transition(Event const& e, Fsm& ,int state)
      {
        //           std::cout << "No handled event in Sm1 " << typeid(e).name() << " on State " << state << std::endl;
      }

      // vpeB
      ShootingGame::GameMain^ SoundEdit_::GameMain(){return gameMain_;} 
    private:
      ShootingGame::GameMain^ gameMain_;  };

    typedef msmb::state_machine<SoundEdit_> SoundEdit;

  }
}