////// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
//// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//// PARTICULAR PURPOSE.
////
//// Copyright (c) Microsoft Corporation. All rights reserved

#pragma once

#include "DirectXBase.h"
#include "SampleOverlay.h"
#include "AutoThrottle.h"
#include "BasicSprites.h"
#include "SoundManager.h"

struct CharacterData
{
  float2 pos;
  float2 vel;
  float rot;
  float rotVel;
  float scale;
};

ref class GameMain : public DirectXBase
{
internal:
  GameMain();
  ~GameMain();
  virtual void CreateDeviceIndependentResources() override;
  virtual void CreateDeviceResources() override;
  virtual void CreateWindowSizeDependentResources() override;
  virtual void Render() override;

  void Initialize(
    _In_ Windows::UI::Core::CoreWindow^ window,
    _In_ Windows::UI::Xaml::Controls::SwapChainBackgroundPanel^ swapChainPanel,
    _In_ float dpi
    ) ;//new;

  void Update(float timeTotal, float timeDelta);

  static const float BACKBUFFER_WIDTH;
  static const float BACKBUFFER_HEIGHT;



private:
  void ExecuteSoundThread();
  void InitSound();
  float RandFloat(float min, float max);
  SampleOverlay^ sampleOverlay_;
  AutoThrottle^ autoThrottle_;
  BasicSprites::SpriteBatch^ spriteBatch_;
  Microsoft::WRL::ComPtr<ID3D11Texture2D> test_;
  Microsoft::WRL::ComPtr<ID3D11Texture2D> backBuffer_;
  Microsoft::WRL::ComPtr<ID3D11RenderTargetView>  backBufferRenderTargetView_;
  //  Microsoft::WRL::ComPtr<ID3D11DepthStencilView>  backBufferDepthStencilView_;
  //	Microsoft::WRL::ComPtr<ID3D11DepthStencilState> backBufferDepthStencilState_;
  float scale_;
  CD3D11_VIEWPORT backBufferViewPort_;
  CD3D11_VIEWPORT swapChainViewPort_;
  std::vector<CharacterData> characters_;
  bool isDestroy_;
  Windows::UI::Xaml::Controls::SwapChainBackgroundPanel^ panel_;
  std::unique_ptr<sf::SoundManager> soundManager_;
  std::unique_ptr<sf::SoundDriver> soundDriver_;
  //std::thread soundThread_;
  concurrency::task<void> soundTask_;
};
