/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.RawEntity;
import net.java.ao.cache.Cache;
import net.java.ao.cache.CacheLayer;
import net.java.ao.cache.RAMCacheLayer;
import net.java.ao.cache.RAMRelationsCache;
import net.java.ao.cache.RelationsCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMCache
implements Cache {
    private Map<RawEntity<?>, CacheLayer> cacheLayer;
    private final ReadWriteLock cacheLayerLock = new ReentrantReadWriteLock();
    private final RAMRelationsCache relationsCache;

    public RAMCache() {
        this.cacheLayer = new WeakHashMap();
        this.relationsCache = new RAMRelationsCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheLayer getCacheLayer(RawEntity<?> entity) {
        this.cacheLayerLock.writeLock().lock();
        if (this.cacheLayer.containsKey(entity)) {
            this.cacheLayerLock.readLock().lock();
            this.cacheLayerLock.writeLock().unlock();
            try {
                CacheLayer cacheLayer = this.cacheLayer.get(entity);
                return cacheLayer;
            }
            finally {
                this.cacheLayerLock.readLock().unlock();
            }
        }
        RAMCacheLayer layer = new RAMCacheLayer();
        this.cacheLayer.put(entity, layer);
        RAMCacheLayer rAMCacheLayer = layer;
        return rAMCacheLayer;
        finally {
            try {
                this.cacheLayerLock.writeLock().unlock();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public RelationsCache getRelationsCache() {
        return this.relationsCache;
    }
}

