/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.java.ao.DatabaseProvider;
import net.java.ao.PoolProvider;
import snaq.db.ConnectionPoolManager;

public class DBPoolProvider
extends PoolProvider {
    private ConnectionPoolManager pool;

    public DBPoolProvider(DatabaseProvider delegate) {
        super(delegate);
        String driverName = null;
        try {
            driverName = delegate.getDriverClass().getCanonicalName();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        Properties props = new Properties();
        props.setProperty("drivers", driverName);
        props.setProperty("activeobjects.url", this.getURI());
        props.setProperty("activeobjects.user", this.getUsername());
        props.setProperty("activeobjects.password", this.getPassword());
        props.setProperty("activeobjects.maxpool", "180");
        props.setProperty("activeobjects.maxconn", "30");
        props.setProperty("activeobjects.cache", "true");
        ConnectionPoolManager.createInstance((Properties)props);
        try {
            this.pool = ConnectionPoolManager.getInstance();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Connection getConnectionImpl() throws SQLException {
        return this.pool.getConnection("activeobjects");
    }

    public void dispose() {
        this.pool.release();
    }

    public static boolean isAvailable() {
        try {
            Class.forName("snaq.db.ConnectionPool");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

