/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BooleanType
extends DatabaseType<Boolean> {
    protected BooleanType() {
        super(16, -1, Boolean.TYPE, Boolean.class);
    }

    @Override
    public String getDefaultName() {
        return "BOOLEAN";
    }

    @Override
    public Boolean pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends Boolean> type, String field) throws SQLException {
        return res.getBoolean(field);
    }

    @Override
    public Boolean defaultParseValue(String value) {
        return Boolean.parseBoolean(value.trim());
    }

    @Override
    public boolean valueEquals(Object a, Object b) {
        if (a instanceof Number) {
            if (b instanceof Boolean) {
                return ((Number)a).intValue() == 1 == (Boolean)b;
            }
        } else if (a instanceof Boolean && b instanceof Number) {
            return ((Number)b).intValue() == 1 == (Boolean)a;
        }
        return a.equals(b);
    }
}

