/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimestampDateType
extends DatabaseType<Date> {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TimestampDateType() {
        super(93, -1, Date.class);
    }

    @Override
    public String getDefaultName() {
        return "TIMESTAMP";
    }

    @Override
    public void putToDatabase(int index, PreparedStatement stmt, Date value) throws SQLException {
        stmt.setTimestamp(index, new Timestamp(value.getTime()));
    }

    @Override
    public Date pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends Date> type, String field) throws SQLException {
        return res.getTimestamp(field);
    }

    @Override
    public Date defaultParseValue(String value) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    @Override
    public String valueToString(Object value) {
        return this.dateFormat.format((Date)value);
    }
}

