/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jdbcacsess2.main.Config;
import jdbcacsess2.main.MainController;
import jdbcacsess2.main.ShowDialog;

public class Jdbcacsess2 {
    public static final Logger logger = Logger.getLogger(Jdbcacsess2.class.getName());
    public static final Logger loggerActiveObjects = Logger.getLogger("net.java.ao");

    public static void main(String[] args) {
        new Jdbcacsess2();
    }

    public Jdbcacsess2() {
        logger.setLevel(Level.FINE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Jdbcacsess2.this.setLookAndFeel();
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        ShowDialog.errorMessage(e);
                    }
                });
                try {
                    Config config = new Config();
                    new MainController(config);
                }
                catch (Exception e) {
                    ShowDialog.errorMessage(e);
                }
                logger.info("aplication startup end.");
            }
        });
    }

    private void setLookAndFeel() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
    }
}

