/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import com.ezware.oxbow.swingbits.table.filter.TableRowFilterSupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jdbcacsess2.main.FontZoom;
import jdbcacsess2.main.TableColumnFit;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class JmyTable
extends JXTable {
    private static final long serialVersionUID = -7507194043135028576L;
    private final transient TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent event) {
            switch (event.getType()) {
                case 0: {
                    int updateRow = JmyTable.this.convertRowIndexToView(event.getFirstRow());
                    JmyTable.this.changeSelection(updateRow, updateRow, false, false);
                    break;
                }
                case 1: {
                    final int insertRow = event.getFirstRow();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int row = JmyTable.this.convertRowIndexToView(insertRow);
                            JmyTable.this.changeSelection(row, row, false, false);
                        }
                    });
                    break;
                }
                case -1: {
                    if (JmyTable.this.getModel().getRowCount() == 0) break;
                    final int deletedViewRow = JmyTable.this.convertRowIndexToView(event.getFirstRow());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int row = deletedViewRow;
                            if (JmyTable.this.getRowSorter().getViewRowCount() <= row) {
                                row = JmyTable.this.getRowSorter().getViewRowCount() - 1;
                            }
                            JmyTable.this.changeSelection(row, row, false, false);
                        }
                    });
                    break;
                }
            }
        }
    };

    public JmyTable() {
        this.initialize();
    }

    public JmyTable(TableModel dm) {
        super(dm);
        this.initialize();
    }

    public JmyTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public JmyTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public JmyTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public JmyTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public JmyTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    private void initialize() {
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping()});
        this.setRowSelectionAllowed(true);
        this.setAutoCreateRowSorter(true);
        this.setEditable(false);
        FontZoom.setMouseWheel((Component)((Object)this));
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        new TableColumnFit((JTable)((Object)this)).setEnableAutoFit(true);
        TableRowFilterSupport.forTable((JTable)((Object)this)).searchable(true).apply();
        tableModel.addTableModelListener(this.tableModelListener);
        this.setSortsOnUpdates(true);
    }

    public int getSelectedModelRow() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return -1;
        }
        return this.convertRowIndexToModel(row);
    }

    public int getSelectedModelColumn() {
        int column = this.getSelectedColumn();
        if (column < 0) {
            return -1;
        }
        return this.convertColumnIndexToModel(column);
    }

    public ArrayList<Integer> getSelectedModelRows() {
        int[] rows = this.getSelectedRows();
        ArrayList<Integer> list = new ArrayList<Integer>(rows.length);
        int i = 0;
        while (i < rows.length) {
            list.add(this.convertRowIndexToModel(rows[i]));
            ++i;
        }
        return list;
    }

    public ArrayList<Integer> getSelectedModelColumns() {
        int[] columns = this.getSelectedColumns();
        ArrayList<Integer> list = new ArrayList<Integer>(columns.length);
        int i = 0;
        while (i < columns.length) {
            list.add(this.convertColumnIndexToModel(columns[i]));
            ++i;
        }
        return list;
    }
}

