/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import jdbcacsess2.connect.ConnectController;
import jdbcacsess2.main.CodeAssistView;
import jdbcacsess2.main.Config;
import jdbcacsess2.main.JPanelHIstory;
import jdbcacsess2.main.JPanelSession;
import jdbcacsess2.main.JPanelSql;
import jdbcacsess2.main.JTableShortcut;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.main.JmyTable;
import jdbcacsess2.main.MainView;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.main.TabComponent;
import jdbcacsess2.main.TableColumnFit;
import jdbcacsess2.sqlService.CodeAssistModel;
import jdbcacsess2.sqlService.DataBaseConnection;
import jdbcacsess2.sqlService.DataBaseConnectionListener;
import jdbcacsess2.sqlService.DataBaseTransactionListener;
import jdbcacsess2.sqlService.SqlAsyncExecute;
import jdbcacsess2.sqlService.SqlExecutedListener;
import jdbcacsess2.sqlService.StringConncat;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectTableColumns;
import jdbcacsess2.sqlService.dbobject.DBObjectTables;
import jdbcacsess2.sqlService.dbobject.DBObjectsRoot;
import jdbcacsess2.sqlService.dbobject.DBobjectMutableTreeTableNode;
import jdbcacsess2.sqlService.dbobject.PropertyDBObjectsTableModel;
import jdbcacsess2.sqlService.dbobject.PropertyExportedKeyTableModel;
import jdbcacsess2.sqlService.exception.DbConnectAlreadyException;
import jdbcacsess2.sqlService.exception.DbConnectIllgalStateException;
import jdbcacsess2.sqlService.history.HistryTableModel;
import jdbcacsess2.sqlService.history.Record;
import jdbcacsess2.sqlService.parse.SqlExecuteSentencies;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class MainController {
    private final Config config;
    private final HistryTableModel histryTableModel;
    private final MainView view;
    private final CodeAssistView codeAssistView;
    private final ActionListener actionNewPanelSession = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MainController.this.createConnectionJPanelSession();
            }
            catch (Exception e2) {
                ShowDialog.errorMessage(e2);
            }
        }
    };
    private final ActionListener actionReNewPanelSession = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MainController.this.view.getCurrentJPanelSession().getDataBaseConnection().close();
            }
            catch (DbConnectIllgalStateException dbConnectIllgalStateException) {
                // empty catch block
            }
            try {
                MainController.this.view.getCurrentJPanelSession().getDataBaseConnection().open();
            }
            catch (Exception e2) {
                ShowDialog.errorMessage(e2);
            }
        }
    };
    private final ActionListener actionClosePanelSession = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = ((MainController)MainController.this).view.tabbedPaneMousePointer.getFocusedComponentIndex();
            if (index == -1) {
                return;
            }
            MainController.this.view.getJTabbedPaneSession().remove(index);
        }
    };
    private final Action actionExecutionShortcut = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainController.this.view.getCurrentJPanelSql().getJToggleButtonExecution().doClick();
        }
    };
    private final Action actionExecution = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanelSql jPanelSql = MainController.this.view.getCurrentJPanelSql();
            if (jPanelSql.getJToggleButtonExecution().isSelected()) {
                this.exec(jPanelSql);
            } else {
                this.stop(jPanelSql);
            }
        }

        private void exec(JPanelSql jPanelSql) {
            SqlAsyncExecute sqlAsyncExecute;
            String sql = jPanelSql.getRSyntaxTextAreaSql().getSelectedText();
            if (sql == null) {
                sql = jPanelSql.getRSyntaxTextAreaSql().getText();
            }
            if ((sqlAsyncExecute = new SqlAsyncExecute(sql, ((JPanelSql.SentenceSeparator)jPanelSql.getJComboBoxSentenceSeparator().getSelectedItem()).getRegVal())).isDuplxSelect()) {
                ShowDialog.warningMessage("\u8907\u6570\u306eSELECT\u6587\u306f\u5b9f\u884c\u51fa\u6765\u307e\u305b\u3093", "\u8907\u6570\u306eSELECT\u6587");
                jPanelSql.getJToggleButtonExecution().setSelected(false);
                return;
            }
            for (SqlExecuteSentencies.SqlExecuteSentence ses : sqlAsyncExecute.getSqlExecuteSentencies()) {
                for (String s : ses.getSqlInputParameter().getInputItemNames()) {
                    Jdbcacsess2.logger.fine(String.valueOf(ses.getSqlCommand()) + " " + s);
                }
            }
            try {
                sqlAsyncExecute.addSqlExcutedListener(jPanelSql);
                sqlAsyncExecute.addSqlExcutedListener((SqlExecutedListener)((Object)jPanelSql.getJTable().getModel()));
                sqlAsyncExecute.addSqlExcutedListener(new Record(MainController.this.config, jPanelSql.getDataBaseConnection().getConnectName(), jPanelSql.getDataBaseConnection().getUrl(), jPanelSql.getDataBaseConnection().getUser(), MainController.this.histryTableModel));
                sqlAsyncExecute.executeAsync(jPanelSql.getDataBaseConnection());
            }
            catch (Exception ex) {
                ShowDialog.errorMessage(ex);
            }
        }

        private void stop(JPanelSql jPanelSql) {
            jPanelSql.taskCancel();
        }
    };
    private final Action actionConnection = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainController.this.view.getCurrentJPanelSql().getDataBaseConnection() == null) {
                return;
            }
            JToggleButton tb = (JToggleButton)e.getSource();
            try {
                if (tb.isSelected()) {
                    try {
                        MainController.this.view.getCurrentJPanelSql().getDataBaseConnection().open();
                    }
                    catch (DbConnectAlreadyException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        MainController.this.view.getCurrentJPanelSql().getDataBaseConnection().close();
                    }
                    catch (DbConnectIllgalStateException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (SQLException ex) {
                ShowDialog.errorMessage(ex);
                tb.setSelected(false);
            }
        }
    };
    private final Action actionContinue = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainController.this.view.getCurrentJPanelSql().taskWakuUp();
        }
    };
    private final Action actionCommit = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainController.this.view.getCurrentJPanelSql().getDataBaseConnection() == null) {
                return;
            }
            try {
                MainController.this.view.getCurrentJPanelSql().getDataBaseConnection().commit();
                Jdbcacsess2.logger.info("commit");
            }
            catch (Exception ex) {
                ShowDialog.errorMessage(ex);
            }
        }
    };
    private final Action actionRollback = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainController.this.view.getCurrentJPanelSql().getDataBaseConnection() == null) {
                return;
            }
            try {
                MainController.this.view.getCurrentJPanelSql().getDataBaseConnection().rollback();
                Jdbcacsess2.logger.info("rollback");
            }
            catch (Exception ex) {
                ShowDialog.errorMessage(ex);
            }
        }
    };
    private final Action actionExit = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowEvent closingEvent = new WindowEvent(MainController.this.view, 201);
            MainController.this.view.getToolkit().getSystemEventQueue().postEvent(closingEvent);
        }
    };
    private final WindowAdapter windowClosing = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            Jdbcacsess2.logger.info("application termination start:" + e);
            try {
                MainView.ConfigViewMain row = MainController.this.config.getConfigWindow(MainView.ConfigViewMain.class);
                MainController.this.view.collectViewMain(row);
                row.save();
                MainController.this.config.close();
                MainController.this.view.removeAll();
            }
            catch (SQLException ex) {
                ShowDialog.errorMessage(ex);
            }
            Jdbcacsess2.logger.info("application  termination end");
        }
    };
    private final Action actionNewPanelSql = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DataBaseConnection dbc = MainController.this.view.getCurrentJPanelSession().getDataBaseConnection();
            try {
                MainController.this.createConnectionJpanelSql(dbc);
            }
            catch (Exception e1) {
                ShowDialog.errorMessage(e1);
            }
        }
    };
    private final Action actionClosePanelSql = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = ((MainController)MainController.this).view.getCurrentJPanelSession().tabbedPaneMousePointer.getFocusedComponentIndex();
            if (index == -1) {
                return;
            }
            JTabbedPane jTabbedPane = MainController.this.view.getCurrentJPanelSession().getJTabbedPaneSql();
            if (jTabbedPane.getComponentAt(index) instanceof JPanelSql) {
                jTabbedPane.remove(index);
            }
        }
    };
    private final Action actionCloseOtherPanelSql = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane tab = MainController.this.view.getCurrentJPanelSession().getJTabbedPaneSql();
            int index = ((MainController)MainController.this).view.getCurrentJPanelSession().tabbedPaneMousePointer.getFocusedComponentIndex();
            if (index == -1) {
                return;
            }
            Component c = tab.getComponentAt(index);
            for (Component component : new CopyOnWriteArrayList<Component>(tab.getComponents())) {
                if (!(component instanceof JPanelSql) || component == c) continue;
                tab.remove(component);
            }
        }
    };
    private final Action actionObjectRefresh = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JXTreeTable treeTable = MainController.this.view.getCurrentJPanelSession().getJXTreetableDBObjects();
            DefaultTreeTableModel treeTableModel = (DefaultTreeTableModel)treeTable.getTreeTableModel();
            TreePath[] tps = treeTable.getTreeSelectionModel().getSelectionPaths();
            int i = 0;
            while (i < tps.length) {
                DBobjectMutableTreeTableNode node = (DBobjectMutableTreeTableNode)((Object)tps[i].getLastPathComponent());
                Jdbcacsess2.logger.fine("refresh:" + node.getDBObject().getSummary());
                for (MutableTreeTableNode mttn : Collections.list(node.children())) {
                    treeTableModel.removeNodeFromParent(mttn);
                }
                node.getDBObject().clearCache();
                MainController.this.view.getCurrentJPanelSession().addChildren(node);
                ++i;
            }
        }
    };
    private final Action actionObjectExpandOrCollapse = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JXTreeTable treeTable = MainController.this.view.getCurrentJPanelSession().getJXTreetableDBObjects();
            TreePath[] tps = treeTable.getTreeSelectionModel().getSelectionPaths();
            if (tps == null) {
                return;
            }
            int i = 0;
            while (i < tps.length) {
                if (treeTable.isExpanded(tps[i])) {
                    treeTable.collapsePath(tps[i]);
                } else {
                    treeTable.expandPath(tps[i]);
                }
                ++i;
            }
        }
    };
    private final TreeWillExpandListener eventObjectExpand = new TreeWillExpandListener(){

        @Override
        public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent arg0) throws ExpandVetoException {
            DBobjectMutableTreeTableNode n = (DBobjectMutableTreeTableNode)((Object)arg0.getPath().getLastPathComponent());
            MainController.this.view.getCurrentJPanelSession().addChildren(n);
        }
    };
    private final TreeSelectionListener eventObjectSelection = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DBobjectMutableTreeTableNode node = (DBobjectMutableTreeTableNode)((Object)e.getPath().getLastPathComponent());
            DBObject dbObject = node.getDBObject();
            if (dbObject.isPropertyEnable()) {
                JmyTable jTableProperty = MainController.this.view.getCurrentJPanelSession().getJTableProperty();
                jTableProperty.setModel(new PropertyDBObjectsTableModel(dbObject.getProperties()));
            }
            if (dbObject instanceof DBObjectTableColumns.DBObjectTableColumn) {
                DBobjectMutableTreeTableNode parent = (DBobjectMutableTreeTableNode)node.getParent();
                dbObject = parent.getDBObject();
            }
            JmyTable jTable = MainController.this.view.getCurrentJPanelSession().getJTableExportedKey();
            if (dbObject instanceof DBObjectTables.DBObjectTable) {
                jTable.setModel(new PropertyExportedKeyTableModel(((DBObjectTables.DBObjectTable)dbObject).getExportedKey()));
            }
        }
    };
    private final MouseListener eventObjectsPressed = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            TreePath tp = MainController.this.view.getCurrentJPanelSession().getJXTreetableDBObjects().getPathForLocation(e.getX(), e.getY());
            if (tp == null) {
                return;
            }
            DBObject o = ((DBobjectMutableTreeTableNode)((Object)tp.getLastPathComponent())).getDBObject();
            if (o.getName() == null) {
                return;
            }
            JPanelSql jPanelSql = MainController.this.view.getCurrentJPanelSql();
            if (jPanelSql == null) {
                return;
            }
            jPanelSql.insertStringPreviousCaret(o.getName());
        }
    };
    private final Action actionObjectSelect = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] tps = ((JXTreeTable)e.getSource()).getTreeSelectionModel().getSelectionPaths();
            if (tps == null) {
                return;
            }
            StringConncat s = new StringConncat(", ");
            int i = 0;
            while (i < tps.length) {
                DBObject o = (DBObject)((DBobjectMutableTreeTableNode)((Object)tps[i].getLastPathComponent())).getUserObject();
                if (o.getName() != null) {
                    s.append(o.getName());
                }
                ++i;
            }
            MainController.this.view.getCurrentJPanelSql().insertStringPreviousCaret(s.toString());
        }
    };
    private final Action actionCodeAssistDisplay = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent jTextComponent = (JTextComponent)e.getSource();
            try {
                MainController.this.codeAssistView.setLocation(jTextComponent);
                MainController.this.codeAssistView.setModel(new CodeAssistModel());
                MainController.this.codeAssistView.setVisible(true);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    };
    private final Action actionSelectCodeAssist = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = MainController.this.codeAssistView.getJList().getSelectedValue().getEditorValue();
            if (!value.equals("")) {
                MainController.this.view.getCurrentJPanelSql().insertStringPreviousCaret(value);
            }
            MainController.this.codeAssistView.setVisible(false);
        }
    };
    HierarchyListener eventHierarchyParentChanged = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                JPanelSession jPanelSql;
                Component c = e.getComponent();
                Jdbcacsess2.logger.info("PARENT_CHANGED:" + e);
                if (c instanceof JPanelSql) {
                    JPanelSql jPanelSql2 = (JPanelSql)c;
                    if (jPanelSql2.getDataBaseConnection() != null) {
                        try {
                            jPanelSql2.getDataBaseConnection().close();
                        }
                        catch (DbConnectIllgalStateException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if (c instanceof JPanelSession && (jPanelSql = (JPanelSession)c).getDataBaseConnection() != null) {
                    try {
                        jPanelSql.getDataBaseConnection().close();
                    }
                    catch (DbConnectIllgalStateException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    };

    public MainController(Config config) {
        this.config = config;
        this.view = new MainView();
        this.histryTableModel = new HistryTableModel(config);
        this.codeAssistView = new CodeAssistView(this.view);
        this.codeAssistView.setActionSelected(this.actionSelectCodeAssist);
        this.view.addWindowListener(this.windowClosing);
        this.view.getExitMenuItem().addActionListener(this.actionExit);
        this.view.getJMenuTabbedSessionNew().addActionListener(this.actionNewPanelSession);
        this.view.getJMenuTabbedSessionReNew().addActionListener(this.actionReNewPanelSession);
        this.view.getJMenuTabbedSessionClose().addActionListener(this.actionClosePanelSession);
        this.view.setViewMain(this.getConfigViewMain());
        this.view.setVisible(true);
        try {
            this.createConnectionJPanelSession();
        }
        catch (Exception e2) {
            ShowDialog.errorMessage(e2);
        }
    }

    private MainView.ConfigViewMain getConfigViewMain() {
        try {
            MainView.ConfigViewMain[] c = (MainView.ConfigViewMain[])this.config.getEntityManager().find(MainView.ConfigViewMain.class);
            if (c.length != 0) {
                return c[0];
            }
        }
        catch (SQLException e1) {
            ShowDialog.errorMessage(e1);
        }
        return null;
    }

    private void createConnectionJPanelSession() throws Exception {
        JPanelSession jPanelSession = new JPanelSession();
        ChangeConnectionPanelSession changeConnectionPanelSession = new ChangeConnectionPanelSession(jPanelSession);
        ConnectController dialog = new ConnectController(this.config, this.view);
        dialog.addReauestDataBaseListener(changeConnectionPanelSession);
        dialog.setVisible(true);
    }

    private void createConnectionJpanelSql(DataBaseConnection dbc) throws Exception {
        JPanelSql jpanelSql = new JPanelSql();
        DataBaseConnection newdbc = new DataBaseConnection(dbc);
        newdbc.addConnectionListener(new ChangeConnectionPanelSql(jpanelSql));
        newdbc.addConnectionListener(jpanelSql);
        newdbc.addTransactionListener(new ChangeTransactionPanelSql());
        newdbc.addTransactionListener(jpanelSql);
        newdbc.open();
    }

    private void setShortCut(JComponent jComponent, int keyCode, int modifiers, String key, Action action) {
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        inputMap.put(keyStroke, key);
        actionMap.put(key, action);
    }

    private class ChangeConnectionPanelSession
    implements DataBaseConnectionListener {
        private final JPanelSession jPanelSession;

        ChangeConnectionPanelSession(JPanelSession jPanelSession) {
            this.jPanelSession = jPanelSession;
        }

        @Override
        public void dataBaseConnectionOpened(final DataBaseConnection dbc) {
            Jdbcacsess2.logger.info(dbc + " " + dbc.getUrl());
            if (this.jPanelSession.getDataBaseConnection() != null) {
                Jdbcacsess2.logger.info("reopen");
                return;
            }
            this.jPanelSession.setDataBaseConnection(dbc);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangeConnectionPanelSession.this.jPanelSession.getJMenuTabbedSqlNew().addActionListener(MainController.this.actionNewPanelSql);
                    ChangeConnectionPanelSession.this.jPanelSession.getJMenuTabbedSqlClose().addActionListener(MainController.this.actionClosePanelSql);
                    ChangeConnectionPanelSession.this.jPanelSession.getJMenuTabbedSqlCloseOther().addActionListener(MainController.this.actionCloseOtherPanelSql);
                    JXTreeTable treeTable = ChangeConnectionPanelSession.this.jPanelSession.getJXTreetableDBObjects();
                    treeTable.addTreeWillExpandListener(MainController.this.eventObjectExpand);
                    treeTable.addTreeSelectionListener(MainController.this.eventObjectSelection);
                    treeTable.addMouseListener(MainController.this.eventObjectsPressed);
                    MainController.this.setShortCut((JComponent)treeTable, 116, 0, "refresh", MainController.this.actionObjectRefresh);
                    MainController.this.setShortCut((JComponent)treeTable, 10, 0, "enter", MainController.this.actionObjectSelect);
                    MainController.this.setShortCut((JComponent)treeTable, 32, 0, "expand_collapse", MainController.this.actionObjectExpandOrCollapse);
                    ChangeConnectionPanelSession.this.jPanelSession.getJMenuDBobjectsRefresh().addActionListener(MainController.this.actionObjectRefresh);
                    MainController.this.view.setViewMainPanelSesion(ChangeConnectionPanelSession.this.jPanelSession, MainController.this.getConfigViewMain());
                    JTabbedPane jTabbedPane = MainController.this.view.getJTabbedPaneSession();
                    jTabbedPane.setSelectedComponent(jTabbedPane.add(dbc.getConnectName(), ChangeConnectionPanelSession.this.jPanelSession));
                    TabComponent tabComponent = new TabComponent(jTabbedPane);
                    tabComponent.addButtunActionListener(MainController.this.actionClosePanelSession);
                    jTabbedPane.setTabComponentAt(jTabbedPane.indexOfComponent(ChangeConnectionPanelSession.this.jPanelSession), tabComponent);
                    ChangeConnectionPanelSession.this.jPanelSession.addHierarchyListener(((ChangeConnectionPanelSession)ChangeConnectionPanelSession.this).MainController.this.eventHierarchyParentChanged);
                    TableRowSorter<HistryTableModel> sorter = new TableRowSorter<HistryTableModel>(MainController.this.histryTableModel);
                    sorter.setRowFilter(RowFilter.regexFilter("^" + dbc.getConnectName() + "$", 6));
                    ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
                    sortKeys.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
                    JPanelHIstory jPanelHIstory = new JPanelHIstory();
                    JTable table = jPanelHIstory.getTable();
                    table.setModel(MainController.this.histryTableModel);
                    table.setRowSorter(sorter);
                    table.getRowSorter().setSortKeys(sortKeys);
                    new TableColumnFit(table).setEnableAutoFit(true);
                    ChangeConnectionPanelSession.this.jPanelSession.getJTabbedPaneSql().add(jPanelHIstory, "History", 0);
                    ((ChangeConnectionPanelSession)ChangeConnectionPanelSession.this).jPanelSession.jLabelStatus.setText("NAME=" + dbc.getConnectName() + "   " + "URL=" + dbc.getUrl() + "   " + "USER=" + dbc.getUser());
                    try {
                        MainController.this.createConnectionJpanelSql(dbc);
                    }
                    catch (Exception e) {
                        ShowDialog.errorMessage(e);
                    }
                }
            });
            try {
                DBObjectsRoot o = new DBObjectsRoot(dbc.getMetaData());
                DBobjectMutableTreeTableNode root = new DBobjectMutableTreeTableNode(o.getDBObjects().get(0), true);
                DefaultTreeTableModel model = (DefaultTreeTableModel)this.jPanelSession.getJXTreetableDBObjects().getTreeTableModel();
                model.setRoot((TreeTableNode)root);
                this.jPanelSession.addChildren(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainController.this.view.setTreeTableColumnWidth(ChangeConnectionPanelSession.this.jPanelSession, MainController.this.getConfigViewMain());
                    }
                });
            }
            catch (Exception e) {
                ShowDialog.errorMessage(e);
            }
        }

        @Override
        public void dataBaseConnectionClosed(DataBaseConnection dbc) {
            Jdbcacsess2.logger.info(this.jPanelSession.getDataBaseConnection() + " " + this.jPanelSession.getDataBaseConnection().getUrl());
        }

        @Override
        public void dataBaseConnectionClosing(DataBaseConnection dbc) {
        }
    }

    private class ChangeConnectionPanelSql
    implements DataBaseConnectionListener {
        JPanelSql jPanelSql;
        private final Runnable openedWorker = new Runnable(){

            @Override
            public void run() {
                ChangeConnectionPanelSql.this.jPanelSql.getJToggleButtonExecution().addActionListener(MainController.this.actionExecution);
                ChangeConnectionPanelSql.this.jPanelSql.getJToggleButtonConnection().addActionListener(MainController.this.actionConnection);
                ChangeConnectionPanelSql.this.jPanelSql.getJButtonContinue().addActionListener(MainController.this.actionContinue);
                ChangeConnectionPanelSql.this.jPanelSql.getJButtonCommit().addActionListener(MainController.this.actionCommit);
                ChangeConnectionPanelSql.this.jPanelSql.getJButtonRollback().addActionListener(MainController.this.actionRollback);
                Keymap keymap = ChangeConnectionPanelSql.this.jPanelSql.getRSyntaxTextAreaSql().getKeymap();
                keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 128), MainController.this.actionExecutionShortcut);
                keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(32, 128), MainController.this.actionCodeAssistDisplay);
                JTableShortcut.setJTableShortcut(ChangeConnectionPanelSql.this.jPanelSql.getJTable());
                MainController.this.view.setViewMainPanelSql(ChangeConnectionPanelSql.this.jPanelSql, MainController.this.getConfigViewMain());
                JTabbedPane jTabbedPane = MainController.this.view.getCurrentJPanelSession().getJTabbedPaneSql();
                String title = "SQL-" + Integer.toString(MainController.this.view.getCurrentJPanelSession().increaseJTabbedPanelSqlCount());
                jTabbedPane.setSelectedComponent(jTabbedPane.add(title, ChangeConnectionPanelSql.this.jPanelSql));
                TabComponent tabComponent = new TabComponent(jTabbedPane);
                tabComponent.addButtunActionListener(MainController.this.actionClosePanelSql);
                jTabbedPane.setTabComponentAt(jTabbedPane.indexOfComponent(ChangeConnectionPanelSql.this.jPanelSql), tabComponent);
                ChangeConnectionPanelSql.this.jPanelSql.addHierarchyListener(((ChangeConnectionPanelSql)ChangeConnectionPanelSql.this).MainController.this.eventHierarchyParentChanged);
            }
        };

        ChangeConnectionPanelSql(JPanelSql jPanelSql) {
            this.jPanelSql = jPanelSql;
        }

        @Override
        public void dataBaseConnectionOpened(DataBaseConnection dbc) {
            Jdbcacsess2.logger.info(dbc + " " + dbc.getUrl());
            if (MainController.this.view.getCurrentJPanelSession().getJTabbedPaneSql().indexOfComponent(this.jPanelSql) == -1) {
                SwingUtilities.invokeLater(this.openedWorker);
            }
            ShowDialog.infomationMessage(MainController.this.view, "\u65b0\u3057\u3044\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f", dbc.getConnectName());
        }

        @Override
        public void dataBaseConnectionClosing(DataBaseConnection dbc) {
        }

        @Override
        public void dataBaseConnectionClosed(DataBaseConnection dbc) {
            Jdbcacsess2.logger.info(dbc + " " + dbc.getUrl());
            ShowDialog.infomationMessage(MainController.this.view, "\u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f", dbc.getConnectName());
        }
    }

    private static class ChangeTransactionPanelSql
    implements DataBaseTransactionListener {
        private ChangeTransactionPanelSql() {
        }

        @Override
        public void autoCommitChange(DataBaseConnection dbc, boolean autoCommit) {
            Jdbcacsess2.logger.info(dbc + " " + "autocommit is " + autoCommit);
        }

        @Override
        public void commitEnd(DataBaseConnection dbc) {
            Jdbcacsess2.logger.info(dbc + " " + "commit end ");
        }

        @Override
        public void rollbackEnd(DataBaseConnection dbc) {
            Jdbcacsess2.logger.info(dbc + " " + "rollback end ");
        }
    }
}

