/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectCatalogs;
import jdbcacsess2.sqlService.dbobject.DBObjectTableTypes;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectSchemas
extends DBObjects {
    private final ArrayList<DBObjectSchema> schemas = new ArrayList();
    DBObjectCatalogs.DBObjectCatalog dbCatalog;

    public DBObjectSchemas(DBObjectCatalogs.DBObjectCatalog catalog, DatabaseMetaData dmd) throws SQLException {
        this.dbCatalog = catalog;
        ResultSet rs = dmd.getSchemas();
        while (rs.next()) {
            this.schemas.add(new DBObjectSchema(rs));
        }
        rs.close();
    }

    @Override
    public ArrayList<? extends DBObject> getDBObjects() {
        return this.schemas;
    }

    @Override
    public String toString() {
        return "SCHEMA";
    }

    public class DBObjectSchema
    extends DBObject {
        public String schemaName;
        public String catalogName;
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        public DBObjectSchema(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            int i = 0;
            if (colCnt > i) {
                this.schemaName = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_SCHEM", this.schemaName));
            }
            if (colCnt > i) {
                this.catalogName = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_CATALOG", this.catalogName));
            }
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return new DBObjectTableTypes(DBObjectSchemas.this.dbCatalog, this, dmd);
        }

        @Override
        public String getName() {
            return this.schemaName;
        }

        @Override
        public Icon getIconImage() {
            return DbObjectIconImage.SCHEMA.getValue();
        }

        @Override
        public boolean isStrong() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public String getSummary() {
            if (this.schemaName == null) {
                return "(\u7121\u3057)";
            }
            return this.schemaName;
        }

        @Override
        public boolean isPropertyEnable() {
            return false;
        }
    }
}

