/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdbcacsess2.sqlService.parse.SqlSentenceListener;
import jdbcacsess2.sqlService.parse.SqlSentenceSparateListener;

public class SqlSentenceParse {
    private String sqlSentence;
    private Pattern separatePattern;
    private SqlSentenceSparateListener sqlSentenceSparateListener;
    private final List<SqlSentenceListener> listenerList = new ArrayList<SqlSentenceListener>();
    static final char[] SYMBOLS = new char[]{',', '(', ')', '!', '+', '-', '*', '/', '=', '<', '>', ';'};

    public void registSeparatePattern(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.separatePattern = pattern;
    }

    public void registSeparateListener(SqlSentenceSparateListener sqlSentenceSparateListener) {
        this.sqlSentenceSparateListener = sqlSentenceSparateListener;
    }

    public void addSqlSentenceListener(SqlSentenceListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listenerList.add(listener);
    }

    public void removeSqlSentenceListener(SqlSentenceListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listenerList.remove(listener);
    }

    public void removeAllSqlSentenceListener() {
        this.listenerList.clear();
    }

    public void parse(String sqlSentence) {
        this.sqlSentence = sqlSentence;
        int sentenceStartPosition = 0;
        State flg = State.PHRASE;
        for (SqlSentenceListener l : this.listenerList) {
            l.started(sqlSentence);
        }
        RangePhrase rangePhrase = new RangePhrase();
        RangeComment rangeComment = new RangeComment();
        RangeConstant rangeConstant = new RangeConstant();
        RangeDelimiter rangeDelimiter = new RangeDelimiter();
        RangeSymbol rangeSymbol = new RangeSymbol();
        int i = 0;
        while (i < sqlSentence.length()) {
            char[] dst = new char[2];
            if (i == sqlSentence.length() - 1) {
                sqlSentence.getChars(i, i + 1, dst, 0);
                dst[1] = 255;
            } else {
                sqlSentence.getChars(i, i + 2, dst, 0);
            }
            flg = flg.next(dst);
            if (flg == State.HIFUNCOMMENT_START || flg == State.SLASHCOMMENT_START) {
                rangePhrase.end(i - 1);
                rangeDelimiter.end(i - 1);
                rangeComment.begin(i);
            } else if (flg == State.COMMENT_END) {
                rangeComment.end(i);
            } else if (flg == State.APOST_START) {
                rangePhrase.end(i - 1);
                rangeDelimiter.end(i - 1);
                rangeConstant.begin(i);
            } else if (flg == State.APOST_END) {
                rangeConstant.end(i);
            } else if (flg == State.DELIMITER) {
                rangePhrase.end(i - 1);
                rangeDelimiter.begin(i);
            } else if (flg == State.PHRASE) {
                rangeDelimiter.end(i - 1);
                rangePhrase.begin(i);
            } else if (flg == State.SYMBOL_CHAR) {
                rangeDelimiter.end(i - 1);
                rangePhrase.end(i - 1);
                rangeSymbol.begin(i);
                rangeSymbol.end(i);
            }
            if (this.sqlSentenceSparateListener != null && (flg == State.PHRASE || flg == State.SYMBOL_CHAR || flg == State.DELIMITER)) {
                Matcher m;
                int beginIndex = i;
                int endIndex = i + 10;
                if (endIndex > sqlSentence.length()) {
                    endIndex = sqlSentence.length();
                }
                if ((m = this.separatePattern.matcher(sqlSentence.substring(beginIndex, endIndex))).lookingAt()) {
                    for (SqlSentenceListener l : this.listenerList) {
                        l.finished(sqlSentence.substring(sentenceStartPosition, i), rangePhrase.getFirstSqlWord());
                    }
                    String matchKeyword = m.group();
                    this.sqlSentenceSparateListener.rangeSeparate(matchKeyword, i + m.start(), i + m.end(), this.separatePattern);
                    rangePhrase.setFirstSqlWord("");
                    sentenceStartPosition = i = i + m.end() - 1;
                    for (SqlSentenceListener l : this.listenerList) {
                        l.started(sqlSentence.substring(i));
                    }
                }
            }
            ++i;
        }
        rangePhrase.finish();
        rangeComment.finish();
        rangeConstant.finish();
        rangeDelimiter.finish();
        for (SqlSentenceListener l : this.listenerList) {
            l.finished(sqlSentence.substring(sentenceStartPosition), rangePhrase.getFirstSqlWord());
        }
    }

    abstract class Range {
        boolean valid = false;
        int beginPosition = Integer.MIN_VALUE;
        int endPosition = Integer.MAX_VALUE;
        private String firstSqlWord = "";

        Range() {
        }

        void begin(int beginPosition) {
            if (this.valid) {
                return;
            }
            this.beginPosition = beginPosition;
            this.valid = true;
        }

        void finish() {
            if (!this.valid) {
                return;
            }
            this.end(SqlSentenceParse.this.sqlSentence.length() - 1);
        }

        void end(int endPosition) {
            if (!this.valid) {
                return;
            }
            this.endPosition = endPosition;
            String word = SqlSentenceParse.this.sqlSentence.substring(this.beginPosition, endPosition + 1);
            for (SqlSentenceListener l : SqlSentenceParse.this.listenerList) {
                this.fire(l, word);
            }
            this.valid = false;
            if (this.getFirstSqlWord().equals("")) {
                this.setFirstSqlWord(word);
            }
        }

        abstract void fire(SqlSentenceListener var1, String var2);

        public String toString() {
            return String.valueOf(this.beginPosition) + ":" + this.endPosition;
        }

        void setFirstSqlWord(String firstSqlWord) {
            this.firstSqlWord = firstSqlWord;
        }

        String getFirstSqlWord() {
            return this.firstSqlWord.toUpperCase();
        }
    }

    class RangeComment
    extends Range {
        RangeComment() {
        }

        @Override
        void fire(SqlSentenceListener l, String sqlWord) {
            l.rangeComment(sqlWord, this.beginPosition, this.endPosition);
        }
    }

    class RangeConstant
    extends Range {
        RangeConstant() {
        }

        @Override
        void fire(SqlSentenceListener l, String sqlWord) {
            l.rangeConstant(sqlWord, this.beginPosition, this.endPosition);
        }
    }

    class RangeDelimiter
    extends Range {
        RangeDelimiter() {
        }

        @Override
        void fire(SqlSentenceListener l, String sqlWord) {
            l.rangeDelimiter(sqlWord, this.beginPosition, this.endPosition);
        }
    }

    class RangePhrase
    extends Range {
        RangePhrase() {
        }

        @Override
        void fire(SqlSentenceListener l, String sqlWord) {
            if (sqlWord.startsWith(":") || sqlWord.equals("?")) {
                l.rangeInput(sqlWord, this.beginPosition, this.endPosition);
            } else {
                l.rangePhrase(sqlWord, this.beginPosition, this.endPosition);
            }
        }
    }

    class RangeSymbol
    extends Range {
        RangeSymbol() {
        }

        @Override
        void fire(SqlSentenceListener l, String sqlWord) {
            l.rangeSymbol(sqlWord, this.beginPosition, this.endPosition);
        }
    }

    static enum State {
        PHRASE{

            @Override
            public State next(char[] dst) {
                if (dst[0] == '/' && dst[1] == '*') {
                    return SLASHCOMMENT_START;
                }
                if (dst[0] == '-' && dst[1] == '-') {
                    return HIFUNCOMMENT_START;
                }
                if (dst[0] == '\'') {
                    return APOST_START;
                }
                if (dst[0] == ' ' || dst[0] == '\t' || dst[0] == '\n') {
                    return DELIMITER;
                }
                int i = 0;
                while (i < SYMBOLS.length) {
                    if (dst[0] == SYMBOLS[i]) {
                        return SYMBOL_CHAR;
                    }
                    ++i;
                }
                return this;
            }
        }
        ,
        SYMBOL_CHAR{

            @Override
            public State next(char[] dst) {
                return PHRASE.next(dst);
            }
        }
        ,
        APOST_START{

            @Override
            public State next(char[] dst) {
                if ((dst[0] == '\'' || dst[0] == '\\') && dst[1] == '\'') {
                    return APOST_ESCAPE;
                }
                if ((dst[0] == '\'' || dst[0] == '\\') && dst[1] != '\'') {
                    return APOST_END;
                }
                return APOST;
            }
        }
        ,
        APOST{

            @Override
            public State next(char[] dst) {
                if ((dst[0] == '\'' || dst[0] == '\\') && dst[1] == '\'') {
                    return APOST_ESCAPE;
                }
                if ((dst[0] == '\'' || dst[0] == '\\') && dst[1] != '\'') {
                    return APOST_END;
                }
                return this;
            }
        }
        ,
        APOST_ESCAPE{

            @Override
            public State next(char[] dst) {
                return APOST;
            }
        }
        ,
        APOST_END{

            @Override
            public State next(char[] dst) {
                return PHRASE.next(dst);
            }
        }
        ,
        SLASHCOMMENT_START{

            @Override
            public State next(char[] dst) {
                return SLASHCOMMENT;
            }
        }
        ,
        SLASHCOMMENT{

            @Override
            public State next(char[] dst) {
                if (dst[0] == '*' && dst[1] == '/') {
                    return SLASHCOMMENT_PREEND;
                }
                return this;
            }
        }
        ,
        SLASHCOMMENT_PREEND{

            @Override
            public State next(char[] dst) {
                return COMMENT_END;
            }
        }
        ,
        HIFUNCOMMENT_START{

            @Override
            public State next(char[] dst) {
                return HIFUNCOMMENT;
            }
        }
        ,
        HIFUNCOMMENT{

            @Override
            public State next(char[] dst) {
                if (dst[0] == '\n') {
                    return COMMENT_END;
                }
                return this;
            }
        }
        ,
        COMMENT_END{

            @Override
            public State next(char[] dst) {
                return PHRASE.next(dst);
            }
        }
        ,
        DELIMITER{

            @Override
            public State next(char[] dst) {
                return PHRASE.next(dst);
            }
        };


        public abstract State next(char[] var1);
    }
}

