/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.utilMain;

public class mtTestCase {
    public String name = null;
    public String file = null;
    public String propFile = null;
    public float weight = 0.5f;
    public Hashtable ignoreErrors = null;
    public String description = null;
    private int iterations;
    private int attempts;

    public void mtTestCase() {
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setInputDir(String string) {
        this.file = string + "/" + this.file;
    }

    public String getFile() {
        return this.file;
    }

    public void setPropFile(String string) {
        this.propFile = string;
    }

    public String getPropFile() {
        return this.propFile;
    }

    public void setWeight(int n) {
        this.weight = (float)((double)n / 100.0);
    }

    public void setIgnoreErrors(Hashtable hashtable) {
        this.ignoreErrors = hashtable;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public synchronized BufferedInputStream initialize() throws FileNotFoundException, IOException {
        return this.initialize(null);
    }

    public synchronized BufferedInputStream initialize(String string) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = null;
        if (this.propFile != null) {
            String string2;
            BufferedInputStream bufferedInputStream2;
            String string3 = string == null ? this.propFile : string + "/" + this.propFile;
            try {
                bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string3));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(this.name + ": unable to find properties file " + string3);
                throw fileNotFoundException;
            }
            Properties properties = System.getProperties();
            properties.load(bufferedInputStream2);
            String string4 = properties.getProperty("framework");
            if (string4 != null) {
                string2 = null;
                if ((string4 = string4.toUpperCase(Locale.ENGLISH)).equals("DB2JNET") || string4.equals("DERBYNET")) {
                    string2 = "jdbc:derby:net://localhost:1527/";
                } else if (string4.equals("DERBYNETCLIENT")) {
                    string2 = "jdbc:derby://localhost:1527/";
                }
                if (string2 != null) {
                    this.updateURLProperties(properties, string2);
                    properties.setProperty("ij.user", "APP");
                    properties.setProperty("ij.password", "PWD");
                }
            }
            if ("true".equalsIgnoreCase(properties.getProperty("encryption"))) {
                string2 = "dataEncryption=true;bootPassword=Thursday";
                String string5 = properties.getProperty("ij.database");
                String string6 = properties.getProperty("encryptionAlgorithm");
                if (string6 != null) {
                    properties.setProperty("ij.database", string5 + ";" + string2 + ";" + string6);
                } else {
                    properties.setProperty("ij.database", string5 + ";" + string2);
                }
            }
            if (System.getProperty("ij.dataSource") != null) {
                properties.remove("ij.database");
                properties.remove("ij.protocol");
            }
            System.setProperties(properties);
        }
        String string7 = string == null ? this.file : string + "/" + this.file;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string7), 2048);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("unable to find properties file " + string7);
            throw fileNotFoundException;
        }
        return bufferedInputStream;
    }

    public synchronized boolean grab() {
        ++this.attempts;
        if (Math.random() < (double)this.weight) {
            ++this.iterations;
            return true;
        }
        return false;
    }

    public void runMe(LocalizedOutput localizedOutput, LocalizedOutput localizedOutput2, BufferedInputStream bufferedInputStream) {
        LocalizedInput localizedInput = LocalizedResource.getInstance().getNewInput((InputStream)bufferedInputStream);
        LocalizedInput[] localizedInputArray = new LocalizedInput[]{localizedInput};
        localizedOutput2.println("--------------" + this.file + "-----------------");
        utilMain utilMain2 = new utilMain(1, localizedOutput2, this.ignoreErrors);
        utilMain2.initFromEnvironment();
        utilMain2.setMtUse(true);
        utilMain2.go(localizedInputArray, localizedOutput2);
        localizedOutput.flush();
        localizedOutput2.flush();
    }

    public void updateURLProperties(Properties properties, String string) {
        String[] stringArray = new String[]{"ij.database", "ij.protocol", "database"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            properties.setProperty(string2, this.alterURL(string3, string));
        }
    }

    public String alterURL(String string, String string2) {
        String string3 = "jdbc:derby:";
        if (string.startsWith(string2)) {
            return string;
        }
        if (string2 == null) {
            return string;
        }
        if (string.equals(string3)) {
            return string2;
        }
        if (string.startsWith(string3)) {
            string = string2 + string.substring(string3.length());
        } else if (!string.startsWith("jdbc:")) {
            string = string2 + string;
        }
        return string;
    }

    public String toString() {
        return "name: " + this.name + "\n\tfile: " + this.file + "\n\tproperties: " + this.propFile + "\n\tweight: " + this.weight + "\n\tignoreErrors: " + this.ignoreErrors + "\n\tdescription: " + this.description;
    }
}

