/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ConnectionMethodsTest;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Conn;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AbortTest
extends Wrapper41Test {
    private boolean _hasSecurityManager;

    public AbortTest(String name, boolean hasSecurityManager) {
        super(name);
        this._hasSecurityManager = hasSecurityManager;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AbortTest");
        suite.addTest(AbortTest.baseSuite(true));
        suite.addTest(AbortTest.baseSuite(false));
        suite.addTest(TestConfiguration.clientServerDecorator(AbortTest.baseSuite(true)));
        suite.addTest(TestConfiguration.clientServerDecorator(AbortTest.baseSuite(false)));
        return suite;
    }

    public static Test baseSuite(boolean hasSecurityManager) {
        AbortTest abortTest = new AbortTest("test_basic", hasSecurityManager);
        CleanDatabaseTestSetup test = new CleanDatabaseTestSetup((Test)abortTest){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table abort_table( a int )");
            }
        };
        if (hasSecurityManager) {
            return new SecurityManagerSetup((Test)test, "org/apache/derbyTesting/functionTests/tests/jdbc4/noAbortPermission.policy");
        }
        return SecurityManagerSetup.noSecurityManager((Test)test);
    }

    public void test_basic() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        AbortTest.println("AbortTest( " + this._hasSecurityManager + " )");
        AbortTest.assertEquals((boolean)this._hasSecurityManager, (System.getSecurityManager() != null ? 1 : 0) != 0);
        this.physical();
        this.pooled();
        this.xa();
    }

    private void physical() throws Exception {
        Connection conn0 = this.openUserConnection("user0");
        Connection conn1 = this.openUserConnection("user1");
        Connection conn2 = this.openUserConnection("user2");
        this.vet(conn0, conn1, conn2);
    }

    private void pooled() throws Exception {
        ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection conn0 = this.getPooledConnection(cpDs, "user3");
        PooledConnection conn1 = this.getPooledConnection(cpDs, "user4");
        PooledConnection conn2 = this.getPooledConnection(cpDs, "user5");
        this.vet(conn0.getConnection(), conn1.getConnection(), conn2.getConnection());
    }

    private PooledConnection getPooledConnection(ConnectionPoolDataSource cpDs, String userName) throws Exception {
        return cpDs.getPooledConnection(userName, this.getTestConfiguration().getPassword(userName));
    }

    private void xa() throws Exception {
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection conn0 = this.getXAConnection(xads, "user6");
        XAConnection conn1 = this.getXAConnection(xads, "user7");
        XAConnection conn2 = this.getXAConnection(xads, "user8");
        this.vet(conn0.getConnection(), conn1.getConnection(), conn2.getConnection());
    }

    private XAConnection getXAConnection(XADataSource xads, String userName) throws Exception {
        return xads.getXAConnection(userName, this.getTestConfiguration().getPassword(userName));
    }

    public void vet(Connection conn0, Connection conn1, Connection conn2) throws Exception {
        AbortTest.assertNotNull((Object)conn0);
        AbortTest.assertNotNull((Object)conn1);
        AbortTest.assertNotNull((Object)conn2);
        conn0.close();
        Wrapper41Conn wrapper0 = new Wrapper41Conn(conn0);
        wrapper0.abort(new ConnectionMethodsTest.DirectExecutor());
        conn1.setAutoCommit(false);
        Wrapper41Conn wrapper1 = new Wrapper41Conn(conn1);
        try {
            wrapper1.abort(null);
        }
        catch (SQLException se) {
            AbortTest.assertSQLState("XCZ02", se);
        }
        if (this._hasSecurityManager) {
            this.missingPermission(wrapper1);
        } else {
            this.noSecurityManager(wrapper1, conn2);
        }
    }

    private void missingPermission(final Wrapper41Conn wrapper1) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConnectionMethodsTest.DirectExecutor executor = new ConnectionMethodsTest.DirectExecutor();
                    wrapper1.abort(executor);
                    return null;
                }
            });
            AbortTest.fail((String)"The call to Connection.abort(Executor) should have failed.");
        }
        catch (Exception e) {
            AbortTest.assertTrue((boolean)(e instanceof AccessControlException));
        }
    }

    private void noSecurityManager(Wrapper41Conn wrapper1, Connection conn2) throws Exception {
        PreparedStatement ps = this.prepareStatement(wrapper1.getWrappedObject(), "insert into app.abort_table( a ) values ( 1 )");
        ps.execute();
        ps.close();
        ConnectionMethodsTest.DirectExecutor executor = new ConnectionMethodsTest.DirectExecutor();
        wrapper1.abort(executor);
        try {
            this.prepareStatement(wrapper1.getWrappedObject(), "select * from sys.systables");
            AbortTest.fail((String)"Connection should be dead!");
        }
        catch (SQLException se) {
            AbortTest.assertSQLState("08003", se);
        }
        ps = this.prepareStatement(conn2, "select * from app.abort_table");
        ResultSet rs = ps.executeQuery();
        AbortTest.assertFalse((boolean)rs.next());
        rs.close();
        ps.close();
        conn2.close();
    }
}

