/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class LobSortTest
extends BaseJDBCTestCase {
    private static final long SEED = System.currentTimeMillis();

    public LobSortTest(String name) {
        super(name);
    }

    public String getName() {
        return super.getName() + "-" + SEED;
    }

    public void testBlobMixed() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS order by length(b)");
    }

    public void testBlobSmall() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS where blen < 2000 order by length(b)");
    }

    public void testBlobLarge() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS where blen > 34000 order by length(b)");
    }

    public void testBlobClob() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS order by length(c), length(b)");
    }

    public void testBlobRandom() throws SQLException {
        this.fetchIterateGetLengthBlob("select blen, b from MIXED_LOBS order by rnd");
    }

    public void testClobMixed() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS order by length(c)");
    }

    public void testClobSmall() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS where clen < 2000 order by length(c)");
    }

    public void testClobLarge() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS where clen > 34000 order by length(c)");
    }

    public void testClobBlob() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS order by length(b), length(c)");
    }

    public void testClobRandom() throws SQLException {
        this.fetchIterateGetLengthClob("select clen, c from MIXED_LOBS order by rnd");
    }

    private void fetchIterateGetLengthBlob(String sql) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            LobSortTest.assertEquals((int)rs.getInt(1), (int)rs.getBytes(2).length);
        }
        rs.close();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            LobSortTest.assertEquals((int)rs.getInt(1), (int)((int)rs.getBlob(2).length()));
        }
        rs.close();
        stmt.close();
    }

    private void fetchIterateGetLengthClob(String sql) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            LobSortTest.assertEquals((int)rs.getInt(1), (int)rs.getString(2).length());
        }
        rs.close();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            LobSortTest.assertEquals((int)rs.getInt(1), (int)((int)rs.getClob(2).length()));
        }
        rs.close();
        stmt.close();
    }

    public static Test suite() {
        Properties props = new Properties();
        props.setProperty("derby.storage.sortBufferMax", "4");
        TestSuite suite = new TestSuite(LobSortTest.class, "LobSortTestEmbedded");
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup((Test)suite, props, true)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                Random rnd = new Random(SEED);
                Connection con = s.getConnection();
                con.setAutoCommit(false);
                s.executeUpdate("create table MIXED_LOBS (c clob, clen int, b blob, blen int, rnd int)");
                PreparedStatement ps = con.prepareStatement("insert into MIXED_LOBS values (?,?,?,?,?)");
                ps.setString(1, "");
                ps.setInt(2, 0);
                ps.setBytes(3, new byte[0]);
                ps.setInt(4, 0);
                ps.setInt(5, rnd.nextInt());
                ps.executeUpdate();
                for (int i = 0; i < 100; ++i) {
                    CharAlphabet ca = this.getCharAlphabet(1 + rnd.nextInt(3));
                    int length = (int)(rnd.nextDouble() * 64.0 * 1024.0);
                    if (rnd.nextInt(1000) < 500) {
                        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)length, ca), length);
                    } else {
                        ps.setCharacterStream(1, new LoopingAlphabetReader((long)length, ca));
                    }
                    ps.setInt(2, length);
                    length = (int)(rnd.nextDouble() * 64.0 * 1024.0);
                    if (rnd.nextInt(1000) < 500) {
                        ps.setBinaryStream(3, (InputStream)new LoopingAlphabetStream(length), length);
                    } else {
                        ps.setBinaryStream(3, new LoopingAlphabetStream(length));
                    }
                    ps.setInt(4, length);
                    ps.setInt(5, rnd.nextInt());
                    ps.executeUpdate();
                }
                con.commit();
                ps.close();
            }

            private CharAlphabet getCharAlphabet(int i) {
                switch (i) {
                    case 1: {
                        return CharAlphabet.modernLatinLowercase();
                    }
                    case 2: {
                        return CharAlphabet.tamil();
                    }
                    case 3: {
                        return CharAlphabet.cjkSubset();
                    }
                }
                1.fail((String)("Unknown alphabet identifier: " + i));
                return null;
            }
        };
    }
}

