/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class BlobClob4BlobTest
extends BaseJDBCTestCase {
    private static final String BLOB_BAD_POSITION = "XJ070";
    private static final String BLOB_NONPOSITIVE_LENGTH = "XJ071";
    private static final String BLOB_POSITION_TOO_LARGE = "XJ076";
    private static final String LANG_DATA_TYPE_GET_MISMATCH = "22005";
    private static final String BLOB_NULL_PATTERN_OR_SEARCH_STR = "XJ072";
    private static final String LOCK_TIMEOUT = "40XL1";
    private static final String NO_CURRENT_CONNECTION = "08003";
    private static final String INVALID_LOB = "XJ215";

    public BlobClob4BlobTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CREATE TABLE testClob (b INT, c INT)");
        stmt.executeUpdate("ALTER TABLE testClob ADD COLUMN a CLOB(300K)");
        stmt.executeUpdate("CREATE TABLE testBlob (b INT)");
        stmt.executeUpdate("ALTER TABLE testBlob ADD COLUMN a blob(300k)");
        stmt.executeUpdate("ALTER TABLE testBlob ADD COLUMN crc32 BIGINT");
        stmt.close();
        this.commit();
    }

    protected void tearDown() throws Exception {
        this.rollback();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("DROP TABLE testClob");
        stmt.executeUpdate("DROP TABLE testBlob");
        stmt.close();
        this.commit();
        super.tearDown();
    }

    public void testUnconsumedParameter() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = conn.createStatement();
        s.executeUpdate("create table testing(num int, addr varchar(40), contents blob(16M))");
        byte[] data = new byte[38000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 97;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        String sql = "UPDATE testing SET Contents=? WHERE num=1";
        PreparedStatement ps = this.prepareStatement(sql);
        ps.setBinaryStream(1, (InputStream)is, data.length);
        this.commit();
        ps.executeUpdate();
        s.executeUpdate("insert into testing values (1,null,null)");
        is = new ByteArrayInputStream(data);
        ps.setBinaryStream(1, (InputStream)is, data.length);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("select length(contents) from testing where num = 1");
        JDBC.assertSingleValueResultSet(rs, "38000");
        ps.close();
        conn.commit();
        is = new ByteArrayInputStream(data);
        sql = "UPDATE testing SET Contents=? WHERE num=2";
        ps = this.prepareStatement(sql);
        ps.setBinaryStream(1, (InputStream)is, data.length);
        ps.executeUpdate();
        ps.close();
        s.executeUpdate("drop table testing");
        conn.commit();
        s.executeUpdate("create table testing(num int, addr varchar(40), contents blob(16M),contents2 blob(16M))");
        is = new ByteArrayInputStream(data);
        ByteArrayInputStream is2 = new ByteArrayInputStream(data);
        sql = "UPDATE testing SET Contents=?, contents2=?  WHERE num=1";
        ps = this.prepareStatement(sql);
        ps.setBinaryStream(1, (InputStream)is, data.length);
        ps.setBinaryStream(2, (InputStream)is2, data.length);
        ps.executeUpdate();
        s.executeUpdate("insert into testing values (1,'addr',NULL,NULL)");
        is = new ByteArrayInputStream(data);
        is2 = new ByteArrayInputStream(data);
        ps.setBinaryStream(1, (InputStream)is, data.length);
        ps.setBinaryStream(2, (InputStream)is2, data.length);
        ps.executeUpdate();
        rs = s.executeQuery("select length(contents), length(contents2) from testing where num = 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"38000", "38000"}});
        rs.close();
        s.executeUpdate("drop table testing");
        s.executeUpdate("create table testing(num int, addr varchar(40), contents Clob(16M))");
        char[] charData = new char[38000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 97;
        }
        CharArrayReader reader = new CharArrayReader(charData);
        sql = "UPDATE testing SET Contents=? WHERE num=1";
        ps = this.prepareStatement(sql);
        ps.setCharacterStream(1, (Reader)reader, charData.length);
        ps.executeUpdate();
        s.executeUpdate("insert into testing values (1,null,null)");
        reader = new CharArrayReader(charData);
        ps.setCharacterStream(1, (Reader)reader, data.length);
        ps.executeUpdate();
        rs = s.executeQuery("select length(contents) from testing where num = 1");
        JDBC.assertSingleValueResultSet(rs, "38000");
        s.executeUpdate("drop table testing");
        ps.close();
        conn.commit();
    }

    public void testIsolationLevelChangeAfterRead() throws SQLException {
        ResultSet rs = this.createStatement().executeQuery("VALUES CAST(X'FFFF' AS BLOB)");
        JDBC.assertDrainResults(rs);
        this.getConnection().setTransactionIsolation(8);
    }

    public void testSetCharacterStream() throws Exception {
        int clobLength = 5009;
        PreparedStatement ps = this.prepareStatement("insert into testClob (a) values(?)");
        LoopingAlphabetReader streamReader = new LoopingAlphabetReader((long)clobLength, CharAlphabet.tamil());
        ps.setCharacterStream(1, (Reader)streamReader, clobLength);
        this.commit();
        ps.executeUpdate();
        ((Reader)streamReader).close();
        ps.close();
        this.commit();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT a FROM testClob");
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (long)clobLength, (long)clob.length());
            Reader clobValue = clob.getCharacterStream();
            LoopingAlphabetReader origValue = new LoopingAlphabetReader((long)clobLength, CharAlphabet.tamil());
            BlobClob4BlobTest.assertTrue((String)"New clob value did not match", (boolean)this.compareReaders(origValue, clobValue));
            ((Reader)origValue).close();
            clobValue.close();
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testGetAsciiStream() throws Exception {
        byte[] buff = new byte[1024];
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT a, b FROM testClob");
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int clobLength = rs.getInt(2);
            if (clob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob.length()", (long)clobLength, (long)clob.length());
                InputStream fin = clob.getAsciiStream();
                int columnSize = 0;
                int size = -1;
                do {
                    columnSize += (size = fin.read(buff)) > 0 ? size : 0;
                } while (size >= 0);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)clobLength, (int)columnSize);
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"Clob was null but length was not 0", (clobLength == 0 ? 1 : 0) != 0);
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testGetCharacterStream() throws Exception {
        char[] buff = new char[128];
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a , b from testClob");
        ResultSetMetaData met = rs.getMetaData();
        int clobLength = 0;
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            clobLength = rs.getInt(2);
            if (clob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob.length()", (long)clobLength, (long)clob.length());
                Reader reader = clob.getCharacterStream();
                int columnSize = 0;
                int size = -1;
                do {
                    columnSize += (size = reader.read(buff)) >= 0 ? size : 0;
                } while (size >= 0);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)clobLength, (int)columnSize);
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"Clob was null but length was not 0", (clobLength == 0 ? 1 : 0) != 0);
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testGetCharacterStreamWithUnicode() throws Exception {
        String[] unicodeStrings = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(unicodeStrings);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT a, b, c FROM testClob");
        int clobLength = 0;
        int arrayIndex = 0;
        while (rs.next()) {
            clobLength = rs.getInt(2);
            arrayIndex = rs.getInt(3);
            Clob clob = rs.getClob(1);
            if (clob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob.length()", (long)clobLength, (long)clob.length());
                Reader clobValue = clob.getCharacterStream();
                if (arrayIndex > 0) {
                    char[] buff = new char[3];
                    clobValue.read(buff);
                    BlobClob4BlobTest.assertEquals((String)"Clob value does not match unicodeString", (String)unicodeStrings[arrayIndex], (String)new String(buff));
                    BlobClob4BlobTest.assertEquals((String)"Expected end of stream", (int)-1, (int)clobValue.read());
                    continue;
                }
                LoopingAlphabetReader origValue = new LoopingAlphabetReader((long)clobLength, CharAlphabet.tamil());
                this.compareReaders(origValue, clobValue);
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"Clob was null but length was not 0", (clobLength == 0 ? 1 : 0) != 0);
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testTriggersWithClobColumn() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CREATE TABLE testClobTriggerA (a CLOB(400k), b int)");
        stmt.executeUpdate("CREATE TABLE testClobTriggerB (a CLOB(400k), b int)");
        stmt.executeUpdate("create trigger T13A after update on testClob referencing new as n old as o for each row insert into testClobTriggerA(a, b) values (n.a, n.b)");
        stmt.executeUpdate("create trigger T13B after INSERT on testClobTriggerA referencing new table as n for each statement insert into testClobTriggerB(a, b) select n.a, n.b from n");
        this.commit();
        stmt.executeUpdate("UPDATE testClob SET b = b + 0");
        this.commit();
        Statement origSt = this.createStatement();
        Statement trigASt = this.createStatement();
        Statement trigBSt = this.createStatement();
        ResultSet origRS = origSt.executeQuery("select a, length(a), b  from testClob order by b");
        ResultSet trigARS = trigASt.executeQuery("select a, length(a), b from testClobTriggerA order by b");
        ResultSet trigBRS = trigBSt.executeQuery("select a, length(a), b from testClobTriggerB order by b");
        int count = 0;
        while (origRS.next()) {
            BlobClob4BlobTest.assertTrue((String)("row trigger produced less rows " + ++count), (boolean)trigARS.next());
            BlobClob4BlobTest.assertTrue((String)("statement trigger produced less rows " + count), (boolean)trigBRS.next());
            Clob origClob = origRS.getClob(1);
            if (origClob != null) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid checksum for row trigger", (long)this.getStreamCheckSum(origClob.getAsciiStream()), (long)this.getStreamCheckSum(trigARS.getClob(1).getAsciiStream()));
                BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid checksum for statement trigger", (long)this.getStreamCheckSum(origClob.getAsciiStream()), (long)this.getStreamCheckSum(trigBRS.getClob(1).getAsciiStream()));
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid length in row trigger", (int)origRS.getInt(2), (int)trigARS.getInt(2));
            BlobClob4BlobTest.assertEquals((String)"FAIL - Invalid length in statement trigger", (int)origRS.getInt(2), (int)trigBRS.getInt(2));
            BlobClob4BlobTest.assertEquals((String)"FAIL - Length not updated on row trigger", (int)origRS.getInt(3), (int)trigARS.getInt(3));
            BlobClob4BlobTest.assertEquals((String)"FAIL - Length not updated on statement trigger", (int)origRS.getInt(3), (int)trigBRS.getInt(3));
        }
        origRS.close();
        trigARS.close();
        trigBRS.close();
        origSt.close();
        trigASt.close();
        trigBSt.close();
        stmt.executeUpdate("DROP TRIGGER T13A");
        stmt.executeUpdate("DROP TRIGGER T13B");
        stmt.executeUpdate("DROP TABLE testClobTriggerB");
        stmt.executeUpdate("DROP TABLE testClobTriggerA");
        stmt.close();
        this.commit();
    }

    public void testGetSubString() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        int clobLength = 0;
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            if (clob == null) continue;
            clobLength = rs.getInt(2);
            this.verifyInterval(clob, 9905L, 50, 0, clobLength);
            this.verifyInterval(clob, 5910L, 150, 1, clobLength);
            this.verifyInterval(clob, 5910L, 50, 2, clobLength);
            this.verifyInterval(clob, 204L, 50, 3, clobLength);
            this.verifyInterval(clob, 68L, 50, 4, clobLength);
            this.verifyInterval(clob, 1L, 50, 5, clobLength);
            this.verifyInterval(clob, 1L, 1, 6, clobLength);
            this.verifyInterval(clob, 1L, 0, 7, clobLength);
            this.verifyInterval(clob, (long)(clobLength + 1), 0, 8, clobLength);
            if (clobLength <= 100) continue;
            String res = clob.getSubString(clobLength - 99, 200);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong length of substring", (int)100, (int)res.length());
        }
        rs.close();
        stmt.close();
    }

    public void testGetSubStringWithUnicode() throws Exception {
        String[] unicodeStrings = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(unicodeStrings);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b, c from testClob");
        int clobLength = 0;
        int arrayIndex = 0;
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            clobLength = rs.getInt(2);
            arrayIndex = rs.getInt(3);
            if (clob == null) continue;
            if (arrayIndex >= 0) {
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring returned", (String)unicodeStrings[arrayIndex], (String)clob.getSubString(1L, 3));
                continue;
            }
            if (clob.length() <= 0L) continue;
            long charsToRead = Math.min(clob.length() / 3L, 2048L);
            char[] charValue = new char[(int)charsToRead];
            Reader clobReader = clob.getCharacterStream();
            clobReader.read(charValue);
            clobReader.read(charValue);
            String subString = clob.getSubString(charsToRead + 1L, (int)charsToRead);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring length", (int)charValue.length, (int)subString.length());
            for (int i = 0; i < charValue.length; ++i) {
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong substring returned at " + i), (char)charValue[i], (char)subString.charAt(i));
            }
        }
        rs.close();
        stmt.close();
    }

    public void testPositionString() throws Exception {
        this.insertDefaultData();
        this.runPositionStringTest();
    }

    public void testPositionStringWithUnicode() throws Exception {
        String[] unicodeStrings = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(unicodeStrings);
        this.runPositionStringTest();
    }

    private void runPositionStringTest() throws Exception {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        int clobLength = 0;
        Random random = new Random();
        int maxStartPointDistance = CharAlphabet.MODERNLATINLOWER.length;
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            clobLength = rs.getInt(2);
            if (clob == null || clobLength <= 0) continue;
            BlobClob4BlobTest.println("\n\nclobLength: " + clobLength);
            for (int i = 0; i < 10; ++i) {
                int start = Math.max(random.nextInt(clobLength - 1), 1);
                int length = random.nextInt(clobLength - start) + 1;
                BlobClob4BlobTest.println("start:" + start + " length:" + length);
                String searchString = clob.getSubString(start, length);
                int distance = random.nextInt(maxStartPointDistance);
                int startSearchPos = Math.max(start - distance, 1);
                String tmp = clob.getSubString(startSearchPos, start);
                if (tmp.indexOf(searchString) != -1) {
                    startSearchPos = start;
                }
                BlobClob4BlobTest.println("startSearchPos: " + startSearchPos + "searchString: " + searchString);
                long foundAt = clob.position(searchString, (long)startSearchPos);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + searchString + " start at " + startSearchPos + " with length " + searchString.length()), (long)start, (long)foundAt);
            }
        }
        rs.close();
        stmt.close();
    }

    public void testPositionClob() throws Exception {
        this.insertDefaultData();
        this.runPositionClobTest();
    }

    public void testPositionClobWithUnicode() throws Exception {
        String[] unicodeStrings = new String[]{"abc", "\u0370\u0371\u0372", "\u05d0\u05d1\u05d2"};
        this.insertUnicodeData(unicodeStrings);
        this.runPositionClobTest();
    }

    private void runPositionClobTest() throws Exception {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        int clobLength = 0;
        Statement stmt2 = this.createStatement();
        Random random = new Random();
        int maxStartPointDistance = CharAlphabet.MODERNLATINLOWER.length;
        while (rs.next()) {
            int startSearchPos;
            String searchString;
            int start;
            Clob clob = rs.getClob(1);
            clobLength = rs.getInt(2);
            if (clob == null || clobLength <= 0) continue;
            BlobClob4BlobTest.println("\n\nclobLength: " + clobLength);
            stmt2.executeUpdate("CREATE TABLE searchClob (a clob(300K), start int, position int)");
            PreparedStatement ps = this.prepareStatement("INSERT INTO searchClob values (?, ?, ?) ");
            for (int i = 0; i < 10; ++i) {
                start = Math.max(random.nextInt(clobLength - 1), 1);
                int length = random.nextInt(clobLength - start) + 1;
                BlobClob4BlobTest.println("start:" + start + " length:" + length);
                searchString = clob.getSubString(start, length);
                int distance = random.nextInt(maxStartPointDistance);
                startSearchPos = Math.max(start - distance, 1);
                String tmp = clob.getSubString(startSearchPos, start);
                if (tmp.indexOf(searchString) != -1) {
                    startSearchPos = start;
                }
                ps.setString(1, searchString);
                ps.setInt(2, startSearchPos);
                ps.setInt(3, start);
                ps.executeUpdate();
            }
            ps.close();
            ResultSet rs2 = stmt2.executeQuery("SELECT a, start, position FROM searchClob");
            while (rs2.next()) {
                Clob searchClob = rs2.getClob(1);
                startSearchPos = rs2.getInt(2);
                start = rs2.getInt(3);
                searchString = searchClob.getSubString(1L, (int)searchClob.length());
                BlobClob4BlobTest.println("startSearchPos: " + startSearchPos + "searchString: " + searchString);
                long foundAt = clob.position(searchClob, (long)startSearchPos);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + searchString + " starting at " + startSearchPos + " with length " + searchString.length()), (long)start, (long)foundAt);
            }
            rs2.close();
            stmt2.executeUpdate("DROP TABLE searchClob");
        }
        rs.close();
        stmt.close();
        stmt2.close();
    }

    public void testSmallClobFields() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("ALTER TABLE testClob ADD COLUMN smallClob CLOB(10)");
        PreparedStatement ps = this.prepareStatement("insert into testClob (smallClob) values(?)");
        String val = "";
        for (int i = 0; i < 10; ++i) {
            ps.setString(1, val);
            ps.executeUpdate();
            val = val + "x";
        }
        ResultSet rs = stmt.executeQuery("select a from testClob");
        byte[] buff = new byte[128];
        int j = 0;
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            if (clob == null) continue;
            InputStream fin = clob.getAsciiStream();
            int columnSize = 0;
            int size = 0;
            do {
                columnSize += (size = fin.read(buff)) > 0 ? size : 0;
            } while (size != -1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob size", (int)j, (int)columnSize);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (long)j, (long)clob.length());
            ++j;
        }
        rs.close();
        stmt.close();
    }

    public void testGetClobFromIntColumn() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select b from testClob");
        while (rs.next()) {
            try {
                Clob clob = rs.getClob(1);
                rs.close();
                stmt.close();
                BlobClob4BlobTest.fail((String)"FAIL - getClob on column type int should throw an exception");
            }
            catch (SQLException se) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, se);
            }
        }
        rs.close();
        stmt.close();
    }

    public void testSetClobToIntColumn() throws Exception {
        this.insertDefaultData();
        PreparedStatement ps = this.prepareStatement("insert into testClob (b, c) values (?, ?)");
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int clobLength = rs.getInt(2);
            if (clob == null) continue;
            try {
                ps.setClob(1, clob);
                ps.setInt(2, clobLength);
                ps.executeUpdate();
                rs.close();
                stmt.close();
                BlobClob4BlobTest.fail((String)"FAIL - can not use setClob on int column");
            }
            catch (SQLException se) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, se);
            }
        }
        rs.close();
        stmt.close();
    }

    public void testRaisingOfExceptionsClob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob WHERE a is not NULL");
        boolean i = false;
        int clobLength = 0;
        rs.next();
        Clob clob = rs.getClob(1);
        clobLength = rs.getInt(2);
        rs.close();
        BlobClob4BlobTest.assertFalse((String)"FAIL - clob can not be null", (clob == null ? 1 : 0) != 0);
        try {
            clob.getSubString(0L, 5);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with 0 as position should have caused an exception");
        }
        catch (SQLException e) {
            this.checkException(BLOB_BAD_POSITION, e);
        }
        try {
            clob.getSubString(1L, -76);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with negative length should have caused an exception");
        }
        catch (SQLException e) {
            this.checkException(BLOB_NONPOSITIVE_LENGTH, e);
        }
        try {
            clob.getSubString(1L, -1);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with negative length should have caused an exception");
        }
        catch (SQLException e) {
            this.checkException(BLOB_NONPOSITIVE_LENGTH, e);
        }
        try {
            clob.getSubString(0L, 0);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with 0 as position should have caused an exception");
        }
        catch (SQLException e) {
            this.checkException(BLOB_BAD_POSITION, e);
        }
        try {
            clob.getSubString(clobLength + 2, 0);
            BlobClob4BlobTest.fail((String)"FAIL - getSubString with position bigger than clob should have caused an exception");
        }
        catch (SQLException e) {
            this.checkException(BLOB_POSITION_TOO_LARGE, e);
        }
        catch (StringIndexOutOfBoundsException se) {
            BlobClob4BlobTest.assertTrue((String)"FAIL - This exception should only happen with DB2 client", (boolean)BlobClob4BlobTest.usingDB2Client());
        }
        try {
            clob.position("xx", -4000L);
            BlobClob4BlobTest.fail((String)"FAIL - position with negative as position should have caused an exception");
        }
        catch (SQLException e) {
            this.checkException(BLOB_BAD_POSITION, e);
        }
        try {
            clob.position((String)null, 5L);
            BlobClob4BlobTest.fail((String)"FAIL = position((String) null,5)");
        }
        catch (SQLException e) {
            this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, e);
        }
        try {
            clob.position(clob, -42L);
            BlobClob4BlobTest.fail((String)"FAIL = position(clob,-42)");
        }
        catch (SQLException e) {
            this.checkException(BLOB_BAD_POSITION, e);
        }
        try {
            clob.position((Clob)null, 5L);
            BlobClob4BlobTest.fail((String)"FAIL = pposition((Clob) null,5)");
        }
        catch (SQLException e) {
            this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, e);
        }
    }

    public void testSetClob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        stmt.execute("create table testSetClob (a CLOB(300k), b integer)");
        PreparedStatement ps = this.prepareStatement("insert into testSetClob values(?,?)");
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            int clobLength = rs.getInt(2);
            if (clob == null || clobLength == 0) continue;
            ps.setClob(1, clob);
            ps.setInt(2, clobLength);
            ps.executeUpdate();
        }
        rs.close();
        rs = stmt.executeQuery("select a, b from testSetClob");
        boolean nullClobs = false;
        while (rs.next()) {
            Clob clob2 = rs.getClob(1);
            int clobLength2 = rs.getInt(2);
            BlobClob4BlobTest.assertFalse((String)"FAIL - Clob is NULL", (clob2 == null ? 1 : 0) != 0);
            BlobClob4BlobTest.assertEquals((String)"FAIL - clob.length() != clobLength", (long)clobLength2, (long)clob2.length());
        }
        rs.close();
        stmt.executeUpdate("DROP TABLE testSetClob");
        stmt.close();
    }

    public void testPositionAgressive() throws Exception {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE C8.T8POS(id INT NOT NULL PRIMARY KEY, DD CLOB(1m), pos INT, L INT)");
        s.execute("CREATE TABLE C8.T8PATT(PATT CLOB(300k))");
        char[] fill = new char[]{'d', '\u03a9', '\u0e14', 'j'};
        char[] base = new char[262144];
        for (int i = 0; i < base.length; i += 4) {
            base[i] = fill[0];
            base[i + 1] = fill[1];
            base[i + 2] = fill[2];
            base[i + 3] = fill[3];
        }
        char[] patternBase = new char[2048];
        for (int i = 0; i < patternBase.length; i += 8) {
            patternBase[i] = 112;
            patternBase[i + 1] = 97;
            patternBase[i + 2] = 116;
            patternBase[i + 3] = 938;
            patternBase[i + 4] = (char)i;
            patternBase[i + 5] = 98;
            patternBase[i + 6] = 109;
            patternBase[i + 7] = 3605;
        }
        PreparedStatement ps = this.prepareStatement("INSERT INTO C8.T8POS VALUES (?, ?, ?, ?)");
        PreparedStatement psp = this.prepareStatement("INSERT INTO C8.T8PATT VALUES (?)");
        BlobClob4BlobTest.T8insert(ps, 1, base, 256, patternBase, 8, 100, true);
        BlobClob4BlobTest.T8insert(ps, 2, base, 3988, patternBase, 8, 2045, true);
        BlobClob4BlobTest.T8insert(ps, 3, base, 16321, patternBase, 8, 4566, true);
        BlobClob4BlobTest.T8insert(ps, 4, base, 45662, patternBase, 8, 34555, true);
        BlobClob4BlobTest.T8insert(ps, 5, base, 134752, patternBase, 8, 67889, true);
        BlobClob4BlobTest.T8insert(ps, 6, base, 303, patternBase, 8, 80, false);
        BlobClob4BlobTest.T8insert(ps, 7, base, 4566, patternBase, 8, 2086, false);
        BlobClob4BlobTest.T8insert(ps, 8, base, 17882, patternBase, 8, 4426, false);
        BlobClob4BlobTest.T8insert(ps, 9, base, 41567, patternBase, 8, 31455, false);
        String pstr = BlobClob4BlobTest.T8insert(ps, 10, base, 114732, patternBase, 8, 87809, false);
        this.commit();
        psp.setString(1, pstr);
        psp.executeUpdate();
        BlobClob4BlobTest.checkClob8(s, pstr);
        this.commit();
        ResultSet rsc = s.executeQuery("SELECT PATT FROM C8.T8PATT");
        rsc.next();
        BlobClob4BlobTest.checkClob8(s, rsc.getClob(1));
        rsc.close();
        this.commit();
        s.execute("DELETE FROM C8.T8POS");
        s.execute("DELETE FROM C8.T8PATT");
        BlobClob4BlobTest.T8insert(ps, 1, base, 256, patternBase, 134, 100, true);
        BlobClob4BlobTest.T8insert(ps, 2, base, 3988, patternBase, 134, 2045, true);
        BlobClob4BlobTest.T8insert(ps, 3, base, 16321, patternBase, 134, 4566, true);
        BlobClob4BlobTest.T8insert(ps, 4, base, 45662, patternBase, 134, 34555, true);
        BlobClob4BlobTest.T8insert(ps, 5, base, 134752, patternBase, 134, 67889, true);
        BlobClob4BlobTest.T8insert(ps, 6, base, 303, patternBase, 134, 80, false);
        BlobClob4BlobTest.T8insert(ps, 7, base, 4566, patternBase, 134, 2086, false);
        BlobClob4BlobTest.T8insert(ps, 8, base, 17882, patternBase, 134, 4426, false);
        BlobClob4BlobTest.T8insert(ps, 9, base, 41567, patternBase, 134, 31455, false);
        pstr = BlobClob4BlobTest.T8insert(ps, 10, base, 114732, patternBase, 134, 87809, false);
        this.commit();
        psp.setString(1, pstr);
        psp.executeUpdate();
        this.commit();
        BlobClob4BlobTest.checkClob8(s, pstr);
        this.commit();
        rsc = s.executeQuery("SELECT PATT FROM C8.T8PATT");
        rsc.next();
        BlobClob4BlobTest.checkClob8(s, rsc.getClob(1));
        s.execute("DELETE FROM C8.T8POS");
        s.execute("DELETE FROM C8.T8PATT");
        BlobClob4BlobTest.T8insert(ps, 1, base, 256, patternBase, 679, 100, true);
        BlobClob4BlobTest.T8insert(ps, 2, base, 3988, patternBase, 679, 2045, true);
        BlobClob4BlobTest.T8insert(ps, 3, base, 16321, patternBase, 679, 4566, true);
        BlobClob4BlobTest.T8insert(ps, 4, base, 45662, patternBase, 679, 34555, true);
        BlobClob4BlobTest.T8insert(ps, 5, base, 134752, patternBase, 679, 67889, true);
        BlobClob4BlobTest.T8insert(ps, 6, base, 303, patternBase, 679, 80, false);
        BlobClob4BlobTest.T8insert(ps, 7, base, 4566, patternBase, 679, 2086, false);
        BlobClob4BlobTest.T8insert(ps, 8, base, 17882, patternBase, 679, 4426, false);
        BlobClob4BlobTest.T8insert(ps, 9, base, 41567, patternBase, 679, 31455, false);
        pstr = BlobClob4BlobTest.T8insert(ps, 10, base, 114732, patternBase, 679, 87809, false);
        this.commit();
        psp.setString(1, pstr);
        psp.executeUpdate();
        this.commit();
        BlobClob4BlobTest.checkClob8(s, pstr);
        this.commit();
        rsc = s.executeQuery("SELECT PATT FROM C8.T8PATT");
        rsc.next();
        BlobClob4BlobTest.checkClob8(s, rsc.getClob(1));
        s.execute("DELETE FROM C8.T8POS");
        s.execute("DELETE FROM C8.T8PATT");
        ps.close();
        psp.close();
        s.execute("DROP TABLE C8.T8POS");
        s.execute("DROP TABLE C8.T8PATT");
        s.close();
        this.commit();
    }

    private static String T8insert(PreparedStatement ps, int id, char[] base, int bl, char[] pattern, int pl, int pos, boolean addPattern) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(base, 0, bl);
        int last = BlobClob4BlobTest.addPatternPrefix(sb, pattern, pl, 5, 10);
        if (last >= pos / 2) {
            pos = (last + 10) * 2;
        }
        if ((last = BlobClob4BlobTest.addPatternPrefix(sb, pattern, pl, pl / 2, pos / 2)) >= pos) {
            pos = last + 13;
        }
        pos = BlobClob4BlobTest.addPatternPrefix(sb, pattern, pl, pl - 1, pos);
        if (addPattern) {
            sb.insert(pos, pattern, 0, pl);
        } else {
            pos = -1;
        }
        String dd = sb.toString();
        String pstr = new String(pattern, 0, pl);
        BlobClob4BlobTest.assertEquals((String)"FAIL - test confused pattern not at expected location", (int)pos, (int)dd.indexOf(pstr));
        if (pos != -1) {
            ++pos;
        }
        ps.setInt(1, id);
        ps.setString(2, dd);
        ps.setInt(3, pos);
        ps.setInt(4, dd.length());
        ps.executeUpdate();
        return pstr;
    }

    private static int addPatternPrefix(StringBuffer sb, char[] pattern, int pl, int fakeCount, int pos) {
        for (int i = 0; i < fakeCount && i < pl - 1; ++i) {
            sb.insert(pos, pattern, 0, i + 1);
            pos += i + 1;
        }
        return pos;
    }

    private static void checkClob8(Statement s, String pstr) throws SQLException {
        ResultSet rs = s.executeQuery("SELECT ID, DD, POS, L FROM C8.T8POS ORDER BY 1");
        while (rs.next()) {
            int id = rs.getInt(1);
            Clob cl = rs.getClob(2);
            int pos = rs.getInt(3);
            int len = rs.getInt(4);
            long clobPosition = cl.position(pstr, 1L);
            BlobClob4BlobTest.assertEquals((String)"FAIL - position did not match", (long)pos, (long)clobPosition);
        }
        rs.close();
    }

    private static void checkClob8(Statement s, Clob pstr) throws SQLException {
        ResultSet rs = s.executeQuery("SELECT ID, DD, POS, L FROM C8.T8POS ORDER BY 1");
        while (rs.next()) {
            int id = rs.getInt(1);
            Clob cl = rs.getClob(2);
            int pos = rs.getInt(3);
            int len = rs.getInt(4);
            long clobPosition = cl.position(pstr, 1L);
            BlobClob4BlobTest.assertEquals((String)"FAIL - position did not match", (long)pos, (long)clobPosition);
        }
        rs.close();
    }

    public void testClobAfterClose() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        byte[] buff = new byte[128];
        Clob[] clobArray = new Clob[10];
        int[] clobLengthArray = new int[10];
        int j = 0;
        while (rs.next()) {
            clobArray[j] = rs.getClob(1);
            clobLengthArray[j++] = rs.getInt(2);
        }
        rs.close();
        stmt.close();
        for (int i = 0; i < 10; ++i) {
            int size;
            if (clobArray[i] == null) continue;
            InputStream fin = clobArray[i].getAsciiStream();
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)columnSize, (int)clobLengthArray[i]);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (long)columnSize, (long)clobArray[i].length());
        }
    }

    public void testLockingClob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        Clob clob = null;
        Clob shortClob = null;
        while (rs.next()) {
            int clobLength = rs.getInt(2);
            if (clobLength == 10000) {
                clob = rs.getClob(1);
            }
            if (clobLength != 26) continue;
            shortClob = rs.getClob(1);
        }
        rs.close();
        stmt.close();
        BlobClob4BlobTest.assertTrue((String)"shortClob is null", (shortClob != null ? 1 : 0) != 0);
        BlobClob4BlobTest.assertTrue((String)"clob is null", (clob != null ? 1 : 0) != 0);
        Connection conn2 = this.openDefaultConnection();
        conn2.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        stmt2.executeUpdate("update testClob set a = 'foo' where b = 26");
        BlobClob4BlobTest.assertEquals((String)"FAIL: clob length changed", (long)26L, (long)shortClob.length());
        try {
            stmt2.executeUpdate("update testClob set b = b + 1 where b = 10000");
            stmt2.close();
            conn2.rollback();
            conn2.close();
            BlobClob4BlobTest.fail((String)"FAIL: row should be locked");
        }
        catch (SQLException se) {
            this.checkException(LOCK_TIMEOUT, se);
        }
        BlobClob4BlobTest.assertEquals((String)"FAIL: clob length changed", (long)10000L, (long)clob.length());
        this.commit();
        stmt2.executeUpdate("update testClob set b = b + 1 where b = 10000");
        stmt2.close();
        conn2.rollback();
        conn2.close();
    }

    public void testLockingWithLongRowClob() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("alter table testClob add column al varchar(2000)");
        stmt.execute("alter table testClob add column bl varchar(3000)");
        stmt.execute("alter table testClob add column cl varchar(2000)");
        stmt.execute("alter table testClob add column dl varchar(3000)");
        stmt.execute("alter table testClob add column el CLOB(400k)");
        PreparedStatement ps = this.prepareStatement("insert into testClob (al, bl, cl, dl, el, b) values(?,?,?,?,?,?)");
        ps.setString(1, Formatters.padString("blaaa", 2000));
        ps.setString(2, Formatters.padString("tralaaaa", 3000));
        ps.setString(3, Formatters.padString("foodar", 2000));
        ps.setString(4, Formatters.padString("moped", 3000));
        LoopingAlphabetStream streamIn = new LoopingAlphabetStream(10000L);
        ps.setAsciiStream(5, (InputStream)streamIn, 10000);
        ps.setInt(6, 1);
        this.commit();
        ps.executeUpdate();
        streamIn.close();
        ps.close();
        this.commit();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select el from testClob");
        Clob clob = null;
        BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        clob = rs.getClob(1);
        BlobClob4BlobTest.assertTrue((String)"FAIL - clob is null", (clob != null ? 1 : 0) != 0);
        rs.close();
        stmt.close();
        Connection conn2 = this.openDefaultConnection();
        conn2.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        try {
            stmt2.executeUpdate("update testClob set el = 'smurfball' where b = 1");
            stmt2.close();
            conn2.rollback();
            conn2.close();
            BlobClob4BlobTest.fail((String)"FAIL - statement should timeout");
        }
        catch (SQLException se) {
            this.checkException(LOCK_TIMEOUT, se);
        }
        this.commit();
        stmt2.executeUpdate("update testClob set el = 'smurfball' where b = 1");
        stmt2.close();
        conn2.commit();
        conn2.close();
    }

    public void testClobAfterCommit() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testClob");
        Clob clob = null;
        Clob shortClob = null;
        boolean i = false;
        while (rs.next()) {
            int clobLength = rs.getInt(2);
            if (clobLength == 10000) {
                clob = rs.getClob(1);
            }
            if (clobLength != 26) continue;
            shortClob = rs.getClob(1);
        }
        clob.length();
        shortClob.length();
        rs.close();
        stmt.close();
        this.commit();
        BlobClob4BlobTest.assertTrue((String)"FAIL - shortClob is NULL", (shortClob != null ? 1 : 0) != 0);
        try {
            shortClob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access Clob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            clob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            clob.getSubString(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            clob.getAsciiStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            clob.position("foo", 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            clob.position(clob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
    }

    public void testClobAfterClosingConnection() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testClob");
        Clob clob = null;
        Clob shortClob = null;
        while (rs.next()) {
            int clobLength = rs.getInt(2);
            if (clobLength == 10000) {
                clob = rs.getClob(1);
            }
            if (clobLength != 26) continue;
            shortClob = rs.getClob(1);
        }
        clob.length();
        shortClob.length();
        rs.close();
        stmt.close();
        this.commit();
        this.getConnection().close();
        try {
            long len = shortClob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access Clob after Connection Close");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            clob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            clob.getSubString(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            clob.getAsciiStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            clob.position("foo", 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            clob.position(clob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Clob after Connection Close");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
    }

    public void testClobAfterCommitWithSecondClob() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s1 = this.createStatement();
        ResultSet rs1 = s1.executeQuery("values cast('first' as clob)");
        rs1.next();
        Clob first = rs1.getClob(1);
        rs1.close();
        this.commit();
        Statement s2 = this.createStatement();
        ResultSet rs2 = s2.executeQuery("values cast('second' as clob)");
        rs2.next();
        Clob second = rs2.getClob(1);
        try {
            first.getSubString(1L, 100);
            BlobClob4BlobTest.fail((String)"first.getSubString should have failed because after the commit");
        }
        catch (SQLException se) {
            BlobClob4BlobTest.assertSQLState(INVALID_LOB, se);
        }
        BlobClob4BlobTest.assertEquals((String)"second", (String)second.getSubString(1L, 100));
        rs2.close();
    }

    public void testGetClobBeforeAndAfterUpdate() throws SQLException {
        String clobData = "initial clob ";
        PreparedStatement ps = this.prepareStatement("insert into testClob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setString(2, clobData + i);
            ps.execute();
        }
        ps.close();
        Statement scrollStmt = this.createStatement(1004, 1008);
        ResultSet rs = scrollStmt.executeQuery("SELECT b, a FROM testClob");
        rs.first();
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.next();
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.relative(3);
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.absolute(7);
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.previous();
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.last();
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.previous();
        this.checkContentsBeforeAndAfterUpdatingClob(rs);
        rs.close();
        scrollStmt.close();
    }

    private void checkContentsBeforeAndAfterUpdatingClob(ResultSet rs) throws SQLException {
        String clobData = "initial clob ";
        String updatedClobData = "updated clob ";
        Clob c = rs.getClob(2);
        String value = c.getSubString(1L, (int)c.length());
        String expectedValue = clobData + rs.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)expectedValue, (String)value);
        value = updatedClobData + rs.getInt(1);
        c.setString(1L, value);
        rs.updateClob(2, c);
        rs.updateRow();
        rs.next();
        rs.previous();
        c = rs.getClob(2);
        value = c.getSubString(1L, (int)c.length());
        expectedValue = updatedClobData + rs.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)expectedValue, (String)value);
    }

    public void testGetClobBeforeAndAfterUpdateStream() throws SQLException {
        String clobData = "initial clob ";
        PreparedStatement ps = this.prepareStatement("insert into testClob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setString(2, clobData + i);
            ps.execute();
        }
        ps.close();
        Statement scrollStmt = this.createStatement(1004, 1008);
        ResultSet rs = scrollStmt.executeQuery("SELECT b, a FROM testClob");
        rs.first();
        this.updateClobWithUpdateCharacterStream(rs);
        rs.next();
        this.updateClobWithUpdateCharacterStream(rs);
        rs.relative(3);
        this.updateClobWithUpdateCharacterStream(rs);
        rs.absolute(7);
        this.updateClobWithUpdateCharacterStream(rs);
        rs.previous();
        this.updateClobWithUpdateCharacterStream(rs);
        rs.last();
        this.updateClobWithUpdateCharacterStream(rs);
        rs.previous();
        this.updateClobWithUpdateCharacterStream(rs);
        rs.close();
        scrollStmt.close();
    }

    private void updateClobWithUpdateCharacterStream(ResultSet rs) throws SQLException {
        String clobData = "initial clob ";
        String updatedClobData = "updated clob ";
        Clob c = rs.getClob(2);
        String value = c.getSubString(1L, (int)c.length());
        String expectedValue = clobData + rs.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)expectedValue, (String)value);
        value = updatedClobData + rs.getInt(1);
        StringReader updateValue = new StringReader(value);
        rs.updateCharacterStream(2, (Reader)updateValue, value.length());
        rs.updateRow();
        rs.next();
        rs.previous();
        c = rs.getClob(2);
        value = c.getSubString(1L, (int)c.length());
        expectedValue = updatedClobData + rs.getInt(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob value", (String)expectedValue, (String)value);
    }

    public void testClobFinalizer() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob");
        Clob[] clobArray = new Clob[10];
        int[] clobLengthArray = new int[10];
        int j = 0;
        while (rs.next()) {
            clobArray[j] = rs.getClob(1);
            clobLengthArray[j++] = rs.getInt(2);
        }
        rs.close();
        stmt.close();
        for (int i = 0; i < 10; ++i) {
            clobArray[i] = null;
        }
        System.gc();
        System.gc();
    }

    public void testGetBinaryStream() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b, crc32 from testBlob");
        this.testBlobContents(rs);
        stmt.close();
        this.commit();
    }

    public void testGetBytes() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testBlob");
        int blobLength = 0;
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            blobLength = rs.getInt(2);
            if (blob != null) {
                this.verifyInterval(blob, 9905L, 50, 0, blobLength);
                this.verifyInterval(blob, 5910L, 150, 1, blobLength);
                this.verifyInterval(blob, 5910L, 50, 2, blobLength);
                this.verifyInterval(blob, 204L, 50, 3, blobLength);
                this.verifyInterval(blob, 68L, 50, 4, blobLength);
                this.verifyInterval(blob, 1L, 50, 5, blobLength);
                this.verifyInterval(blob, 1L, 1, 6, blobLength);
                this.verifyInterval(blob, 1L, 0, 7, blobLength);
                this.verifyInterval(blob, (long)(blobLength + 1), 0, 8, blobLength);
                if (blobLength <= 100) continue;
                byte[] res = blob.getBytes(blobLength - 99, 200);
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong length in bytes", (int)100, (int)res.length);
                InputStream inStream = blob.getBinaryStream();
                long read = 0L;
                for (long left = (long)(blobLength - 100); left > 0L && read != -1L; left -= (read = inStream.skip(Math.min(1024L, left))) > 0L ? read : 0L) {
                }
                byte[] expected = new byte[100];
                read = inStream.read(expected);
                inStream.close();
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong value", (String)new String(expected), (String)new String(res));
                continue;
            }
            BlobClob4BlobTest.assertTrue((String)"FAIL - blob was NULL but length != 0", (blobLength == 0 ? 1 : 0) != 0);
        }
        stmt.close();
        this.commit();
    }

    public void testPositionBytes() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testBlob");
        int blobLength = 0;
        Random random = new Random();
        int maxStartPointDistance = CharAlphabet.MODERNLATINLOWER.length;
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            blobLength = rs.getInt(2);
            if (blob == null || blobLength <= 0) continue;
            BlobClob4BlobTest.println("\n\nblobLength: " + blobLength);
            for (int i = 0; i < 10; ++i) {
                int start = Math.max(random.nextInt(blobLength - 1), 1);
                int length = random.nextInt(blobLength - start) + 1;
                BlobClob4BlobTest.println("start:" + start + " length:" + length);
                byte[] searchBytes = blob.getBytes(start, length);
                String searchString = new String(searchBytes, "US-ASCII");
                int distance = random.nextInt(maxStartPointDistance);
                int startSearchPos = Math.max(start - distance, 1);
                byte[] tmp = blob.getBytes(startSearchPos, start);
                if (new String(tmp, "US-ASCII").indexOf(searchString) != -1) {
                    startSearchPos = start;
                }
                BlobClob4BlobTest.println("startSearchPos: " + startSearchPos + "searchString: " + new String(searchBytes));
                long foundAt = blob.position(searchBytes, (long)startSearchPos);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + searchString + " starting at " + startSearchPos + " and length of " + searchBytes.length), (long)start, (long)foundAt);
            }
        }
        rs.close();
        stmt.close();
    }

    public void testPositionBlobDeterministic() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        int size = 100000;
        PreparedStatement ps = this.prepareStatement("INSERT INTO testBlob (a, b) VALUES (?, ?)");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(100000L), 100000);
        ps.setInt(2, 100000);
        ps.executeUpdate();
        ps.close();
        ps = this.prepareStatement("select a from testBlob where b = ?");
        ps.setInt(1, 100000);
        ResultSet rs = ps.executeQuery();
        BlobClob4BlobTest.assertTrue((String)"No data found", (boolean)rs.next());
        Blob blob = rs.getBlob(1);
        byte[] pattern = new byte[]{107};
        BlobClob4BlobTest.assertEquals((long)11L, (long)blob.position(pattern, 1L));
        pattern = new byte[]{112, 111};
        BlobClob4BlobTest.assertEquals((long)-1L, (long)blob.position(pattern, 33333L));
        pattern = new byte[]{100, 101};
        long foundAtPos = 1L;
        int index = 0;
        int stepSize = ByteAlphabet.modernLatinLowercase().byteCount();
        while ((foundAtPos = blob.position(pattern, foundAtPos + 1L)) != -1L) {
            BlobClob4BlobTest.assertEquals((long)(stepSize * index++ + 4), (long)foundAtPos);
            byte[] fetchedPattern = blob.getBytes(foundAtPos, pattern.length);
            BlobClob4BlobTest.assertTrue((boolean)Arrays.equals(pattern, fetchedPattern));
        }
        int pSize = 66560;
        pattern = new byte[pSize];
        BlobClob4BlobTest.assertEquals((int)pSize, (int)new LoopingAlphabetStream(pSize).read(pattern));
        BlobClob4BlobTest.assertEquals((long)1L, (long)blob.position(pattern, 1L));
        BlobClob4BlobTest.assertEquals((long)(stepSize * 100 + 1), (long)blob.position(pattern, (long)(stepSize * 99 + 7)));
        BlobClob4BlobTest.assertEquals((long)100000L, (long)blob.length());
        BlobClob4BlobTest.assertEquals((long)(stepSize * 100 + 1), (long)blob.position(pattern, (long)(stepSize * 99 + 7)));
        try {
            blob.position(pattern, 200000L);
            BlobClob4BlobTest.fail((String)"Accepted position after end of Blob");
        }
        catch (SQLException sqle) {
            BlobClob4BlobTest.assertSQLState(BLOB_POSITION_TOO_LARGE, sqle);
        }
        byte[] blobEnd = blob.getBytes(99996L, 5);
        pattern = new byte[6];
        System.arraycopy(blobEnd, 0, pattern, 0, blobEnd.length);
        pattern[5] = 88;
        BlobClob4BlobTest.assertEquals((long)-1L, (long)blob.position(pattern, 99990L));
        blobEnd = blob.getBytes(100000L, 1);
        pattern = new byte[]{blobEnd[0], 88};
        BlobClob4BlobTest.assertEquals((long)-1L, (long)blob.position(pattern, 99995L));
    }

    public void testPositionBlob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testBlob");
        int blobLength = 0;
        Statement stmt2 = this.createStatement();
        Random random = new Random();
        int maxStartPointDistance = CharAlphabet.MODERNLATINLOWER.length;
        while (rs.next()) {
            int startSearchPos;
            String searchString;
            int start;
            Blob blob = rs.getBlob(1);
            blobLength = rs.getInt(2);
            if (blob == null || blobLength <= 0) continue;
            BlobClob4BlobTest.println("\n\nblobLength: " + blobLength);
            stmt2.executeUpdate("CREATE TABLE searchBlob (a Blob(300K), start int, position int)");
            PreparedStatement ps = this.prepareStatement("INSERT INTO searchBlob values (?, ?, ?) ");
            for (int i = 0; i < 10; ++i) {
                start = Math.max(random.nextInt(blobLength - 1), 1);
                int length = random.nextInt(blobLength - start) + 1;
                BlobClob4BlobTest.println("start:" + start + " length:" + length);
                searchString = new String(blob.getBytes(start, length), "US-ASCII");
                int distance = random.nextInt(maxStartPointDistance);
                startSearchPos = Math.max(start - distance, 1);
                String tmp = new String(blob.getBytes(startSearchPos, start), "US-ASCII");
                if (tmp.indexOf(searchString) != -1) {
                    startSearchPos = start;
                }
                ps.setBytes(1, searchString.getBytes("US-ASCII"));
                ps.setInt(2, startSearchPos);
                ps.setInt(3, start);
                ps.executeUpdate();
            }
            ps.close();
            ResultSet rs2 = stmt2.executeQuery("SELECT a, start, position FROM searchBlob");
            while (rs2.next()) {
                Blob searchBlob = rs2.getBlob(1);
                startSearchPos = rs2.getInt(2);
                start = rs2.getInt(3);
                searchString = new String(searchBlob.getBytes(1L, (int)searchBlob.length()), "US-ASCII");
                BlobClob4BlobTest.println("startSearchPos: " + startSearchPos + "searchString: " + searchString);
                long foundAt = blob.position(searchBlob, (long)startSearchPos);
                BlobClob4BlobTest.assertEquals((String)("FAIL - wrong match found for " + searchString + " starting at " + startSearchPos + " and length of " + searchString.length()), (long)start, (long)foundAt);
            }
            rs2.close();
            stmt2.executeUpdate("DROP TABLE searchBlob");
        }
        rs.close();
        stmt.close();
        stmt2.close();
    }

    public void testTriggerWithBlobColumn() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CREATE TABLE blobTest8TriggerA (a BLOB(400k), b int, crc32 BIGINT)");
        stmt.executeUpdate("CREATE TABLE blobTest8TriggerB (a BLOB(400k), b int, crc32 BIGINT)");
        stmt.executeUpdate("create trigger T8A after update on testBlob referencing new as n old as o for each row insert into blobTest8TriggerA(a, b, crc32) values (n.a, n.b, n.crc32)");
        stmt.executeUpdate("create trigger T8B after INSERT on blobTest8TriggerA referencing new table as n for each statement insert into blobTest8TriggerB(a, b, crc32) select n.a, n.b, n.crc32 from n");
        this.commit();
        ResultSet rs = stmt.executeQuery("select a,b,crc32 from blobTest8TriggerA");
        BlobClob4BlobTest.assertFalse((String)"FAIL - Table blobTest8TriggerA should contain no rows", (boolean)rs.next());
        rs.close();
        this.commit();
        stmt.executeUpdate("UPDATE testBlob set b = b + 0");
        this.commit();
        rs = stmt.executeQuery("select a,b,crc32 from blobTest8TriggerA");
        this.testBlobContents(rs);
        rs.close();
        this.commit();
        rs = stmt.executeQuery("select a,b,crc32 from blobTest8TriggerB");
        this.testBlobContents(rs);
        rs.close();
        this.commit();
        stmt.executeUpdate("DROP TRIGGER T8A");
        stmt.executeUpdate("DROP TRIGGER T8B");
        stmt.executeUpdate("DROP TABLE blobTest8TriggerB");
        stmt.executeUpdate("DROP TABLE blobTest8TriggerA");
        stmt.close();
        this.commit();
    }

    public void testVarbinary() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("ALTER TABLE testBlob ADD COLUMN smallBlob blob(13)");
        PreparedStatement ps = this.prepareStatement("insert into testBlob (smallBlob) values (?)");
        String val = "";
        for (int i = 0; i < 10; ++i) {
            ps.setBytes(1, val.getBytes("US-ASCII"));
            ps.executeUpdate();
            val = val.trim() + "x";
        }
        ResultSet rs = stmt.executeQuery("select smallBlob from testBlob");
        byte[] buff = new byte[128];
        int j = 0;
        while (rs.next()) {
            int size;
            Blob blob = rs.getBlob(1);
            BlobClob4BlobTest.assertTrue((String)"FAIL - blob is null", (blob != null ? 1 : 0) != 0);
            InputStream fin = blob.getBinaryStream();
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - unexpected blob size", (int)j, (int)columnSize);
            BlobClob4BlobTest.assertEquals((String)"FAIL - unexpected blob length", (long)j, (long)blob.length());
            ++j;
        }
        ps.close();
        stmt.close();
        this.commit();
    }

    public void testGetBlobFromIntColumn() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select b from testClob");
        while (rs.next()) {
            try {
                Blob blob = rs.getBlob(1);
                rs.close();
                stmt.close();
                BlobClob4BlobTest.fail((String)"FAIL - getBlob on int column should throw an exception");
            }
            catch (SQLException se) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, se);
            }
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testSetBlobOnIntColumn() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into testBlob (b) values(?)");
        ResultSet rs = stmt.executeQuery("select a,b from testBlob");
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            if (blob == null) continue;
            try {
                ps.setBlob(1, blob);
                ps.executeUpdate();
                rs.close();
                stmt.close();
                ps.close();
                BlobClob4BlobTest.fail((String)"FAIL - setBlob worked on INT column");
            }
            catch (SQLException se) {
                this.checkException(LANG_DATA_TYPE_GET_MISMATCH, se);
            }
        }
        rs.close();
        stmt.close();
        ps.close();
        this.commit();
    }

    public void testRaisingOfExceptionsBlob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testBlob");
        int blobLength = 0;
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            blobLength = rs.getInt(2);
            if (blob == null) continue;
            try {
                blob.getBytes(0L, 5);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with 0 as position should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_BAD_POSITION, e);
            }
            try {
                blob.getBytes(1L, -76);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with negative length should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_NONPOSITIVE_LENGTH, e);
            }
            try {
                blob.getBytes(1L, -1);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with negative length should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_NONPOSITIVE_LENGTH, e);
            }
            try {
                blob.getBytes(0L, 0);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with 0 position and length should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_BAD_POSITION, e);
            }
            try {
                blob.getBytes(blobLength + 2, 0);
                BlobClob4BlobTest.fail((String)"FAIL - getBytes with position larger than the length of the blob should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_POSITION_TOO_LARGE, e);
            }
            catch (NegativeArraySizeException nase) {
                BlobClob4BlobTest.assertTrue((String)"FAIL - this exception should only happen with DB2 client", (boolean)BlobClob4BlobTest.usingDB2Client());
            }
            try {
                blob.position(new byte[0], -4000L);
                if (!BlobClob4BlobTest.usingDB2Client()) {
                    BlobClob4BlobTest.fail((String)"FAIL - position with negative start position should have caused an exception");
                }
            }
            catch (SQLException e) {
                this.checkException(BLOB_BAD_POSITION, e);
                BlobClob4BlobTest.assertTrue((String)"FAIL - JCC should not get an exception", (!BlobClob4BlobTest.usingDB2Client() ? 1 : 0) != 0);
            }
            try {
                blob.position((byte[])null, 5L);
                BlobClob4BlobTest.fail((String)"FAIL - position with null pattern should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, e);
            }
            try {
                blob.position(blob, -42L);
                if (!BlobClob4BlobTest.usingDB2Client()) {
                    BlobClob4BlobTest.fail((String)"FAIL - position with negative start position should have caused an exception");
                }
            }
            catch (SQLException e) {
                this.checkException(BLOB_BAD_POSITION, e);
            }
            catch (ArrayIndexOutOfBoundsException aob) {
                BlobClob4BlobTest.assertTrue((String)"FAIL - this excpetion should only happen with DB2 client", (boolean)BlobClob4BlobTest.usingDB2Client());
            }
            try {
                blob.position((Blob)null, 5L);
                BlobClob4BlobTest.fail((String)"FAIL - position with null pattern should have caused an exception");
            }
            catch (SQLException e) {
                this.checkException(BLOB_NULL_PATTERN_OR_SEARCH_STR, e);
            }
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testSetBlob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        stmt.execute("create table testBlobX (a blob(300K), b integer)");
        PreparedStatement ps = this.prepareStatement("insert into testBlobX values(?,?)");
        ResultSet rs = stmt.executeQuery("select a, b from testBlob");
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            int blobLength = rs.getInt(2);
            if (blob == null) continue;
            ps.setBlob(1, blob);
            ps.setInt(2, blobLength);
            ps.executeUpdate();
        }
        rs.close();
        this.commit();
        rs = stmt.executeQuery("select a,b from testBlobX");
        while (rs.next()) {
            Blob blob2 = rs.getBlob(1);
            int blobLength2 = rs.getInt(2);
            BlobClob4BlobTest.assertTrue((String)"FAIL - blob is NULL", (blob2 != null ? 1 : 0) != 0);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong blob length", (long)blob2.length(), (long)blobLength2);
        }
        rs.close();
        stmt.executeUpdate("DROP TABLE testBlobX");
        stmt.close();
        this.commit();
    }

    public void testBlobAfterClose() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testBlob");
        byte[] buff = new byte[128];
        Blob[] blobArray = new Blob[10];
        int[] blobLengthArray = new int[10];
        int j = 0;
        while (rs.next()) {
            blobArray[j] = rs.getBlob(1);
            blobLengthArray[j++] = rs.getInt(2);
        }
        rs.close();
        stmt.close();
        for (int i = 0; i < 10; ++i) {
            int size;
            if (blobArray[i] == null) continue;
            InputStream fin = blobArray[i].getBinaryStream();
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            BlobClob4BlobTest.assertEquals((String)"FAIL - invalid length", (int)blobLengthArray[i], (int)columnSize);
            BlobClob4BlobTest.assertEquals((String)"FAIL - invalid length", (long)columnSize, (long)blobArray[i].length());
        }
    }

    public void testLockingBlob() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testBlob");
        Blob blob = null;
        Blob shortBlob = null;
        while (rs.next()) {
            int blobLength = rs.getInt(2);
            if (blobLength == 10000) {
                blob = rs.getBlob(1);
            }
            if (blobLength != 26) continue;
            shortBlob = rs.getBlob(1);
        }
        rs.close();
        Connection conn2 = this.openDefaultConnection();
        conn2.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        stmt2.executeUpdate("update testBlob set a = null where b = 26");
        BlobClob4BlobTest.assertEquals((String)"FAIL - blob was updated", (long)26L, (long)shortBlob.length());
        try {
            stmt2.executeUpdate("update testBlob set b = b + 1 where b = 10000");
            stmt.close();
            stmt2.close();
            conn2.rollback();
            conn2.close();
            BlobClob4BlobTest.fail((String)"FAIL - should have gotten lock timeout");
        }
        catch (SQLException se) {
            this.checkException(LOCK_TIMEOUT, se);
        }
        this.commit();
        stmt2.executeUpdate("update testBlob set b = b + 1 where b = 10000");
        stmt.close();
        stmt2.close();
        conn2.commit();
        conn2.close();
    }

    public void testLockingWithLongRowBlob() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("alter table testBlob add column al varchar(2000)");
        stmt.execute("alter table testBlob add column bl varchar(3000)");
        stmt.execute("alter table testBlob add column cl varchar(2000)");
        stmt.execute("alter table testBlob add column dl varchar(3000)");
        stmt.execute("alter table testBlob add column el BLOB(400k)");
        PreparedStatement ps = this.prepareStatement("insert into testBlob (al, bl, cl, dl, el, b) values(?,?,?,?,?,?)");
        ps.setString(1, Formatters.padString("blaaa", 2000));
        ps.setString(2, Formatters.padString("tralaaaa", 3000));
        ps.setString(3, Formatters.padString("foodar", 2000));
        ps.setString(4, Formatters.padString("moped", 3000));
        LoopingAlphabetStream streamIn = new LoopingAlphabetStream(10000L);
        ps.setBinaryStream(5, (InputStream)streamIn, 10000);
        ps.setInt(6, 1);
        ps.executeUpdate();
        streamIn.close();
        ps.close();
        this.commit();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select el from testBlob");
        Blob blob = null;
        BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        blob = rs.getBlob(1);
        BlobClob4BlobTest.assertTrue((String)"FAIL - blob is null", (blob != null ? 1 : 0) != 0);
        rs.close();
        stmt.close();
        Connection conn2 = this.openDefaultConnection();
        conn2.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        try {
            stmt2.executeUpdate("update testBlob set el = null where b = 1");
            stmt2.close();
            stmt.close();
            conn2.rollback();
            conn2.close();
            BlobClob4BlobTest.fail((String)"FAIL - statement should timeout");
        }
        catch (SQLException se) {
            this.checkException(LOCK_TIMEOUT, se);
        }
        this.commit();
        stmt2.executeUpdate("update testBlob set el = null where b = 1");
        stmt2.close();
        conn2.commit();
        stmt.close();
        conn2.close();
    }

    public void testBlobAfterCommit() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testBlob");
        Blob blob = null;
        Blob shortBlob = null;
        while (rs.next()) {
            int blobLength = rs.getInt(2);
            if (blobLength == 10000) {
                blob = rs.getBlob(1);
            }
            if (blobLength != 26) continue;
            shortBlob = rs.getBlob(1);
        }
        blob.length();
        shortBlob.length();
        rs.close();
        stmt.close();
        this.commit();
        BlobClob4BlobTest.assertTrue((String)"FAIL - shortBlob is NULL", (shortBlob != null ? 1 : 0) != 0);
        try {
            shortBlob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access Blob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        BlobClob4BlobTest.assertTrue((String)"FAIL - blob is NULL", (blob != null ? 1 : 0) != 0);
        try {
            blob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            blob.getBytes(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            blob.getBinaryStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            blob.position("foo".getBytes("US-ASCII"), 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
        try {
            blob.position(blob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large Blob after commit");
        }
        catch (SQLException e) {
            this.checkException(INVALID_LOB, e);
        }
    }

    public void testBlobAfterClosingConnection() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testBlob");
        Blob blob = null;
        Blob shortBlob = null;
        while (rs.next()) {
            int blobLength = rs.getInt(2);
            if (blobLength == 10000) {
                blob = rs.getBlob(1);
            }
            if (blobLength != 26) continue;
            shortBlob = rs.getBlob(1);
        }
        blob.length();
        shortBlob.length();
        rs.close();
        this.rollback();
        this.getConnection().close();
        try {
            long length = shortBlob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should get an exception, connection is closed");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            blob.length();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            blob.getBytes(2L, 3);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            blob.getBinaryStream();
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            blob.position("foo".getBytes("US-ASCII"), 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        try {
            blob.position(blob, 2L);
            BlobClob4BlobTest.fail((String)"FAIL - should not be able to access large lob after the connection is closed");
        }
        catch (SQLException e) {
            this.checkException(NO_CURRENT_CONNECTION, e);
        }
        this.getConnection().setAutoCommit(false);
    }

    public void testBlobFinalizer() throws Exception {
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a,b from testBlob");
        Blob[] blobArray = new Blob[10];
        int[] blobLengthArray = new int[10];
        int j = 0;
        while (rs.next()) {
            blobArray[j] = rs.getBlob(1);
            blobLengthArray[j++] = rs.getInt(2);
        }
        rs.close();
        stmt.close();
        for (int i = 0; i < 10; ++i) {
            blobArray[i] = null;
        }
        System.gc();
        System.gc();
    }

    public void testGetBlobBeforeAndAfterUpdate() throws Exception {
        String blobData = "initial blob ";
        PreparedStatement ps = this.prepareStatement("insert into testBlob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setBytes(2, (blobData + i).getBytes("US-ASCII"));
            ps.execute();
        }
        ps.close();
        Statement scrollStmt = this.createStatement(1004, 1008);
        ResultSet rs = scrollStmt.executeQuery("SELECT b, a FROM testBlob");
        rs.first();
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.next();
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.relative(3);
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.absolute(7);
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.previous();
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.last();
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.previous();
        this.checkContentsBeforeAndAfterUpdatingBlob(rs);
        rs.close();
        scrollStmt.close();
    }

    private void checkContentsBeforeAndAfterUpdatingBlob(ResultSet rs) throws SQLException, UnsupportedEncodingException {
        String blobData = "initial blob ";
        String updatedBlobData = "updated blob ";
        Blob b = rs.getBlob(2);
        byte[] value = b.getBytes(1L, blobData.length() + 1);
        byte[] expectedValue = (blobData + rs.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(value, expectedValue));
        value = (updatedBlobData + rs.getInt(1)).getBytes("US-ASCII");
        b.setBytes(1L, value);
        rs.updateBlob(2, b);
        rs.updateRow();
        rs.next();
        rs.previous();
        b = rs.getBlob(2);
        value = b.getBytes(1L, updatedBlobData.length() + 1);
        expectedValue = (updatedBlobData + rs.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(value, expectedValue));
    }

    public void testGetBlobBeforeAndAfterUpdateStream() throws Exception {
        String blobData = "initial blob ";
        PreparedStatement ps = this.prepareStatement("insert into testBlob (b, a) values (?, ?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setBytes(2, (blobData + i).getBytes("US-ASCII"));
            ps.execute();
        }
        ps.close();
        Statement scrollStmt = this.createStatement(1004, 1008);
        ResultSet rs = scrollStmt.executeQuery("SELECT b, a FROM testBlob");
        rs.first();
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.next();
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.relative(3);
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.absolute(7);
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.previous();
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.last();
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.previous();
        this.updateBlobWithUpdateBinaryStream(rs);
        rs.close();
        scrollStmt.close();
    }

    private void updateBlobWithUpdateBinaryStream(ResultSet rs) throws SQLException, UnsupportedEncodingException {
        String blobData = "initial blob ";
        String updatedBlobData = "updated blob ";
        Blob b = rs.getBlob(2);
        byte[] value = b.getBytes(1L, blobData.length() + 1);
        byte[] expectedValue = (blobData + rs.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(value, expectedValue));
        value = (updatedBlobData + rs.getInt(1)).getBytes("US-ASCII");
        ByteArrayInputStream updateValue = new ByteArrayInputStream(value);
        rs.updateBinaryStream(2, (InputStream)updateValue, value.length);
        rs.updateRow();
        rs.next();
        rs.previous();
        b = rs.getBlob(2);
        value = b.getBytes(1L, updatedBlobData.length() + 1);
        expectedValue = (updatedBlobData + rs.getInt(1)).getBytes("US-ASCII");
        BlobClob4BlobTest.assertTrue((String)"FAIL - wrong blob value", (boolean)Arrays.equals(value, expectedValue));
    }

    public void testSelfDestructiveClob() throws Exception {
        int size;
        this.insertDefaultData();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select a, b from testClob where b = 10000");
        byte[] buff = new byte[128];
        Clob clob = null;
        int clobLength = 0;
        int i = 0;
        BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        ++i;
        clobLength = rs.getInt(2);
        clob = rs.getClob(1);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (int)10000, (int)clobLength);
        InputStream fin = clob.getAsciiStream();
        int columnSize = 0;
        PreparedStatement ps = this.prepareStatement("update testClob set a = ? where b = 10000");
        StringBuffer foo = new StringBuffer();
        for (int k = 0; k < 1000; ++k) {
            foo.append('j');
        }
        ps.setString(1, foo.toString());
        ps.executeUpdate();
        rs = stmt.executeQuery("select a from testClob where b = 10000");
        while (rs.next()) {
            int j = 1;
            String val = rs.getString(1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - invalid blob value", (String)foo.substring(0, 50), (String)val.substring(0, 50));
            ++j;
        }
        while (columnSize < 11000 && (size = fin.read(buff)) != -1) {
            columnSize += size;
        }
        BlobClob4BlobTest.assertEquals((String)"FAIL - invalid column size", (int)10000, (int)columnSize);
        BlobClob4BlobTest.assertEquals((String)"FAIL - invalid column size", (int)clobLength, (int)columnSize);
        BlobClob4BlobTest.assertEquals((String)"FAIL - invalid column size", (long)columnSize, (long)clob.length());
        rs.close();
        stmt.close();
    }

    public void testSelfDestructiveClob2() throws Exception {
        block3: {
            this.insertDefaultData();
            Statement stmt = this.createStatement();
            ResultSet rs = stmt.executeQuery("select a,b from testClob where b = 10000");
            byte[] buff = new byte[128];
            Clob clob = null;
            int clobLength = 0;
            int i = 0;
            BlobClob4BlobTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
            ++i;
            clobLength = rs.getInt(2);
            clob = rs.getClob(1);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong clob length", (int)10000, (int)clobLength);
            InputStream fin = clob.getAsciiStream();
            stmt.executeUpdate("drop table testClob");
            try {
                int size;
                for (int columnSize = 0; columnSize < 11000 && (size = fin.read(buff)) != -1; columnSize += size) {
                }
                BlobClob4BlobTest.fail((String)"FAIL - should have got an IOException");
            }
            catch (IOException ioe) {
                if (!BlobClob4BlobTest.usingEmbedded()) break block3;
                BlobClob4BlobTest.assertEquals((String)"FAIL - wrong exception", (String)"ERROR 40XD0: Container has been closed.", (String)ioe.getMessage());
            }
        }
        this.rollback();
    }

    public void testNegativeTestDerby265Blob() throws Exception {
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into testBlob(b, a) values(?,?)");
        for (int i = 0; i < 3; ++i) {
            LoopingAlphabetStream fis = new LoopingAlphabetStream(300000L);
            ps.setInt(1, i);
            ps.setBinaryStream(2, (InputStream)fis, 300000);
            ps.executeUpdate();
            fis.close();
        }
        this.commit();
        this.getConnection().setAutoCommit(true);
        Statement s = this.createStatement(1003, 1007);
        s.execute("SELECT b, a FROM testBlob");
        ResultSet rs1 = s.getResultSet();
        Statement s2 = this.createStatement(1003, 1007);
        s2.executeQuery("SELECT b, a FROM testBlob");
        ResultSet rs2 = s2.getResultSet();
        rs2.next();
        Blob b2 = rs2.getBlob(2);
        rs1.next();
        Blob b1 = rs1.getBlob(2);
        rs1.close();
        BlobClob4BlobTest.assertTrue((boolean)rs2.next());
        BlobClob4BlobTest.assertNotNull((Object)rs2.getBlob(2));
        rs2.close();
    }

    public void testNegativeTestDerby265Clob() throws Exception {
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into testClob(b, a) values(?,?)");
        for (int i = 0; i < 3; ++i) {
            LoopingAlphabetReader fis = new LoopingAlphabetReader(300000L);
            ps.setInt(1, i);
            ps.setCharacterStream(2, (Reader)fis, 300000);
            ps.executeUpdate();
            ((Reader)fis).close();
        }
        this.commit();
        this.getConnection().setAutoCommit(true);
        Statement s = this.createStatement(1003, 1007);
        s.execute("SELECT b, a FROM testClob");
        ResultSet rs1 = s.getResultSet();
        Statement s2 = this.createStatement(1003, 1007);
        s2.executeQuery("SELECT b, a FROM testClob");
        ResultSet rs2 = s2.getResultSet();
        rs2.next();
        Clob b2 = rs2.getClob(2);
        rs1.next();
        Clob b1 = rs1.getClob(2);
        rs1.close();
        BlobClob4BlobTest.assertTrue((boolean)rs2.next());
        BlobClob4BlobTest.assertNotNull((Object)rs2.getClob(2));
        rs2.close();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("BlobClob4BlobTest");
        suite.addTest(BlobClob4BlobTest.baseSuite("embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(BlobClob4BlobTest.baseSuite("client")));
        if (JDBC.vmSupportsJDBC3()) {
            Test encSuite = BlobClob4BlobTest.baseSuite("encrypted");
            suite.addTest(Decorator.encryptedDatabase(encSuite));
        }
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(BlobClob4BlobTest.class, "BlobClob4BlobTest:" + name);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4));
    }

    private void insertDefaultData() throws Exception {
        PreparedStatement ps = this.prepareStatement("INSERT INTO testClob (a, b, c) VALUES (?, ?, ?)");
        String clobValue = "";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        clobValue = "you can lead a horse to water but you can't form it into beverage";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        clobValue = "a stitch in time says ouch";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        clobValue = "here is a string with a return \n character";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        ps.executeBatch();
        ps.clearBatch();
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 0);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 56);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 5000);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 10000);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 300000);
        ps.setNull(1, 2005);
        ps.setInt(2, 0);
        ps.setLong(3, 0L);
        ps.executeUpdate();
        ps.close();
        ps = this.prepareStatement("INSERT INTO testBlob (a, b, crc32) VALUES (?, ?, ?)");
        byte[] blobValue = "".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        blobValue = "you can lead a horse to water but you can't form it into beverage".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        blobValue = "a stitch in time says ouch".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        blobValue = "here is a string with a return \n character".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        ps.executeBatch();
        ps.clearBatch();
        this.insertLoopingAlphabetStreamData(ps, 0);
        this.insertLoopingAlphabetStreamData(ps, 56);
        this.insertLoopingAlphabetStreamData(ps, 5000);
        this.insertLoopingAlphabetStreamData(ps, 10000);
        this.insertLoopingAlphabetStreamData(ps, 300000);
        ps.setNull(1, 2004);
        ps.setInt(2, 0);
        ps.setNull(3, -5);
        ps.executeUpdate();
        ps.close();
        this.commit();
    }

    private void insertUnicodeData(String[] unicodeString) throws Exception {
        PreparedStatement ps = this.prepareStatement("INSERT INTO testClob (a, b, c) VALUES (?, ?, ?)");
        for (int i = 0; i < unicodeString.length; ++i) {
            ps.setString(1, unicodeString[i]);
            ps.setInt(2, unicodeString[i].length());
            ps.setInt(3, i);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.clearBatch();
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.tamil(), 0);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.tamil(), 56);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.tamil(), 5000);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.tamil(), 10000);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.tamil(), 300000);
        ps.setNull(1, 2005);
        ps.setInt(2, 0);
        ps.setInt(3, -1);
        ps.executeUpdate();
        ps.close();
        this.commit();
    }

    private void insertLoopingAlphabetStreamData(PreparedStatement ps, int lobLength) throws Exception {
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(lobLength), lobLength);
        ps.setInt(2, lobLength);
        ps.setLong(3, this.getStreamCheckSum(new LoopingAlphabetStream(lobLength)));
        ps.executeUpdate();
    }

    private void insertLoopingAlphabetStreamData(PreparedStatement ps, CharAlphabet alphabet, int lobLength) throws Exception {
        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)lobLength, alphabet), lobLength);
        ps.setInt(2, lobLength);
        ps.setLong(3, -1L);
        ps.executeUpdate();
    }

    private boolean compareReaders(Reader origValue, Reader newValue) throws Exception {
        char[] origBuff = new char[1024];
        char[] newBuff = new char[1024];
        int countOrig = -1;
        int countNew = -1;
        do {
            if ((countOrig = origValue.read(origBuff)) != (countNew = newValue.read(newBuff))) {
                return false;
            }
            if (Arrays.equals(origBuff, newBuff)) continue;
            return false;
        } while (countOrig != -1);
        return true;
    }

    private long getStreamCheckSum(InputStream in) throws Exception {
        int read;
        CRC32 sum = new CRC32();
        byte[] buf = new byte[32768];
        while ((read = in.read(buf)) != -1) {
            sum.update(buf, 0, read);
        }
        in.close();
        return sum.getValue();
    }

    private void verifyInterval(Clob clob, long pos, int length, int testNum, int clobLength) throws Exception {
        block9: {
            try {
                int numBytes;
                String subStr = clob.getSubString(pos, length);
                BlobClob4BlobTest.assertEquals((String)"FAIL - getSubString returned wrong length", (long)Math.min(clob.length() - pos + 1L, (long)length), (long)subStr.length());
                BlobClob4BlobTest.assertEquals((String)"FAIL - clob has mismatched lengths", (long)clobLength, (long)clob.length());
                BlobClob4BlobTest.assertFalse((String)"FAIL - NO ERROR ON getSubString POS TOO LARGE", (pos > (long)(clobLength + 1) ? 1 : 0) != 0);
                char[] value = new char[length];
                Reader reader = clob.getCharacterStream();
                long skipped = 0L;
                if (clobLength > 0) {
                    BlobClob4BlobTest.println("clobLength: " + clobLength);
                    for (long left = pos - 1L; left > 0L && skipped >= 0L; left -= (skipped = reader.skip(Math.min(1024L, left))) > 0L ? skipped : 0L) {
                    }
                }
                if ((numBytes = reader.read(value)) >= 0) {
                    char[] readBytes = new char[numBytes];
                    System.arraycopy(value, 0, readBytes, 0, numBytes);
                    String valueString = new String(readBytes);
                    BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring value", (String)valueString, (String)subStr);
                } else {
                    BlobClob4BlobTest.assertTrue((String)"FAIL - wrong length", (subStr.length() == 0 ? 1 : 0) != 0);
                }
            }
            catch (SQLException e) {
                if (pos <= 0L) {
                    this.checkException(BLOB_BAD_POSITION, e);
                }
                if (pos > (long)(clobLength + 1)) {
                    this.checkException(BLOB_POSITION_TOO_LARGE, e);
                }
                throw e;
            }
            catch (StringIndexOutOfBoundsException obe) {
                if (pos > (long)clobLength && BlobClob4BlobTest.usingDB2Client()) break block9;
                throw obe;
            }
        }
    }

    private void verifyInterval(Blob blob, long pos, int length, int testNum, int blobLength) throws Exception {
        block7: {
            try {
                String subStr = new String(blob.getBytes(pos, length), "US-ASCII");
                BlobClob4BlobTest.assertEquals((String)"FAIL - getSubString returned wrong length ", (long)Math.min(blob.length() - pos + 1L, (long)length), (long)subStr.length());
                BlobClob4BlobTest.assertEquals((String)"FAIL - clob has mismatched lengths", (long)blobLength, (long)blob.length());
                BlobClob4BlobTest.assertFalse((String)"FAIL - NO ERROR ON getSubString POS TOO LARGE", (pos > (long)(blobLength + 1) ? 1 : 0) != 0);
                byte[] value = new byte[length];
                InputStream inStream = blob.getBinaryStream();
                inStream.skip(pos - 1L);
                int numBytes = inStream.read(value);
                if (numBytes >= 0) {
                    byte[] readBytes = new byte[numBytes];
                    System.arraycopy(value, 0, readBytes, 0, numBytes);
                    String valueString = new String(readBytes, "US-ASCII");
                    BlobClob4BlobTest.assertEquals((String)"FAIL - wrong substring value", (String)valueString, (String)subStr);
                } else {
                    BlobClob4BlobTest.assertTrue((String)"FAIL - wrong length", (subStr.length() == 0 ? 1 : 0) != 0);
                }
            }
            catch (SQLException e) {
                if (pos <= 0L) {
                    this.checkException(BLOB_BAD_POSITION, e);
                }
                if (pos > (long)(blobLength + 1)) {
                    this.checkException(BLOB_POSITION_TOO_LARGE, e);
                }
                throw e;
            }
            catch (NegativeArraySizeException nase) {
                if (pos > (long)blobLength && BlobClob4BlobTest.usingDB2Client()) break block7;
                throw nase;
            }
        }
    }

    public void testBlobContents(ResultSet rs) throws Exception {
        int nullCount = 0;
        int rowCount = 0;
        byte[] buff = new byte[128];
        int blobLength = 0;
        int i = 0;
        while (rs.next()) {
            int size;
            ++i;
            Blob blob = rs.getBlob(1);
            long crc32 = rs.getLong(3);
            boolean crc2Null = rs.wasNull();
            if (blob == null) {
                BlobClob4BlobTest.assertTrue((String)"FAIL - NULL BLOB but non-NULL checksum", (boolean)crc2Null);
                ++nullCount;
                continue;
            }
            ++rowCount;
            long blobcrc32 = this.getStreamCheckSum(blob.getBinaryStream());
            BlobClob4BlobTest.assertEquals((String)("FAIL - mismatched checksums for blob with length " + blob.length()), (long)blobcrc32, (long)crc32);
            InputStream fin = blob.getBinaryStream();
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            blobLength = rs.getInt(2);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column size", (int)blobLength, (int)columnSize);
            BlobClob4BlobTest.assertEquals((String)"FAIL - wrong column length", (long)blobLength, (long)blob.length());
        }
        BlobClob4BlobTest.assertEquals((String)("FAIL - wrong not null row count null:" + nullCount), (int)9, (int)rowCount);
        BlobClob4BlobTest.assertEquals((String)"FAIL - wrong null blob count", (int)1, (int)nullCount);
    }

    public void testBlobInsert() throws SQLException {
        String[] typeNames = new String[]{"int", "char(10)", "varchar(80)", "long varchar", "char(10) for bit data", "long varchar for bit data", "blob(80)"};
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table blobCheck (bl blob(80)) ");
        int columns = typeNames.length;
        for (int i = 0; i < columns; ++i) {
            if (typeNames[i].indexOf("blob") == -1) continue;
            String insert = "insert into blobCheck (bl ) values ('string' )";
            BlobClob4BlobTest.assertStatementError("42821", s, insert);
            insert = "insert into blobCheck (bl ) values (cast (" + Utilities.stringToHexLiteral("string") + " as blob(80)) )";
            s.execute(insert);
            insert = "insert into blobCheck (bl ) values (X'48' )";
            BlobClob4BlobTest.assertStatementError("42821", s, insert);
            insert = "insert into blobCheck (bl ) values (cast (X'C8' as blob(80)) )";
            s.execute(insert);
            insert = "insert into blobCheck (bl ) values ( X'a78a' )";
            BlobClob4BlobTest.assertStatementError("42821", s, insert);
            insert = "insert into blobCheck (bl ) values (cast (X'a78a' as blob(80)) )";
            s.execute(insert);
        }
        s.execute("drop table blobCheck");
    }

    private void checkException(String SQLState, SQLException se) throws Exception {
        if (!BlobClob4BlobTest.usingDB2Client()) {
            BlobClob4BlobTest.assertSQLState(SQLState, se);
        }
    }

    public void testRetrieveMoreThan32KLobs() throws SQLException {
        int numRows = 34000;
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("INSERT INTO TESTCLOB VALUES(?,?,?)");
        for (int i = 0; i < numRows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setString(3, "" + i);
            ps.executeUpdate();
            if (i % 1000 != 0) continue;
            this.commit();
        }
        this.commit();
        ResultSet rs = s.executeQuery("SELECT * from TESTCLOB");
        while (rs.next()) {
            rs.getInt(1);
            Clob c = rs.getClob(3);
            c.getSubString(1L, 100);
        }
        rs.close();
        conn.commit();
    }

    public void testDerby5113() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement insert = this.prepareStatement("insert into testblob(a) values ?");
        insert.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(5000L), 5000);
        insert.executeUpdate();
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select a from testblob");
        rs.next();
        Blob blob = rs.getBlob(1);
        byte[] bytes = blob.getBytes(1L, 3000);
        BlobClob4BlobTest.assertEquals(new LoopingAlphabetStream(3000L), new ByteArrayInputStream(bytes));
        blob.truncate(4000L);
        BlobClob4BlobTest.assertEquals((long)4000L, (long)blob.length());
        bytes = blob.getBytes(1L, 4000);
        BlobClob4BlobTest.assertEquals(new LoopingAlphabetStream(4000L), new ByteArrayInputStream(bytes));
        rs.close();
    }
}

