/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InternationalConnectSimpleDSTest
extends BaseJDBCTestCase {
    public InternationalConnectSimpleDSTest(String name) {
        super(name);
    }

    public void testSimpleDSConnect() throws SQLException {
        Connection conn;
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        try {
            conn = ds.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectSimpleDSTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectSimpleDSTest.assertSQLState("22005", se);
        }
        try {
            JDBCDataSource.setBeanProperty(ds, "user", "\u4e10");
            conn = ds.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectSimpleDSTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectSimpleDSTest.assertSQLState("22005", se);
        }
        try {
            JDBCDataSource.setBeanProperty(ds, "password", "\u4e10");
            conn = ds.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectSimpleDSTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectSimpleDSTest.assertSQLState("22005", se);
        }
    }

    public void tearDown() {
        TestConfiguration.getCurrent().shutdownEngine();
        InternationalConnectSimpleDSTest.removeDirectory(InternationalConnectSimpleDSTest.getSystemProperty("derby.system.home") + File.separator + "\u4e10");
    }

    public static Test suite() {
        if (InternationalConnectSimpleDSTest.getSystemProperty("os.name").startsWith("OS/400")) {
            return new TestSuite("emtpy InternationalConnectSimpleDSTest");
        }
        return TestConfiguration.defaultSuite(InternationalConnectSimpleDSTest.class);
    }
}

