/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CreateTableFromQueryTest
extends BaseJDBCTestCase {
    private Statement stmt;

    public CreateTableFromQueryTest(String name) {
        super(name);
    }

    public static void decorate(Statement stmt) throws SQLException {
        stmt.executeUpdate("create table t1(i int not null, s smallint, f float, dp double precision, v varchar(10) not null)");
        stmt.executeUpdate("create table t2 (a int, s varchar(5))");
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(CreateTableFromQueryTest.class);
        return new CleanDatabaseTestSetup(test){

            protected void decorateSQL(Statement stmt) throws SQLException {
                CreateTableFromQueryTest.decorate(stmt);
            }
        };
    }

    public void testBasicTableCreation() throws Exception {
        this.positiveTest("create table t3 as select * from t1 with no data", new String[]{"I", "S", "F", "DP", "V"}, new String[]{"NO", "YES", "YES", "YES", "NO"}, new String[]{"INTEGER", "SMALLINT", "DOUBLE", "DOUBLE", "VARCHAR"});
    }

    public void testCreateTableWithColumnList() throws Exception {
        this.positiveTest("create table t3 (a,b,c,d,e) as select * from t1 with no data", new String[]{"A", "B", "C", "D", "E"}, new String[]{"NO", "YES", "YES", "YES", "NO"}, new String[]{"INTEGER", "SMALLINT", "DOUBLE", "DOUBLE", "VARCHAR"});
    }

    public void testCreateTableWithSubsetOfColumns() throws Exception {
        this.positiveTest("create table t3 as select v,f from t1 with no data", new String[]{"V", "F"}, new String[]{"NO", "YES"}, new String[]{"VARCHAR", "DOUBLE"});
    }

    public void testCreateTableWithSubsetOfColumnsAndColumnList() throws Exception {
        this.positiveTest("create table t3 (a,b,c) as select v,dp,i from t1 with no data", new String[]{"A", "B", "C"}, new String[]{"NO", "YES", "NO"}, new String[]{"VARCHAR", "DOUBLE", "INTEGER"});
    }

    public void testCreateTableWithMultipleBaseTables() throws Exception {
        this.positiveTest("create table t3 (one, two) as select x.s, y.v from t1 y, t2 x where x.a = y.i with no data", new String[]{"ONE", "TWO"}, new String[]{"YES", "NO"}, new String[]{"VARCHAR", "VARCHAR"});
    }

    public void testCreateTableWithDerivedColumnName() throws Exception {
        this.positiveTest("create table t3 (x,y) as select 2*i,2.0*f from t1 with no data", new String[]{"X", "Y"}, new String[]{"NO", "YES"}, new String[]{"INTEGER", "DOUBLE"});
    }

    public void testCreateTableFromValues() throws Exception {
        this.positiveTest("create table t3 (x,y) as values (1, 'name') with no data", new String[]{"X", "Y"}, new String[]{"NO", "NO"}, new String[]{"INTEGER", "CHAR"});
    }

    public void testCreateTableWithGroupByInQuery() throws Exception {
        this.positiveTest("create table t3 (x, y) as  (select v, sum(i) from t1 where i > 0  group by i, v having i <=  ANY (select a from t2)) with no data", new String[]{"X", "Y"}, new String[]{"NO", "YES"}, new String[]{"VARCHAR", "INTEGER"});
    }

    public void testBaseTableDoesNotExist() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X05", this.stmt, "create table t3 as select * from t4 with no data");
    }

    public void testParametersNotAllowed() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X99", this.stmt, "create table t3 as select * from t1 where i = ? with no data");
    }

    public void testDuplicateColumnName() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X12", this.stmt, "create table t3 (c1,c2,c1) as select i, s, f from t1 with no data");
    }

    public void testColumnCountMismatch() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X70", this.stmt, "create table t3 (c1,c2,c3) as select i,s from t1 with no data");
    }

    public void testSystemGeneratedColumnName() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42909", this.stmt, "create table t3 as select i, 2*i from t1 with no data");
    }

    public void testNullValues() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X07", this.stmt, "create table t3 (x) as values null with no data");
    }

    public void testUnimplementedWithDataClause() throws Exception {
        CreateTableFromQueryTest.assertStatementError("0A000", this.stmt, "create table t3 as select * from t1 with data");
    }

    public void testInvalidDataType() throws Exception {
        CreateTableFromQueryTest.assertStatementError("42X71", this.stmt, "create table t as select systemalias from sys.sysaliases with no data");
        CreateTableFromQueryTest.assertStatementError("42X71", this.stmt, "create table t as select aliasinfo from sys.sysaliases with no data");
        CreateTableFromQueryTest.assertStatementError("42X71", this.stmt, "create table t(x) as values 12345678901234567890123456789012345678901234 with no data");
    }

    private void positiveTest(String sql, String[] columnNames, String[] nullability, String[] types) throws Exception {
        this.stmt.executeUpdate(sql);
        DatabaseMetaData dmd = this.getConnection().getMetaData();
        ResultSet rs = dmd.getColumns(null, null, "T3", null);
        int col = 0;
        while (rs.next()) {
            Assert.assertEquals((String)"Column names do not match:", (String)columnNames[col], (String)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((String)"Nullability incorrect:", (String)nullability[col], (String)rs.getString("IS_NULLABLE"));
            Assert.assertEquals((String)"Column type incorrect:", (String)types[col], (String)rs.getString("TYPE_NAME"));
            ++col;
        }
        Assert.assertEquals((String)"Unexpected column count:", (int)columnNames.length, (int)col);
        this.stmt.executeUpdate("drop table t3");
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.stmt = this.createStatement();
    }

    protected void tearDown() throws Exception {
        this.stmt.close();
        this.getConnection().commit();
        super.tearDown();
    }
}

