/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class JMXTest
extends MBeanTest {
    public JMXTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MBeanTest.suite(JMXTest.class, "JMXTest");
    }

    public void testDerbyRegisteredMBeansSimpleInfo() throws Exception {
        Set<ObjectName> derbyMBeans = this.getDerbyDomainMBeans();
        JMXTest.assertTrue((String)("Derby MBEan count:" + derbyMBeans.size()), (derbyMBeans.size() >= 2 ? 1 : 0) != 0);
        final MBeanServerConnection jmx = this.getMBeanServerConnection();
        for (final ObjectName name : derbyMBeans) {
            String type = name.getKeyProperty("type");
            JMXTest.assertNotNull((Object)type);
            MBeanInfo mbeanInfo = AccessController.doPrivileged(new PrivilegedExceptionAction<MBeanInfo>(){

                @Override
                public MBeanInfo run() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                    return jmx.getMBeanInfo(name);
                }
            });
            String mbeanClassName = mbeanInfo.getClassName();
            JMXTest.assertTrue((boolean)mbeanClassName.startsWith("org.apache.derby.mbeans."));
            if ("Management".equals(type) && "org.apache.derby.mbeans.Management".equals(mbeanClassName)) continue;
            JMXTest.assertTrue((boolean)mbeanClassName.endsWith("MBean"));
            String scn = mbeanClassName.substring(mbeanClassName.lastIndexOf(46) + 1);
            scn = scn.substring(0, scn.length() - "MBean".length());
            JMXTest.assertEquals((String)scn, (String)type);
        }
    }
}

