/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.textui.TestRunner;
import org.apache.derby.tools.ij;

public class DerbyJUnitTest
extends TestCase {
    public static final String DEBUG_FLAG = "drb.tests.debug";
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final String DEFAULT_USER_NAME = "APP";
    public static final String DEFAULT_PASSWORD = "APP";
    public static final String DEFAULT_DATABASE_NAME = "wombat";
    protected static final int JDBC_BOOLEAN = 16;
    private static final String TABLE = "table";
    private static final String FUNCTION = "function";
    private static final String PROCEDURE = "procedure";
    private static final String TYPE = "type";
    private static final String SERVER_URL = "jdbc:derby://localhost:1527/";
    private static final String CREATE_PROPERTY = "create=true";
    public static final int DATABASE_URL = 0;
    public static final int DRIVER_NAME = 1;
    public static final int FRAMEWORK_NAME = 2;
    private static final String[] DB2JCC_CLIENT = new String[]{"jdbc:derby:net://localhost:1527/", "com.ibm.db2.jcc.DB2Driver", "DerbyNet"};
    private static final String[] DERBY_CLIENT = new String[]{"jdbc:derby://localhost:1527/", "org.apache.derby.jdbc.ClientDriver", "DerbyNetClient"};
    private static final String[] EMBEDDED_CLIENT = new String[]{"jdbc:derby:", "org.apache.derby.jdbc.EmbeddedDriver", "embedded"};
    public static final String[][] LEGAL_CLIENTS = new String[][]{DB2JCC_CLIENT, DERBY_CLIENT, EMBEDDED_CLIENT};
    private static boolean _debug;
    private static PrintStream _outputStream;
    private static String _databaseName;
    private static String[] _defaultClientSettings;
    private static boolean _initializedForTestHarness;

    public static void runUnderOldHarness(String[] args, Test suite) throws Exception {
        int exitStatus = 1;
        DerbyJUnitTest.initializeForOldHarness(args);
        TestResult result = TestRunner.run((Test)suite);
        exitStatus = result.errorCount() + result.failureCount();
        Runtime.getRuntime().exit(exitStatus);
    }

    public static void initializeForOldHarness(String[] args) throws Exception {
        if (_initializedForTestHarness) {
            return;
        }
        DerbyJUnitTest.parseDebug();
        DerbyJUnitTest.setDatabaseName(DEFAULT_DATABASE_NAME);
        DerbyJUnitTest.findClientFromProperties();
        ij.getPropertyArg((String[])args);
        Connection conn = ij.startJBMS();
        _initializedForTestHarness = true;
    }

    public boolean usingEmbeddedClient() {
        return _defaultClientSettings == EMBEDDED_CLIENT;
    }

    public boolean usingDerbyClient() {
        return _defaultClientSettings == DERBY_CLIENT;
    }

    public boolean usingDB2Client() {
        return _defaultClientSettings == DB2JCC_CLIENT;
    }

    public static String[] getClientSettings() {
        return _defaultClientSettings;
    }

    public static void setClient(String[] client) {
        _defaultClientSettings = client;
    }

    public static void setDatabaseName(String databaseName) {
        _databaseName = databaseName;
    }

    public static void setDebug(boolean value) {
        _debug = value;
    }

    public static boolean parseDebug() {
        _debug = Boolean.getBoolean(DEBUG_FLAG);
        return true;
    }

    public static void println(String text) {
        if (_debug) {
            DerbyJUnitTest.alarm(text);
        }
    }

    public static void alarm(String text) {
        _outputStream.println(text);
        _outputStream.flush();
    }

    public static void printStackTrace(Throwable t) {
        while (t != null) {
            t.printStackTrace(_outputStream);
            if (!(t instanceof SQLException)) break;
            t = ((SQLException)t).getNextException();
        }
    }

    public static void findClientFromProperties() throws Exception {
        Properties systemProps = System.getProperties();
        String frameworkName = systemProps.getProperty("framework", EMBEDDED_CLIENT[2]);
        int count = LEGAL_CLIENTS.length;
        for (int i = 0; i < count; ++i) {
            String[] candidate = LEGAL_CLIENTS[i];
            if (!candidate[2].equals(frameworkName)) continue;
            _defaultClientSettings = candidate;
            return;
        }
        throw new Exception("Unrecognized framework: " + frameworkName);
    }

    public void exit(int exitStatus) {
        Runtime.getRuntime().exit(exitStatus);
    }

    protected static boolean faultInDriver(String[] clientSettings) {
        String currentClientName = clientSettings[1];
        try {
            Class.forName(currentClientName);
            return true;
        }
        catch (Exception e) {
            DerbyJUnitTest.println("Could not find " + currentClientName);
            return false;
        }
    }

    protected static Connection getConnection() throws Exception {
        return DerbyJUnitTest.getConnection(_defaultClientSettings, _databaseName, new Properties());
    }

    protected static Connection getConnection(String[] clientSettings, String databaseName, Properties properties) throws Exception {
        DerbyJUnitTest.faultInDriver(clientSettings);
        properties.put("user", "APP");
        properties.put("password", "APP");
        properties.put("retreiveMessagesFromServerOnGetMessage", "true");
        Connection conn = DriverManager.getConnection(DerbyJUnitTest.makeDatabaseURL(clientSettings, databaseName), properties);
        DerbyJUnitTest.println("Connection is a " + conn.getClass().getName());
        return conn;
    }

    private static String makeDatabaseURL(String[] clientSettings, String databaseName) {
        return clientSettings[0] + databaseName;
    }

    protected void createDB(String databaseName) throws Exception {
        String[] clientSettings = DerbyJUnitTest.getClientSettings();
        String dbURL = DerbyJUnitTest.makeDatabaseURL(clientSettings, databaseName);
        dbURL = dbURL + ';' + CREATE_PROPERTY;
        Properties properties = new Properties();
        properties.put("user", "APP");
        properties.put("password", "APP");
        DerbyJUnitTest.faultInDriver(clientSettings);
        Connection conn = DriverManager.getConnection(dbURL, properties);
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeDDL(Connection conn, String text) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = DerbyJUnitTest.prepare(conn, text);
            ps.execute();
        }
        finally {
            DerbyJUnitTest.close(ps);
        }
    }

    protected static void execute(Connection conn, String text) throws SQLException {
        PreparedStatement ps = DerbyJUnitTest.prepare(conn, text);
        ps.execute();
        DerbyJUnitTest.close(ps);
    }

    protected static PreparedStatement prepare(Connection conn, String text) throws SQLException {
        DerbyJUnitTest.println("Preparing: " + text);
        return conn.prepareStatement(text);
    }

    protected static CallableStatement prepareCall(Connection conn, String text) throws SQLException {
        DerbyJUnitTest.println("Preparing procedure call: '" + text + "'");
        CallableStatement cs = conn.prepareCall(text);
        return cs;
    }

    protected static void truncateTable(Connection conn, String name) throws SQLException {
        PreparedStatement ps = DerbyJUnitTest.prepare(conn, "delete from " + name);
        ps.execute();
    }

    protected static void dropTable(Connection conn, String name) {
        DerbyJUnitTest.dropSchemaObject(conn, TABLE, name, false);
    }

    protected static void dropFunction(Connection conn, String name) {
        DerbyJUnitTest.dropSchemaObject(conn, FUNCTION, name, false);
    }

    protected static void dropProcedure(Connection conn, String name) {
        DerbyJUnitTest.dropSchemaObject(conn, PROCEDURE, name, false);
    }

    protected static void dropUDT(Connection conn, String name) {
        DerbyJUnitTest.dropSchemaObject(conn, TYPE, name, true);
    }

    protected static void dropSchemaObject(Connection conn, String genus, String objectName, boolean restrict) {
        PreparedStatement ps;
        block3: {
            ps = null;
            try {
                String text = "drop " + genus + " " + objectName;
                if (restrict) {
                    text = text + " restrict";
                }
                ps = DerbyJUnitTest.prepare(conn, text);
                ps.execute();
            }
            catch (SQLException e) {
                if (!_debug) break block3;
                DerbyJUnitTest.printStackTrace(e);
            }
        }
        DerbyJUnitTest.close(ps);
    }

    protected static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            DerbyJUnitTest.printStackTrace(e);
        }
    }

    protected static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            DerbyJUnitTest.printStackTrace(e);
        }
    }

    protected static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            DerbyJUnitTest.printStackTrace(e);
        }
    }

    protected Object getColumn(ResultSet rs, String columnName, int jdbcType) throws Exception {
        Object retval = null;
        switch (jdbcType) {
            case 16: {
                retval = new Boolean(rs.getBoolean(columnName));
                break;
            }
            case -5: {
                retval = new Long(rs.getLong(columnName));
                break;
            }
            case 2004: {
                retval = rs.getBlob(columnName);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                retval = rs.getString(columnName);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                retval = rs.getBytes(columnName);
                break;
            }
            case 2005: {
                retval = rs.getClob(columnName);
                break;
            }
            case 91: {
                retval = rs.getDate(columnName);
                break;
            }
            case 2: 
            case 3: {
                retval = rs.getBigDecimal(columnName);
                break;
            }
            case 8: {
                retval = new Double(rs.getDouble(columnName));
                break;
            }
            case 7: {
                retval = new Float(rs.getFloat(columnName));
                break;
            }
            case 4: {
                retval = new Integer(rs.getInt(columnName));
                break;
            }
            case 5: {
                retval = new Short(rs.getShort(columnName));
                break;
            }
            case 92: {
                retval = rs.getTime(columnName);
                break;
            }
            case 93: {
                retval = rs.getTimestamp(columnName);
                break;
            }
            default: {
                DerbyJUnitTest.fail((String)("Unknown jdbc type " + jdbcType + " used to retrieve column: " + columnName));
            }
        }
        if (rs.wasNull()) {
            retval = null;
        }
        return retval;
    }

    protected Object getColumn(ResultSet rs, int param, Object value) throws Exception {
        Object retval = value == null ? rs.getObject(param) : (value instanceof Boolean ? new Boolean(rs.getBoolean(param)) : (value instanceof Byte ? new Byte(rs.getByte(param)) : (value instanceof Short ? new Short(rs.getShort(param)) : (value instanceof Integer ? new Integer(rs.getInt(param)) : (value instanceof Long ? new Long(rs.getLong(param)) : (value instanceof Float ? new Float(rs.getFloat(param)) : (value instanceof Double ? new Double(rs.getDouble(param)) : (value instanceof String ? rs.getString(param) : (value instanceof BigDecimal ? rs.getBigDecimal(param) : rs.getObject(param))))))))));
        if (rs.wasNull()) {
            retval = null;
        }
        return retval;
    }

    protected Object getOutArg(CallableStatement cs, int arg, int jdbcType) throws Exception {
        Object retval = null;
        switch (jdbcType) {
            case 16: {
                retval = new Boolean(cs.getBoolean(arg));
                break;
            }
            case -5: {
                retval = new Long(cs.getLong(arg));
                break;
            }
            case 2004: {
                retval = cs.getBlob(arg);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                retval = cs.getString(arg);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                retval = cs.getBytes(arg);
                break;
            }
            case 2005: {
                retval = cs.getClob(arg);
                break;
            }
            case 91: {
                retval = cs.getDate(arg);
                break;
            }
            case 2: 
            case 3: {
                retval = cs.getBigDecimal(arg);
                break;
            }
            case 8: {
                retval = new Double(cs.getDouble(arg));
                break;
            }
            case 7: {
                retval = new Float(cs.getFloat(arg));
                break;
            }
            case 4: {
                retval = new Integer(cs.getInt(arg));
                break;
            }
            case 5: {
                retval = new Short(cs.getShort(arg));
                break;
            }
            case 92: {
                retval = cs.getTime(arg);
                break;
            }
            case 93: {
                retval = cs.getTimestamp(arg);
                break;
            }
            default: {
                DerbyJUnitTest.fail((String)("Unknown jdbc type " + jdbcType + " used to retrieve column: " + arg));
            }
        }
        if (cs.wasNull()) {
            retval = null;
        }
        return retval;
    }

    protected void setParameter(PreparedStatement ps, int param, int jdbcType, Object value) throws Exception {
        if (value == null) {
            ps.setNull(param, jdbcType);
            return;
        }
        switch (jdbcType) {
            case 16: {
                ps.setBoolean(param, (Boolean)value);
                break;
            }
            case -5: {
                ps.setLong(param, (Long)value);
                break;
            }
            case 2004: {
                ps.setBlob(param, (Blob)value);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                ps.setString(param, (String)value);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                ps.setBytes(param, (byte[])value);
                break;
            }
            case 2005: {
                ps.setClob(param, (Clob)value);
                break;
            }
            case 91: {
                ps.setDate(param, (Date)value);
                break;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(param, (BigDecimal)value);
                break;
            }
            case 8: {
                ps.setDouble(param, (Double)value);
                break;
            }
            case 7: {
                ps.setFloat(param, ((Float)value).floatValue());
                break;
            }
            case 4: {
                ps.setInt(param, (Integer)value);
                break;
            }
            case 5: {
                ps.setShort(param, (Short)value);
                break;
            }
            case 92: {
                ps.setTime(param, (Time)value);
                break;
            }
            case 93: {
                ps.setTimestamp(param, (Timestamp)value);
                break;
            }
            default: {
                DerbyJUnitTest.fail((String)("Unknown jdbc type: " + jdbcType));
            }
        }
    }

    protected void setParameter(PreparedStatement ps, int param, Object value) throws Exception {
        if (value == null) {
            ps.setObject(param, null);
            return;
        }
        if (value instanceof Boolean) {
            ps.setBoolean(param, (Boolean)value);
        } else if (value instanceof Byte) {
            ps.setByte(param, (Byte)value);
        } else if (value instanceof Short) {
            ps.setShort(param, (Short)value);
        } else if (value instanceof Integer) {
            ps.setInt(param, (Integer)value);
        } else if (value instanceof Long) {
            ps.setLong(param, (Long)value);
        } else if (value instanceof Float) {
            ps.setFloat(param, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            ps.setDouble(param, (Double)value);
        } else if (value instanceof String) {
            ps.setString(param, (String)value);
        } else {
            ps.setObject(param, value);
        }
    }

    protected String singleQuote(String text) {
        return "'" + text + "'";
    }

    public void assertRow(ResultSet rs, Object[] expectedRow) throws Exception {
        int count = expectedRow.length;
        for (int i = 0; i < count; ++i) {
            int columnNumber = i + 1;
            Object expected = expectedRow[i];
            Object actual = this.getColumn(rs, columnNumber, expected);
            this.compareObjects("Column number " + columnNumber, expected, actual);
        }
    }

    public void assertScalar(Connection conn, String queryText, Object expectedResult) throws Exception {
        PreparedStatement ps = DerbyJUnitTest.prepare(conn, queryText);
        ResultSet rs = ps.executeQuery();
        rs.next();
        this.assertColumnEquals(queryText, rs, 1, expectedResult);
        DerbyJUnitTest.close(rs);
        DerbyJUnitTest.close(ps);
    }

    public void assertColumnEquals(ResultSet rs, int columnNumber, Object[] expectedValues) throws Exception {
        int count = expectedValues.length;
        for (int i = 0; i < count; ++i) {
            rs.next();
            this.assertColumnEquals(Integer.toString(i), rs, columnNumber, expectedValues[i]);
        }
    }

    public void assertColumnEquals(String message, ResultSet rs, int columnNumber, Object expectedValue) throws Exception {
        Object actualValue = this.getColumn(rs, columnNumber, expectedValue);
        this.compareObjects(message, expectedValue, actualValue);
    }

    public void compareObjects(String message, Object left, Object right) throws Exception {
        message = message + "\n\t expected = " + left + "\n\t actual = " + right;
        if (left == null) {
            DerbyJUnitTest.assertNull((String)message, (Object)right);
        } else {
            DerbyJUnitTest.assertNotNull((String)message, (Object)right);
            if (left instanceof byte[]) {
                this.compareBytes(message, left, right);
            } else if (left instanceof java.util.Date) {
                this.compareDates(message, left, right);
            } else {
                DerbyJUnitTest.assertTrue((String)message, (boolean)left.equals(right));
            }
        }
    }

    public void compareBytes(String message, Object left, Object right) throws Exception {
        if (left == null) {
            DerbyJUnitTest.assertNull((String)message, (Object)right);
        } else {
            DerbyJUnitTest.assertNotNull((Object)right);
        }
        if (!(left instanceof byte[])) {
            DerbyJUnitTest.fail((String)message);
        }
        if (!(right instanceof byte[])) {
            DerbyJUnitTest.fail((String)message);
        }
        byte[] leftBytes = (byte[])left;
        byte[] rightBytes = (byte[])right;
        int count = leftBytes.length;
        DerbyJUnitTest.assertEquals((String)message, (int)count, (int)rightBytes.length);
        for (int i = 0; i < count; ++i) {
            DerbyJUnitTest.assertEquals((String)(message + "[ " + i + " ]"), (byte)leftBytes[i], (byte)rightBytes[i]);
        }
    }

    public void compareDates(String message, Object left, Object right) throws Exception {
        if (left == null) {
            DerbyJUnitTest.assertNull((String)message, (Object)right);
        } else {
            DerbyJUnitTest.assertNotNull((Object)right);
        }
        if (!(left instanceof java.util.Date)) {
            DerbyJUnitTest.fail((String)message);
        }
        if (!(right instanceof java.util.Date)) {
            DerbyJUnitTest.fail((String)message);
        }
        DerbyJUnitTest.assertEquals((String)message, (String)left.toString(), (String)right.toString());
    }

    static {
        _outputStream = System.out;
    }
}

