/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public final class SpawnedProcess {
    private final String name;
    private final Process javaProcess;
    private final StreamSaver errSaver;
    private final StreamSaver outSaver;
    int stdOutReadOffset;

    public SpawnedProcess(Process javaProcess, String name) {
        this.javaProcess = javaProcess;
        this.name = name;
        this.errSaver = this.streamSaver(javaProcess.getErrorStream(), name.concat(":System.err"));
        this.outSaver = this.streamSaver(javaProcess.getInputStream(), name.concat(":System.out"));
    }

    public Process getProcess() {
        return this.javaProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullServerOutput() throws Exception {
        this.outSaver.thread.join();
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            return this.outSaver.stream.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextServerOutput() throws Exception {
        byte[] fullData;
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            fullData = this.outSaver.stream.toByteArray();
        }
        String output = new String(fullData, this.stdOutReadOffset, fullData.length - this.stdOutReadOffset);
        this.stdOutReadOffset = fullData.length;
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFailMessage(String reason) throws InterruptedException {
        Thread.sleep(500L);
        StringBuffer sb = new StringBuffer();
        sb.append(reason);
        sb.append(":Spawned ");
        sb.append(this.name);
        sb.append(" exitCode=");
        try {
            sb.append(this.javaProcess.exitValue());
        }
        catch (IllegalThreadStateException e) {
            sb.append("running");
        }
        ByteArrayOutputStream err = this.errSaver.stream;
        ByteArrayOutputStream out = this.outSaver.stream;
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            if (err.size() != 0) {
                sb.append("\nSTDERR:\n");
                sb.append(err.toString());
            }
            if (out.size() != 0) {
                sb.append("\nSTDOUT:\n");
                sb.append(out.toString());
            }
        }
        return sb.toString();
    }

    public int complete(boolean destroy) throws InterruptedException, IOException {
        return this.complete(destroy, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int complete(boolean destroy, long timeout) throws InterruptedException, IOException {
        int exitCode;
        if (timeout >= 0L) {
            long start = System.currentTimeMillis();
            boolean timedOut = true;
            long totalwait = -1L;
            while (totalwait < timeout) {
                try {
                    exitCode = this.javaProcess.exitValue();
                    timedOut = false;
                    destroy = false;
                    break;
                }
                catch (IllegalThreadStateException ite) {
                    Thread.sleep(1000L);
                    totalwait = System.currentTimeMillis() - start;
                }
            }
            if (timedOut) {
                destroy = true;
            }
        }
        if (destroy) {
            this.javaProcess.destroy();
        }
        exitCode = this.javaProcess.waitFor();
        this.outSaver.thread.join();
        this.errSaver.thread.join();
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            ByteArrayOutputStream err = this.errSaver.stream;
            if (err.size() != 0) {
                System.err.println("START-SPAWNED:" + this.name + " ERROR OUTPUT:");
                err.writeTo(System.err);
                System.err.println("END-SPAWNED  :" + this.name + " ERROR OUTPUT:");
            }
            ByteArrayOutputStream out = this.outSaver.stream;
            if ((destroy || exitCode != 0) && out.size() != 0) {
                System.out.println("START-SPAWNED:" + this.name + " STANDARD OUTPUT: exit code=" + exitCode);
                out.writeTo(System.out);
                System.out.println("END-SPAWNED  :" + this.name + " STANDARD OUTPUT:");
            }
        }
        return exitCode;
    }

    private StreamSaver streamSaver(final InputStream in, String name) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream(){

            public void reset() {
                super.reset();
                new Throwable("WWW").printStackTrace(System.out);
            }
        };
        Thread streamReader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = in.read(buffer)) != -1) {
                        SpawnedProcess spawnedProcess = SpawnedProcess.this;
                        synchronized (spawnedProcess) {
                            out.write(buffer, 0, read);
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(new PrintStream(out, true));
                }
            }
        }, name);
        streamReader.setDaemon(true);
        streamReader.start();
        return new StreamSaver(out, streamReader);
    }

    private static class StreamSaver {
        final ByteArrayOutputStream stream;
        final Thread thread;

        StreamSaver(ByteArrayOutputStream stream, Thread thread) {
            this.stream = stream;
            this.thread = thread;
        }
    }
}

