/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.direct;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derbyTesting.system.oe.client.Submitter;
import org.apache.derbyTesting.system.oe.direct.StatementHelper;
import org.apache.derbyTesting.system.oe.model.Address;
import org.apache.derbyTesting.system.oe.model.Customer;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class SimpleNonStandardOperations
extends StatementHelper {
    private final Customer customer = new Customer();
    private final Address address = new Address();
    private final OERandom rand;

    public SimpleNonStandardOperations(Connection conn, int isolation) throws SQLException {
        super(conn, false, isolation);
        this.rand = Submitter.getRuntimeRandom(conn);
    }

    public static SimpleNonStandardOperations noReset(Connection conn, int isolation) throws SQLException {
        return new SimpleNonStandardOperations(conn, isolation){

            protected void reset(PreparedStatement ps) {
            }
        };
    }

    public void customerInquiry(int scale) throws SQLException {
        this.customerInquiry((short)this.rand.randomInt(1, scale), this.rand.district(), this.rand.NURand1023());
    }

    public void customerInquiry(short w, short d, int c) throws SQLException {
        PreparedStatement customerInquiry = this.prepareStatement("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        customerInquiry.setShort(1, w);
        customerInquiry.setShort(2, d);
        customerInquiry.setInt(3, c);
        ResultSet rs = customerInquiry.executeQuery();
        rs.next();
        this.customer.clear();
        this.customer.setBalance(rs.getString("C_BALANCE"));
        this.customer.setFirst(rs.getString("C_FIRST"));
        this.customer.setMiddle(rs.getString("C_MIDDLE"));
        this.customer.setLast(rs.getString("C_LAST"));
        this.customer.setAddress(this.getAddress(this.address, rs, "C_STREET_1"));
        this.customer.setPhone(rs.getString("C_PHONE"));
        this.reset(customerInquiry);
        this.conn.commit();
    }

    public void customerAddressChange(int scale) throws SQLException {
        this.customerAddressChange((short)this.rand.randomInt(1, scale), this.rand.district(), this.rand.NURand1023());
    }

    public void customerAddressChange(short w, short d, int c) throws SQLException {
        PreparedStatement customerAddressChange = this.prepareStatement("UPDATE CUSTOMER SET C_STREET_1 = ?, C_STREET_2 = ?, C_CITY = ?, C_STATE = ?, C_ZIP = ? WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        customerAddressChange.setString(1, this.rand.randomAString10_20());
        customerAddressChange.setString(2, this.rand.randomAString10_20());
        customerAddressChange.setString(3, this.rand.randomAString10_20());
        customerAddressChange.setString(4, this.rand.randomState());
        customerAddressChange.setString(5, this.rand.randomZIP());
        customerAddressChange.setShort(6, w);
        customerAddressChange.setShort(7, d);
        customerAddressChange.setInt(8, c);
        customerAddressChange.executeUpdate();
        this.reset(customerAddressChange);
        this.conn.commit();
    }
}

