/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Arrays;
import java.util.Properties;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_AccessRow;
import org.apache.derbyTesting.unitTests.store.T_Util;
import org.apache.derbyTesting.unitTests.store.commit_method;
import org.apache.derbyTesting.unitTests.util.BitUtil;

public class T_XA
extends T_Generic {
    private static final String testService = "XaTest";
    byte[] global_id = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    byte[] branch_id = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    AccessFactory store = null;

    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    protected void runTests() throws T_Fail {
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.store = (AccessFactory)Monitor.createPersistentService((String)this.getModuleToTestProtocolName(), (String)testService, (Properties)this.startParams);
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (this.store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.REPORT("(unitTestMain) Testing XaTest");
        try {
            this.XATest_1(new commit_method(this.store, true));
            this.XATest_2(new commit_method(this.store, true));
            this.XATest_3(new commit_method(this.store, true));
            this.XATest_4(new commit_method(this.store, true));
            this.XATest_5(new commit_method(this.store, true));
            this.XATest_6(new commit_method(this.store, true));
            this.XATest_1(new commit_method(this.store, false));
            this.XATest_2(new commit_method(this.store, false));
            this.XATest_3(new commit_method(this.store, false));
            this.XATest_4(new commit_method(this.store, false));
            this.XATest_5(new commit_method(this.store, false));
            this.XATest_6(new commit_method(this.store, false));
        }
        catch (StandardException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = ((Object)((Object)e)).getClass().getName();
            }
            this.REPORT(msg);
            e.printStackTrace();
            throw T_Fail.exceptionFail(e);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void XATest_1(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_1) starting");
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        XATransactionController xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        ScanController scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan1.next();
        scan1.close();
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        this.REPORT("(XATest_1) finishing");
    }

    void XATest_2(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_2) starting");
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        XATransactionController xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        if (!xa_tc.isGlobal()) {
            throw T_Fail.testFailMsg("should be a global transaction.");
        }
        if (xa_tc.xa_prepare() != 1) {
            throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
        }
        try {
            commit_method2.commit(false, 42, null, null, xa_tc);
            throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact cant be 2P xa_committed.");
        }
        catch (StandardException se) {
            if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
            }
            xa_tc.destroy();
            xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
            T_AccessRow template_row = new T_AccessRow(1);
            long conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
            if (xa_tc.xa_prepare() != 2) {
                throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
            }
            commit_method2.commit(false, 42, this.global_id, this.branch_id, xa_tc);
            xa_tc.destroy();
            xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
            ScanController scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
            scan1.next();
            scan1.close();
            if (xa_tc.xa_prepare() != 1) {
                throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
            }
            try {
                commit_method2.commit(false, 42, null, null, xa_tc);
                throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact cant be 2P xa_committed.");
            }
            catch (StandardException se2) {
                if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                    throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
                }
                xa_tc.destroy();
                this.REPORT("(XATest_2) finishing");
                return;
            }
        }
    }

    void XATest_3(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_3) starting");
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        XATransactionController xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        commit_method2.rollback(42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        commit_method2.rollback(42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        template_row = new T_AccessRow(1);
        conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        ScanController scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan1.next();
        scan1.close();
        commit_method2.rollback(42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        this.REPORT("(XATest_3) finishing");
    }

    void XATest_4(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_4) starting");
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        XATransactionController xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        if (xa_tc.xa_prepare() != 1) {
            throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
        }
        commit_method2.commit(true, 42, null, null, xa_tc);
        if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
            throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
        }
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        ScanController scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan1.next();
        scan1.close();
        if (xa_tc.xa_prepare() != 2) {
            throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
        }
        try {
            scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
            scan1.next();
            scan1.close();
            throw T_Fail.testFailMsg("Should not be able to do anything on xact after prepare.");
        }
        catch (StandardException se) {
            commit_method2.rollback(42, this.global_id, this.branch_id, xa_tc);
            commit_method2.commit(true, 42, null, null, xa_tc);
            if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                throw T_Fail.testFailMsg("A xa_rollbacked xact should not be findable.");
            }
            xa_tc.destroy();
            xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
            try {
                scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
                scan1.next();
                scan1.close();
                throw T_Fail.testFailMsg("Should not be able to open conglom, the create was aborted.");
            }
            catch (StandardException se2) {
                xa_tc.destroy();
                xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
                template_row = new T_AccessRow(1);
                conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
                commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
                xa_tc.destroy();
                xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
                scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
                scan1.next();
                scan1.close();
                if (xa_tc.xa_prepare() != 1) {
                    throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
                }
                commit_method2.commit(true, 42, null, null, xa_tc);
                if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                    throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
                }
                xa_tc.destroy();
                this.REPORT("(XATest_5) finishing");
                return;
            }
        }
    }

    void XATest_5(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_5) starting");
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0).length != 0) {
            throw T_Fail.testFailMsg("NOFLAGS should always return 0.");
        }
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        XATransactionController xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        ScanController scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan1.next();
        scan1.close();
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xa_tc);
        xa_tc.destroy();
        xa_tc = (XATransactionController)this.store.startXATransaction(cm, 42, this.global_id, this.branch_id);
        template_row = new T_AccessRow(1);
        conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        if (xa_tc.xa_prepare() != 2) {
            throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
        }
        try {
            scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
            scan1.next();
            scan1.close();
            throw T_Fail.testFailMsg("Should not be able to do anything on xact after prepare.");
        }
        catch (StandardException se) {
            Xid[] prepared_xacts = ((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000);
            if (prepared_xacts.length != 1) {
                throw T_Fail.testFailMsg("recover incorrectly returned wrong prepared xacts.");
            }
            if (prepared_xacts[0].getFormatId() != 42) {
                throw T_Fail.testFailMsg("bad format id = " + prepared_xacts[0].getFormatId());
            }
            byte[] gid = prepared_xacts[0].getGlobalTransactionId();
            if (!Arrays.equals(gid, this.global_id)) {
                throw T_Fail.testFailMsg("bad global id = " + BitUtil.hexDump(gid));
            }
            byte[] bid = prepared_xacts[0].getBranchQualifier();
            if (!Arrays.equals(bid, this.branch_id)) {
                throw T_Fail.testFailMsg("bad branch id = " + BitUtil.hexDump(bid));
            }
            if (((XAResourceManager)this.store.getXAResourceManager()).recover(0).length != 0) {
                throw T_Fail.testFailMsg("NOFLAGS should always return 0.");
            }
            commit_method2.commit(false, 42, this.global_id, this.branch_id, xa_tc);
            if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
                throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
            }
            xa_tc.destroy();
            if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
                throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
            }
            this.REPORT("(XATest_5) finishing");
            return;
        }
    }

    void XATest_6(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_5) starting");
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        TransactionController tc = this.store.getTransaction(cm);
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        tc.commit();
        XATransactionController xa_tc = (XATransactionController)tc.createXATransactionFromLocalTransaction(42, this.global_id, this.branch_id);
        if (!xa_tc.isGlobal()) {
            throw T_Fail.testFailMsg("should be a global transaction.");
        }
        ScanController scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan1.next();
        scan1.close();
        template_row = new T_AccessRow(1);
        conglomid = xa_tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        if (xa_tc.xa_prepare() != 2) {
            throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
        }
        try {
            scan1 = xa_tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
            scan1.next();
            scan1.close();
            throw T_Fail.testFailMsg("Should not be able to do anything on xact after prepare.");
        }
        catch (StandardException se) {
            commit_method2.commit(false, 42, this.global_id, this.branch_id, xa_tc);
            xa_tc.destroy();
            this.REPORT("(XATest_6) finishing");
            return;
        }
    }
}

