/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.connect;

import java.util.Date;

import jdbcacsess2.connect.ConfigConnect.ConfigConnectImpl;
import net.java.ao.Entity;
import net.java.ao.Implementation;
import net.java.ao.Preload;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.Unique;

/**
 * 接続情報を永続化する為のActiveObjects用エンティティクラス
 * @author sima
 *
 */
@Preload
@Implementation(ConfigConnectImpl.class)
public interface ConfigConnect extends Entity {

	@Unique
	String getConnectName();

	void setConnectName(String connectName);

	ConfigDbms getConfigDbms();

	void setConfigDbms(ConfigDbms dbms);

	String getConnectUser();

	void setConnectUser(String connectuser);

	String getPassword();

	void setPassword(String password);

	String getHostName();

	void setHostName(String hostname);

	String getPortNumber();

	void setPortNumber(String portNumber);

	String getDatabaseName();

	void setDatabaseName(String databaseName);

	String getClassName();

	void setClassName(String className);

	String getDriverFile();

	void setDriverFile(String driverFile);

	String getUrlOption();

	void setUrlOption(String urlOption);

	Date getLastConnectdate();

	void setLastConnectdate(Date lastConnectdate);

	@Ignore
	public StringBuilder convertRowheader();

	@Ignore
	public StringBuilder convertRow();

	public static String CONNECTNAME = "connectname";
	public static String DBMS = "dbms";
	public static String CONNECTUSER = "connectuser";
	public static String PASSWORD = "password";
	public static String HOSTNAME = "hostname";
	public static String PORTNUMBER = "portnumber";
	public static String DATABASENAME = "databasename";
	public static String CLASSNAME = "classname";
	public static String DRIVERFILE = "driverfile";
	public static String URLOPTION = "urloption";
	public static String LASTCONNECTDATE = "lastconnectdate";

	public class ConfigConnectImpl {
		private final ConfigConnect configConnect;

		public ConfigConnectImpl(ConfigConnect configConnect) {
			this.configConnect = configConnect;
		}

		public StringBuilder convertRowheader() {
			StringBuilder sb = new StringBuilder();
			sb.append('"' + CONNECTNAME + '"');
			sb.append("," + '"' + DBMS + '"');
			sb.append("," + '"' + CONNECTUSER + '"');
			sb.append("," + '"' + PASSWORD + '"');
			sb.append("," + '"' + HOSTNAME + '"');
			sb.append("," + '"' + PORTNUMBER + '"');
			sb.append("," + '"' + DATABASENAME + '"');
			sb.append("," + '"' + CLASSNAME + '"');
			sb.append("," + '"' + DRIVERFILE + '"');
			sb.append("," + '"' + URLOPTION + '"');
			sb.append("," + '"' + LASTCONNECTDATE + '"');
			return sb;
		}

		public StringBuilder convertRow() {
			StringBuilder sb = new StringBuilder();
			sb.append('"' + configConnect.getConnectName() + '"');
			sb.append("," + '"' + configConnect.getConfigDbms().getDbmsName() + '"');
			sb.append("," + '"' + configConnect.getConnectUser() + '"');
			sb.append("," + '"' + configConnect.getPassword() + '"');
			sb.append("," + '"' + configConnect.getHostName() + '"');
			sb.append("," + '"' + configConnect.getPortNumber() + '"');
			sb.append("," + '"' + configConnect.getDatabaseName() + '"');
			sb.append("," + '"' + configConnect.getClassName() + '"');
			sb.append("," + '"' + configConnect.getDriverFile() + '"');
			sb.append("," + '"' + configConnect.getUrlOption() + '"');
			sb.append("," + '"' + configConnect.getLastConnectdate().toString() + '"');
			return sb;
		}

	}

}
