/*
 * Copyright 2012 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.main;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

/**
 * @author sima
 * 
 */
public class FontZoom {

	static public void setMouseWheel(Component component) {
		component.addKeyListener(new MouseWheelControl());
	}

	static private class MouseWheelControl implements KeyListener {

		private boolean press = false;

		@Override
		public void keyPressed(KeyEvent e) {
			if (press) {
				return;
			}

			if (e.getKeyCode() == KeyEvent.VK_CONTROL) {
				e.getComponent().addMouseWheelListener(mouseWheelListener);
				press = true;
			}
		}

		@Override
		public void keyReleased(KeyEvent e) {
			if (e.getKeyCode() == KeyEvent.VK_CONTROL) {
				e.getComponent().removeMouseWheelListener(mouseWheelListener);
				press = false;
			}
		}

		@Override
		public void keyTyped(KeyEvent e) {
			// 押す＆離すで発生するイベントなので使用しない
		}

		private final MouseWheelListener mouseWheelListener = new MouseWheelListener() {

			/*
			 * (非 Javadoc)
			 * 
			 * @see java.awt.event.MouseWheelListener#mouseWheelMoved(java.awt.event. MouseWheelEvent)
			 */
			@Override
			public void mouseWheelMoved(MouseWheelEvent e) {
				if (!e.isControlDown()) {
					return;
				}
				final Component c = e.getComponent();

				final Font font = c.getFont();
				final float size = font.getSize() + (e.getWheelRotation() * -1);

				if (e.getWheelRotation() > 0 && 5f < size) {
					c.setFont(font.deriveFont(size));
				}
				if (e.getWheelRotation() < 0 && size < 29f) {
					c.setFont(font.deriveFont(size));
				}
				e.consume();
			}
		};
	}

}
