/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService;

import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

/**
 * @author sima
 *
 */
public class PropertyResultSetTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 7827100875320667597L;

	private final List<List<String>> col = new ArrayList<List<String>>();

	private final List<ColumnAttributeResult> header;

	public PropertyResultSetTableModel(List<ColumnAttributeResult> header) {
		this.header = header;

		List<String> s = new ArrayList<String>();
		s.add("ColumnName");
		s.add("ColumnLabel");
		s.add("ColumnType");
		s.add("ColumnTypeName");
		s.add("ColumnClassName");
		s.add("ColumnDisplaySize");
		s.add("Precision");
		s.add("Scale");

		s.add("CatalogName");
		s.add("SchemaName");
		s.add("TableName");

		s.add("AutoIncrement");
		s.add("CaseSensitive");
		s.add("Currency");
		s.add("DefinitelyWritable");
		s.add("Nullable");
		s.add("ReadOnly");
		s.add("Searchable");
		s.add("Writable");
		col.add(s);
		for (ColumnAttributeResult columnAttributeResult : header) {
			List<String> row = new ArrayList<String>(s.size());
			row.add(columnAttributeResult.getColumnName());
			row.add(columnAttributeResult.getColumnLabel());
			row.add(columnAttributeResult.getColumnType().toString());
			row.add(columnAttributeResult.getColumnTypeName());
			row.add(columnAttributeResult.getColumnClassName());
			row.add(Integer.toString(columnAttributeResult.getColumnDisplaySize()));
			row.add(Integer.toString(columnAttributeResult.getPrecision()));
			row.add(Integer.toString(columnAttributeResult.getScale()));

			row.add(columnAttributeResult.getCatalogName());
			row.add(columnAttributeResult.getSchemaName());
			row.add(columnAttributeResult.getTableName());

			row.add(Boolean.toString(columnAttributeResult.isAutoIncrement()));
			row.add(Boolean.toString(columnAttributeResult.isCaseSensitive()));
			row.add(Boolean.toString(columnAttributeResult.isCurrency()));
			row.add(Boolean.toString(columnAttributeResult.isDefinitelyWritable()));
			switch (columnAttributeResult.getNullable()) {
			case ResultSetMetaData.columnNoNulls:
				row.add("NoNulls");
				break;
			case ResultSetMetaData.columnNullable:
				row.add("Nullable");
				break;
			case ResultSetMetaData.columnNullableUnknown:
				row.add("NullableUnknown");
				break;
			default:
				row.add("");
				break;
			}
			row.add(Boolean.toString(columnAttributeResult.isReadOnly()));
			row.add(Boolean.toString(columnAttributeResult.isSearchable()));
			row.add(Boolean.toString(columnAttributeResult.isWritable()));

			col.add(row);
		}
	}

	@Override
	public int getColumnCount() {
		return header.size() + 1;
	}

	@Override
	public int getRowCount() {
		return col.get(0).size();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		return col.get(columnIndex).get(rowIndex);
	}

}

