/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService.dbobject;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import jdbcacsess2.sqlService.dbobject.DBObject.Property;

/**
 * @author sima
 *
 */
public class PropertyDBObjectsTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 3293479625219161204L;

	private final List<Property> properties;

	public PropertyDBObjectsTableModel(List<Property> properties) {
		this.properties = properties;
	}

	@Override
	public int getColumnCount() {
		return 2;
	}

	@Override
	public int getRowCount() {
		return properties.size();
	}

	@Override
	public String getColumnName(int column) {
		if (column == 0) {
			return "name";
		} else {
			return "value";
		}
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (columnIndex == 0) {
			return properties.get(rowIndex).getName();
		} else {
			return properties.get(rowIndex).getValue();
		}
	}
}

