/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.oxbow.swingbits.table.filter;

import com.ezware.oxbow.swingbits.table.TableHeaderRenderer;
import com.ezware.oxbow.swingbits.table.filter.ITableFilter;
import com.ezware.oxbow.swingbits.util.CompoundIcon;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

class FilterTableHeaderRenderer
extends TableHeaderRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon icon;
    private final ITableFilter<?> tableFilter;
    private boolean rendererInit = true;
    private int originalHorizontalTextPosition;

    public FilterTableHeaderRenderer(ITableFilter<?> tableFilter) {
        this.tableFilter = tableFilter;
    }

    private Icon getFilterIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(this.getClass().getResource("funnel.png"));
            this.icon = new ImageIcon(this.icon.getImage().getScaledInstance(12, 12, 4));
        }
        return this.icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelColumn;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.rendererInit) {
            this.originalHorizontalTextPosition = label.getHorizontalTextPosition();
            this.rendererInit = false;
        }
        if (this.tableFilter.isFiltered(modelColumn = table.convertColumnIndexToModel(column))) {
            Icon originalIcon = label.getIcon();
            if (originalIcon == null) {
                label.setIcon(this.getFilterIcon());
            } else {
                label.setIcon(new CompoundIcon(this.getFilterIcon(), originalIcon));
            }
            label.setHorizontalTextPosition(11);
        } else {
            label.setHorizontalTextPosition(this.originalHorizontalTextPosition);
        }
        return label;
    }
}

