/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BackgroundStreamDrainer
implements Runnable {
    protected ByteArrayOutputStream data = new ByteArrayOutputStream();
    protected InputStream in;
    protected boolean finished;
    protected IOException ioe;
    protected long startTime;
    protected Thread myThread;
    protected int timeout;

    public BackgroundStreamDrainer(InputStream in, String timemin) {
        this.in = in;
        this.startTime = System.currentTimeMillis();
        if (timemin != null) {
            Integer i = new Integer(timemin);
            this.timeout = i;
        } else {
            this.timeout = 0;
        }
        this.myThread = new Thread((Runnable)this, this.getClass().getName());
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.in == null) {
            System.out.println("The inputstream is null");
            System.exit(1);
        }
        try {
            int valid;
            byte[] ca = new byte[1024];
            while ((valid = this.in.read(ca, 0, ca.length)) != -1) {
                long millis;
                long diff;
                int mins;
                if (this.timeout > 0 && (mins = (int)((diff = (millis = System.currentTimeMillis()) - this.startTime) / 60000L)) > this.timeout) {
                    System.out.println("kill stderr thread...");
                    BackgroundStreamDrainer backgroundStreamDrainer = this;
                    synchronized (backgroundStreamDrainer) {
                        this.finished = true;
                        break;
                    }
                }
                this.data.write(ca, 0, valid);
            }
        }
        catch (IOException ioe) {
            this.ioe = ioe;
            System.out.println(ioe.getMessage());
        }
        BackgroundStreamDrainer backgroundStreamDrainer = this;
        synchronized (backgroundStreamDrainer) {
            this.finished = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getData() throws IOException {
        BackgroundStreamDrainer backgroundStreamDrainer = this;
        synchronized (backgroundStreamDrainer) {
            try {
                while (!this.finished) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                System.out.println("IOException: " + ie);
                throw new IOException(ie.toString());
            }
        }
        return new ByteArrayInputStream(this.data.toByteArray());
    }
}

