/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.derbyTesting.functionTests.harness.GRFileFilter;
import org.apache.derbyTesting.functionTests.harness.PropertyUtil;
import org.apache.derbyTesting.functionTests.harness.SysInfoLog;

public class GenerateReport {
    static final String DASHLINE = "------------------------------------------------------";
    static String passFileName;
    static String failFileName;
    static String diffFileName;
    static String skipFileName;
    static String propFileName;
    static PrintWriter passFile;
    static PrintWriter failFile;
    static PrintWriter diffFile;
    static PrintWriter skipFile;
    static PrintWriter propFile;
    static PrintWriter reportFile;
    static FilenameFilter fileFilter;
    static int NumPass;
    static int NumFail;
    static int NumRun;
    static int NumSkip;
    static int PercentPass;
    static int PercentFail;
    static Timestamp TestStart;
    static Time TestDuration;
    static String SuiteName;

    static void CollectProperties() {
        Properties ps = System.getProperties();
        char[] newline = new char[]{' '};
        propFile.println(PropertyUtil.sortProperties(ps, newline));
    }

    static void CalculateRunLength() {
        String odn = System.getProperty("outputdir");
        if (odn == null) {
            odn = System.getProperty("user.dir");
        }
        BufferedReader sumFile = null;
        String firstLine = null;
        String lastLine = null;
        try {
            sumFile = new BufferedReader(new FileReader(new File(new File(odn), SuiteName + ".sum")));
            String aLine = firstLine = sumFile.readLine();
            while (aLine != null) {
                lastLine = aLine;
                aLine = sumFile.readLine();
            }
            sumFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        int tsStart = 22 + SuiteName.length();
        int tsEnd = firstLine.length() - 8;
        TestStart = Timestamp.valueOf(firstLine.substring(tsStart, tsEnd));
        Timestamp testEnd = Timestamp.valueOf(lastLine.substring(tsStart -= 2, tsEnd -= 2));
        long testLen = testEnd.getTime() - TestStart.getTime();
        int sec = (int)(testLen / 1000L);
        int min = sec / 60;
        int hr = min / 60;
        sec -= min * 60;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, hr);
        cal.set(12, min -= hr * 60);
        cal.set(13, sec);
        TestDuration = new Time(cal.getTime().getTime());
    }

    static void CollectPassFailStats() {
        String odn = System.getProperty("outputdir");
        if (odn == null) {
            odn = System.getProperty("user.dir");
        }
        GenerateReport.CollectPassFailStats(new File(odn), "");
    }

    static void addLines(PrintWriter outFile, File inFile, String relativeName) {
        BufferedReader readFile = null;
        try {
            readFile = new BufferedReader(new FileReader(inFile));
            String aLine = readFile.readLine();
            while (aLine != null) {
                outFile.print(relativeName);
                outFile.print(":");
                outFile.println(aLine);
                aLine = readFile.readLine();
            }
            readFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    static void addDiff(PrintWriter outFile, File inFile, String relativeName) {
        BufferedReader readFile = null;
        try {
            readFile = new BufferedReader(new FileReader(inFile));
            outFile.print("********* Diff file ");
            outFile.println(relativeName);
            String aLine = readFile.readLine();
            while (aLine != null) {
                outFile.println(aLine);
                aLine = readFile.readLine();
            }
            readFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    static void CollectPassFailStats(File dir, String relativeName) {
        String[] fileList = dir.list(fileFilter);
        int l = fileList.length;
        for (int i = 0; i < l; ++i) {
            String fileName = fileList[i];
            File file = new File(dir, fileName);
            if (fileName.endsWith(".pass")) {
                GenerateReport.addLines(passFile, file, relativeName + "/" + fileName);
                continue;
            }
            if (fileName.endsWith(".fail")) {
                GenerateReport.addLines(failFile, file, relativeName + "/" + fileName);
                continue;
            }
            if (fileName.endsWith(".skip")) {
                GenerateReport.addLines(skipFile, file, relativeName + "/" + fileName);
                continue;
            }
            if (fileName.endsWith(".diff")) {
                GenerateReport.addDiff(diffFile, file, relativeName + "/" + fileName);
                continue;
            }
            String newDir = relativeName.length() > 0 ? relativeName + "/" + fileName : fileName;
            GenerateReport.CollectPassFailStats(file, newDir);
        }
    }

    static void CalculatePassFailStats() {
        NumPass = GenerateReport.CountLines(passFileName);
        NumFail = GenerateReport.CountLines(failFileName);
        NumRun = NumPass + NumFail;
        NumSkip = GenerateReport.CountLines(skipFileName);
        PercentPass = (int)Math.floor(100.0 * ((double)NumPass / (double)NumRun));
        PercentFail = (int)Math.ceil(100.0 * ((double)NumFail / (double)NumRun));
    }

    static int CountLines(String fileName) {
        BufferedReader readFile = null;
        int line = 0;
        try {
            readFile = new BufferedReader(new FileReader(fileName));
            String aLine = readFile.readLine();
            while (aLine != null) {
                ++line;
                aLine = readFile.readLine();
            }
            readFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        return line;
    }

    static void OutputFile(String fileName) {
        BufferedReader readFile = null;
        try {
            readFile = new BufferedReader(new FileReader(fileName));
            String aLine = readFile.readLine();
            while (aLine != null) {
                reportFile.println(aLine);
                aLine = readFile.readLine();
            }
            readFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    static PrintWriter setupFile(String fn) {
        File f = null;
        PrintWriter pw = null;
        try {
            f = new File(fn);
            if (f.exists()) {
                System.out.println("WARNING: removing " + fn);
                f.delete();
            }
            pw = new PrintWriter(new FileWriter(fn, true));
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        return pw;
    }

    public static void main(String[] args) {
        SuiteName = args[0];
        String jvmName = args[1];
        String javaCmd = args[2];
        String classpath = args[3];
        String framework = args[4];
        String processexec = args[5];
        boolean useprocess = true;
        if (processexec.toLowerCase().startsWith("false")) {
            useprocess = false;
        }
        String reportFileName = SuiteName + "_report.txt";
        reportFile = GenerateReport.setupFile(reportFileName);
        reportFile.print("Generating report for RunSuite ");
        for (int i = 0; i < args.length; ++i) {
            reportFile.print(args[i] + " ");
        }
        reportFile.println();
        passFileName = SuiteName + "_pass.txt";
        failFileName = SuiteName + "_fail.txt";
        diffFileName = SuiteName + "_diff.txt";
        skipFileName = SuiteName + "_skip.txt";
        propFileName = SuiteName + "_prop.txt";
        passFile = GenerateReport.setupFile(passFileName);
        failFile = GenerateReport.setupFile(failFileName);
        diffFile = GenerateReport.setupFile(diffFileName);
        skipFile = GenerateReport.setupFile(skipFileName);
        propFile = GenerateReport.setupFile(propFileName);
        SysInfoLog sysLog = new SysInfoLog();
        try {
            sysLog.exec(jvmName, javaCmd, classpath, framework, reportFile, useprocess);
        }
        catch (Exception e) {
            System.out.println("SysInfoLog Exception: " + e.getMessage());
        }
        reportFile.println("Test environment information:");
        reportFile.print("COMMAND LINE STYLE: ");
        String jvm2 = System.getProperty("jvm");
        if (jvm2 == null) {
            jvm2 = "jdk13";
        }
        reportFile.println(jvm2);
        reportFile.print("TEST CANONS: ");
        String canondir = System.getProperty("canondir");
        if (canondir == null) {
            canondir = "master";
        }
        reportFile.println(canondir);
        reportFile.println(DASHLINE);
        reportFile.println(DASHLINE);
        reportFile.println("Summary results:");
        GenerateReport.CalculateRunLength();
        GenerateReport.CollectPassFailStats();
        GenerateReport.CollectProperties();
        passFile.close();
        failFile.close();
        skipFile.close();
        diffFile.close();
        propFile.close();
        GenerateReport.CalculatePassFailStats();
        reportFile.println();
        reportFile.println("Test Run Started: " + TestStart);
        reportFile.println("Test Run Duration: " + TestDuration);
        reportFile.println();
        reportFile.println(NumRun + " Tests Run");
        if (PercentPass < 10) {
            reportFile.print(" ");
        }
        reportFile.println(PercentPass + "% Pass (" + NumPass + " tests passed)");
        if (PercentFail < 10) {
            reportFile.print(" ");
        }
        reportFile.println(PercentFail + "% Fail (" + NumFail + " tests failed)");
        reportFile.println(NumSkip + " Suites skipped");
        reportFile.println(DASHLINE);
        if (NumFail > 0) {
            reportFile.println("Failed tests in: " + failFileName);
            reportFile.println(DASHLINE);
        }
        if (NumPass > 0) {
            reportFile.println("Passed tests in: " + passFileName);
            reportFile.println(DASHLINE);
        }
        if (NumSkip > 0) {
            reportFile.println("Skipped suites in: " + skipFileName);
            reportFile.println(DASHLINE);
        }
        reportFile.println("System properties in: " + propFileName);
        reportFile.println(DASHLINE);
        reportFile.println(DASHLINE);
        if (NumFail > 0) {
            reportFile.println("Failure Details:");
            GenerateReport.OutputFile(diffFileName);
        } else {
            reportFile.println("No Failures.");
        }
        reportFile.println(DASHLINE);
        reportFile.close();
        System.out.println("Generated report: " + reportFileName);
    }

    static {
        fileFilter = new GRFileFilter();
    }
}

