/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.util.StringTokenizer;

public class JavaVersionHolder {
    private String majorVersion;
    private String minorVersion;
    private int major;
    private int minor;

    public JavaVersionHolder(String javaVersion) throws NumberFormatException {
        int i = javaVersion.indexOf(46);
        int j = javaVersion.indexOf(46, i + 1);
        this.majorVersion = javaVersion.substring(0, i);
        try {
            Integer imajor = new Integer(this.majorVersion);
            this.major = imajor;
            if (j != -1) {
                this.minorVersion = javaVersion.substring(i + 1, j);
                Integer iminor = new Integer(this.minorVersion);
                this.minor = iminor;
            } else {
                this.minorVersion = javaVersion.substring(i + 1);
                Integer iminor = new Integer(this.minorVersion);
                this.minor = iminor;
            }
        }
        catch (NumberFormatException nfe) {
            if (javaVersion.startsWith("HP")) {
                StringTokenizer st = new StringTokenizer(javaVersion, ".");
                String tmp = st.nextToken();
                this.majorVersion = st.nextToken();
                if (this.majorVersion.equals("01")) {
                    this.majorVersion = "1";
                } else if (this.majorVersion.equals("02")) {
                    this.majorVersion = "2";
                }
                this.minorVersion = st.nextToken();
                if (this.minorVersion.startsWith("1")) {
                    this.minorVersion = "1";
                } else if (this.minorVersion.startsWith("2")) {
                    this.minorVersion = "2";
                }
                try {
                    Integer imajor = new Integer(this.majorVersion);
                    this.major = imajor;
                    Integer iminor = new Integer(this.minorVersion);
                    this.minor = iminor;
                }
                catch (NumberFormatException nfe2) {
                    System.out.println("Could not parse version: " + nfe2);
                }
            }
            System.out.println("NumberFormatException thrown trying to parse the version. " + javaVersion);
            System.out.println("The test harness only handles the HP special case.");
        }
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorNumber() {
        return this.major;
    }

    public int getMinorNumber() {
        return this.minor;
    }

    public boolean atLeast(int baseMajor, int baseMinor) {
        if (this.major < baseMajor) {
            return false;
        }
        if (this.major > baseMajor) {
            return true;
        }
        return this.minor >= baseMinor;
    }
}

