/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OutBufferedStreamTest
extends BaseJDBCTestCase {
    public OutBufferedStreamTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.drda.streamOutBufferSize", "131072");
        Object suite = TestConfiguration.clientServerSuite(OutBufferedStreamTest.class);
        suite = new SystemPropertyTestSetup((Test)suite, properties);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table TEST_TABLE( TEST_COL blob( 65536 ))");
                this.getConnection().commit();
            }
        };
    }

    public void testOutBufferStream() {
        try {
            int j;
            int i;
            PreparedStatement insertLobSt = this.prepareStatement("insert into TEST_TABLE( TEST_COL ) values(?)");
            insertLobSt.setBinaryStream(1, (InputStream)OutBufferedStreamTest.createOriginalDataInputStream(65536), 65536);
            insertLobSt.executeUpdate();
            insertLobSt.close();
            this.commit();
            PreparedStatement st = this.prepareStatement("select TEST_COL from TEST_TABLE");
            ResultSet rs = st.executeQuery();
            rs.next();
            InputStream is = rs.getBinaryStream(1);
            int[][] expected = new int[256][256];
            int[][] actual = new int[256][256];
            for (i = 0; i < 256; ++i) {
                for (j = 0; j < 256; ++j) {
                    expected[i][j] = j;
                }
            }
            for (i = 0; i < 256; ++i) {
                for (j = 0; j < 256; ++j) {
                    actual[i][j] = is.read();
                }
            }
            for (i = 0; i < 256; ++i) {
                for (j = 0; j < 256; ++j) {
                    OutBufferedStreamTest.assertEquals((String)("Not correct: Line " + i + " pos " + j), (int)expected[i][j], (int)actual[i][j]);
                }
            }
            is.close();
            rs.close();
            st.close();
            this.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ByteArrayInputStream createOriginalDataInputStream(int length) {
        byte[] originalValue = new byte[length];
        for (int i = 0; i < originalValue.length; ++i) {
            originalValue[i] = (byte)(i % 256);
        }
        return new ByteArrayInputStream(originalValue);
    }
}

