/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DSCreateShutdownDBTest
extends BaseJDBCTestCase {
    static final String[] ADDITIONAL_DBS = new String[]{"dscreateconatdb1", "dscreateshutdowndb1", "dscreateshutdowndb2", "conflict1", "conflict2", "conflict3", "conflict4", "conflict5", "conflict6", "conflict7"};
    static String DBNotFoundState;

    public DSCreateShutdownDBTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DSCreateShutdownDBTest");
        Test test = TestConfiguration.defaultSuite(DSCreateShutdownDBTest.class);
        suite.addTest(test);
        TestSetup setup = TestConfiguration.singleUseDatabaseDecorator((Test)suite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            setup = TestConfiguration.additionalDatabaseDecorator((Test)setup, "emb" + ADDITIONAL_DBS[i]);
            setup = TestConfiguration.additionalDatabaseDecorator((Test)setup, "srv" + ADDITIONAL_DBS[i]);
        }
        return suite;
    }

    public void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
                    this.removeDatabase("emb" + ADDITIONAL_DBS[i]);
                    this.removeDatabase("srv" + ADDITIONAL_DBS[i]);
                }
                return null;
            }

            void removeDatabase(String dbName) {
                dbName = dbName.replace('/', File.separatorChar);
                String dsh = DSCreateShutdownDBTest.getSystemProperty("derby.system.home");
                if (dsh == null) {
                    Assert.fail((String)"not implemented");
                } else {
                    dbName = dsh + File.separator + dbName;
                }
                this.removeDirectory(dbName);
            }

            void removeDirectory(String path) {
                File dir = new File(path);
                this.removeDir(dir);
            }

            private void removeDir(File dir) {
                if (!dir.exists()) {
                    return;
                }
                String[] list = dir.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(dir, list[i]);
                        if (entry.isDirectory()) {
                            this.removeDir(entry);
                            continue;
                        }
                        entry.delete();
                    }
                }
                dir.delete();
            }
        });
        super.tearDown();
    }

    public void testCreateAndShutdown() throws SQLException {
        DBNotFoundState = DSCreateShutdownDBTest.usingEmbedded() ? "XJ004" : "08004";
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        DSCreateShutdownDBTest.assertUpdateCount(this.createStatement(), 0, "set schema APP");
        this.assertGetNull(dbName);
        this.assertSetAndGet(dbName, "shutdownDatabase", "shutdown");
        this.assertSetAndGet(dbName, "createDatabase", "create");
        this.assertNotSetAndGet(dbName, "shutdownDatabase", "boo");
        this.assertNotSetAndGet(dbName, "createDatabase", "boo");
        this.assertNotSetAndGet(dbName, "shutdownDatabase", "false");
        this.assertNotSetAndGet(dbName, "createDatabase", "false");
        this.assertReset(dbName);
        this.assertCreateUsingConnAttrsOK(this.composeDatabaseName(ADDITIONAL_DBS[0]));
        this.assertShutdownUsingConnAttrsOK(dbName);
        this.getConnection();
        dbName = this.composeDatabaseName(ADDITIONAL_DBS[1]);
        this.assertNoDB(dbName);
        this.assertPositive(dbName);
        dbName = this.composeDatabaseName(ADDITIONAL_DBS[2]);
        this.assertNoDB(dbName);
        this.assertTwiceOK(dbName);
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[3]), "shutdown=true;create=true");
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[4]), "create=true;shutdown=true");
        this.assertConflictedSettersOK(this.composeDatabaseName(ADDITIONAL_DBS[5]));
        this.assertConflictedSetterConnAttrOK();
    }

    protected String composeDatabaseName(String dbName) {
        if (DSCreateShutdownDBTest.usingEmbedded()) {
            return "emb" + dbName;
        }
        return "srv" + dbName;
    }

    protected void assertGetNull(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical(dbName);
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
    }

    protected void assertSetAndGet(String dbName, String propertyString, String setValue) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical(dbName);
        JDBCDataSource.setBeanProperty(ds, propertyString, setValue);
        DSCreateShutdownDBTest.assertEquals((String)setValue, (String)DSCreateShutdownDBTest.getBeanProperty(ds, propertyString).toString());
    }

    protected void assertNotSetAndGet(String dbName, String propertyString, String setValue) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical(dbName);
        JDBCDataSource.setBeanProperty(ds, propertyString, setValue);
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, propertyString));
    }

    protected void assertReset(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical(dbName);
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        DSCreateShutdownDBTest.assertEquals((Object)"create", (Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "boo");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        DSCreateShutdownDBTest.assertEquals((Object)"create", (Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "false");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        DSCreateShutdownDBTest.assertEquals((Object)"create", (Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "createDatabase"));
        try {
            JDBCDataSource.setBeanProperty(ds, "createDatabase", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        DSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "boo");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "false");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        DSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(ds, "shutdownDatabase"));
        try {
            JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getBeanProperty(Object ds, String propertyString) {
        String getterName = DSCreateShutdownDBTest.getGetterName(propertyString);
        Object retObject = null;
        try {
            Method getter = ds.getClass().getMethod(getterName, null);
            retObject = getter.invoke(ds, null);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return retObject;
    }

    private static String getGetterName(String attribute) {
        return "get" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    protected void assertShutdownUsingSetOK(String dbName, boolean connAttr) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        if (connAttr) {
            JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "shutdown=true");
        }
        this.assertDSConnectionFailed("08006", ds);
    }

    protected void assertCreateUsingConnAttrsOK(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "create=true");
        DSCreateShutdownDBTest.assertUpdateCount(ds.getConnection().createStatement(), 0, "set schema APP");
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
        this.assertShutdownUsingSetOK(dbName, false);
    }

    protected void assertShutdownUsingConnAttrsOK(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical(dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "shutdown=true");
        this.assertDSConnectionFailed("08006", ds);
    }

    protected void assertShutdownAndCreateConnAttr(String expectedSQLState, String dbName, String twoPropertyString) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", twoPropertyString);
        this.assertDSConnectionFailed(expectedSQLState, ds);
    }

    protected void assertDSConnectionFailed(String expectedSQLState, DataSource ds) throws SQLException {
        try {
            ds.getConnection();
            DSCreateShutdownDBTest.fail((String)("expected an sqlexception " + expectedSQLState));
        }
        catch (SQLException sqle) {
            DSCreateShutdownDBTest.assertSQLState(expectedSQLState, sqle);
        }
    }

    protected void assertNoDB(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        this.assertDSConnectionFailed(DBNotFoundState, ds);
    }

    protected void assertPositive(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        DSCreateShutdownDBTest.assertUpdateCount(ds.getConnection().createStatement(), 0, "set schema APP");
        JDBCDataSource.clearStringBeanProperty(ds, "CreateDatabase");
        this.assertShutdownUsingSetOK(dbName, false);
    }

    protected void assertTwiceOK(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "create=true");
        DSCreateShutdownDBTest.assertUpdateCount(ds.getConnection().createStatement(), 0, "set schema APP");
        JDBCDataSource.clearStringBeanProperty(ds, "CreateDatabase");
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
        this.assertShutdownUsingSetOK(dbName, true);
    }

    protected void assertConflictedSettersOK(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection();
        }
        catch (SQLException se) {
            DSCreateShutdownDBTest.assertSQLState(DBNotFoundState, se);
        }
    }

    protected void assertConflictedSetterConnAttrOK() throws SQLException {
        this.assertConSetOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[6]), "shutdown=true", "CreateDatabase", "create");
        this.assertConSetOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[7]), "create=true", "ShutdownDatabase", "shutdown");
        this.assertSetConOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[8]), "shutdown=true", "CreateDatabase", "create");
        this.assertSetConOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[9]), "create=true", "ShutdownDatabase", "shutdown");
    }

    protected void assertConSetOK(String expectedSQLState, String dbName, String connAttrValue, String setter, String setValue) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, setter, setValue);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", connAttrValue);
        try {
            ds.getConnection();
        }
        catch (SQLException se) {
            DSCreateShutdownDBTest.assertSQLState(expectedSQLState, se);
        }
        JDBCDataSource.clearStringBeanProperty(ds, setter);
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
    }

    protected void assertSetConOK(String expectedSQLState, String dbName, String connAttrValue, String setter, String setValue) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", connAttrValue);
        JDBCDataSource.setBeanProperty(ds, setter, setValue);
        try {
            ds.getConnection();
        }
        catch (SQLException se) {
            DSCreateShutdownDBTest.assertSQLState(expectedSQLState, se);
        }
        JDBCDataSource.clearStringBeanProperty(ds, "ConnectionAttributes");
        JDBCDataSource.clearStringBeanProperty(ds, setter);
    }
}

