/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.junitTests.compatibility;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.derbyTesting.functionTests.tests.junitTests.compatibility.CompatibilitySuite;
import org.apache.derbyTesting.functionTests.tests.lang.Price;

public class JDBCDriverTest
extends CompatibilitySuite {
    private static final String ALL_TYPES_TABLE = "allTypesTable";
    private static final String KEY_COLUMN = "keyCol";
    private static final byte[] SAMPLE_BYTES = new byte[]{1, 2, 3, 4, 5};
    private static final String SAMPLE_STRING = "hello";
    private static final boolean Y = true;
    private static final boolean _ = false;
    private static final TypeDescriptor[] ALL_TYPES = new TypeDescriptor[]{new TypeDescriptor(-5, "bigint", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(2004, "blob", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(1, "char(5)", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-2, "char(5) for bit data", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(2005, "clob", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(91, "date", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(3, "decimal", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(8, "double", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(8, "double precision", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(7, "float(23)", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(8, "float", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(4, "integer", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-1, "long varchar", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-4, "long varchar for bit data", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(2, "numeric", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(7, "real", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(5, "smallint", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(92, "time", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(93, "timestamp", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(12, "varchar(5)", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-3, "varchar(5) for bit data", IBM_2_4, DRB_10_0, VM_1_3)};
    private static final Object[] ROW_1 = new Object[]{new Long(1L), new MyBlob(SAMPLE_BYTES), "hello", SAMPLE_BYTES, new MyClob("hello"), new Date(1L), new BigDecimal(1.0), new Double(1.0), new Double(1.0), new Float(1.0f), new Double(1.0), new Integer(1), "hello", SAMPLE_BYTES, new BigDecimal(1.0), new Float(1.0f), new Short(1), new Time(1L), new Timestamp(1L), "hello", SAMPLE_BYTES};
    private static final T_CN[] COERCIONS = new T_CN[]{new T_CN(-5, new boolean[]{true, false, true, false, false, false, false, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(2004, new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-2, new boolean[]{false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2005, new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(91, new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(3, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(8, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(4, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(-1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-4, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(5, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(92, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}), new T_CN(93, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}), new T_CN(12, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-3, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true})};
    private static HashMap _types = new HashMap();
    private static HashMap _coercionIndex = new HashMap();

    public void testSanity() {
        JDBCDriverTest.assertEquals((String)"ALL_TYPES.length == ROW_1.length", (int)ALL_TYPES.length, (int)ROW_1.length);
        int coercionCount = COERCIONS.length;
        for (int i = 0; i < coercionCount; ++i) {
            JDBCDriverTest.assertEquals((String)("Coercion " + i), (int)coercionCount, (int)COERCIONS[i].getCoercions().length);
        }
    }

    public void testJDBCDriver() throws Exception {
        Connection conn = JDBCDriverTest.getConnection();
        this.dropSchema(conn);
        this.createSchema(conn);
        this.datatypesTest(conn);
        this.udtTest(conn);
        this.derby_2602_test(conn);
        this.derby_4613_test(conn);
        this.derby_4888_test(conn);
        JDBCDriverTest.close(conn);
    }

    private void derby_4613_test(Connection conn) throws Exception {
        boolean correctBehavior = this.usingEmbeddedClient() || this.getServerVersion().atLeast(DRB_10_7) && this.getDriverVersion().atLeast(DRB_10_7);
        JDBCDriverTest.println("derby_4613_test correctBehavior = " + correctBehavior);
        this.vet_isindex_column(conn, correctBehavior, "SYSTABLES_HEAP", false);
        this.vet_isindex_column(conn, correctBehavior, "SYSTABLES_INDEX1", true);
    }

    private void vet_isindex_column(Connection conn, boolean correctBehavior, String conglomerateName, boolean expectedValue) throws Exception {
        String columnClassName;
        PreparedStatement ps = JDBCDriverTest.prepare(conn, "select isindex from sys.sysconglomerates where conglomeratename = ?");
        ps.setString(1, conglomerateName);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        int jdbcType = correctBehavior ? 16 : 5;
        String typeName = correctBehavior ? "BOOLEAN" : "SMALLINT";
        int precision = correctBehavior ? 1 : 5;
        int scale = 0;
        int columnDisplaySize = correctBehavior ? 5 : 6;
        String string = columnClassName = correctBehavior ? "java.lang.Boolean" : "java.lang.Integer";
        Comparable<Boolean> objectValue = correctBehavior ? (Comparable<Boolean>)new Boolean(expectedValue) : (Comparable<Boolean>)(expectedValue ? new Integer(1) : new Integer(0));
        String stringValue = ((Object)objectValue).toString();
        JDBCDriverTest.assertEquals((int)jdbcType, (int)rsmd.getColumnType(1));
        JDBCDriverTest.assertEquals((String)typeName, (String)rsmd.getColumnTypeName(1));
        JDBCDriverTest.assertEquals((int)precision, (int)rsmd.getPrecision(1));
        JDBCDriverTest.assertEquals((int)scale, (int)rsmd.getScale(1));
        JDBCDriverTest.assertEquals((int)columnDisplaySize, (int)rsmd.getColumnDisplaySize(1));
        JDBCDriverTest.assertEquals((String)columnClassName, (String)rsmd.getColumnClassName(1));
        JDBCDriverTest.assertEquals((boolean)true, (boolean)rs.next());
        JDBCDriverTest.assertEquals((boolean)expectedValue, (boolean)rs.getBoolean(1));
        JDBCDriverTest.assertEquals((Object)objectValue, (Object)rs.getObject(1));
        JDBCDriverTest.assertEquals((String)stringValue, (String)rs.getString(1));
        rs.close();
        ps.close();
    }

    private void derby_2602_test(Connection conn) throws Exception {
        boolean correctBehavior = this.usingEmbeddedClient() || this.getServerVersion().atLeast(DRB_10_6) && this.getDriverVersion().atLeast(DRB_10_6);
        Timestamp ts = Timestamp.valueOf("2004-02-14 17:14:24.976255123");
        PreparedStatement insert = JDBCDriverTest.prepare(conn, "insert into t_2602( a ) values ( ? )");
        insert.setTimestamp(1, ts);
        insert.executeUpdate();
        insert.close();
        PreparedStatement select = JDBCDriverTest.prepare(conn, "select a from t_2602");
        ResultSet selectRS = select.executeQuery();
        selectRS.next();
        Timestamp resultTS = selectRS.getTimestamp(1);
        int resultNanos = resultTS.getNanos();
        int expectedResult = correctBehavior ? 976255123 : 976255000;
        JDBCDriverTest.assertEquals((int)expectedResult, (int)resultNanos);
    }

    private void derby_4888_test(Connection conn) throws SQLException {
        JDBCDriverTest.assertFalse((boolean)conn.getMetaData().storesLowerCaseIdentifiers());
    }

    private void udtTest(Connection conn) throws Exception {
        boolean correctBehavior = this.usingEmbeddedClient() || this.getServerVersion().atLeast(DRB_10_6) && this.getDriverVersion().atLeast(DRB_10_6);
        String query = "select aliasinfo from sys.sysaliases";
        if (correctBehavior) {
            String aliasInfoClassName = "org.apache.derby.catalog.AliasInfo";
            this.checkRSMD(conn, query, aliasInfoClassName, 15, 2000, aliasInfoClassName, 0, 0);
        } else {
            this.checkRSMD(conn, query, "byte[]", 65400, -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
        }
        if (this.serverSupportsUDTs()) {
            ByteArrayInputStream bais;
            byte[] someBytes;
            PreparedStatement ps;
            block16: {
                query = "select a from t_price";
                ps = conn.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                rs.next();
                Object price = rs.getObject(1);
                String actualClassName = price.getClass().getName();
                rs.close();
                ps.close();
                if (correctBehavior) {
                    String priceClassName = "org.apache.derbyTesting.functionTests.tests.lang.Price";
                    this.checkRSMD(conn, query, priceClassName, 15, 2000, "\"APP\".\"PRICE\"", 0, 0);
                    JDBCDriverTest.assertEquals((String)priceClassName, (String)actualClassName);
                } else {
                    this.checkRSMD(conn, query, "byte[]", 65400, -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
                    JDBCDriverTest.assertEquals((String)"java.lang.String", (String)actualClassName);
                }
                query = "insert into t_price( a ) values ( ? )";
                if (correctBehavior) {
                    this.checkPMD(conn, query, "org.apache.derbyTesting.functionTests.tests.lang.Price", 2000, "\"APP\".\"PRICE\"", 0, 0);
                } else {
                    this.checkPMD(conn, query, "byte[]", -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
                }
                ps = conn.prepareStatement(query);
                someBytes = new byte[]{1, 2, 3};
                bais = new ByteArrayInputStream(someBytes);
                try {
                    ps.setObject(1, Price.makePrice());
                    ps.executeUpdate();
                    if (!correctBehavior) {
                        JDBCDriverTest.fail((String)"setObject( Price ) unexpectedly worked.");
                    }
                }
                catch (SQLException se) {
                    if (!correctBehavior) break block16;
                    JDBCDriverTest.fail((String)"setObject( Price ) unexpectedly failed.");
                }
            }
            try {
                ps.setObject(1, someBytes);
                ps.executeUpdate();
                JDBCDriverTest.fail((String)"setObject( byte[] ) unexpectedly worked.");
            }
            catch (SQLException se) {
                // empty catch block
            }
            try {
                ps.setBytes(1, someBytes);
                ps.executeUpdate();
                JDBCDriverTest.fail((String)"setBytes( byte[] ) unexpectedly worked.");
            }
            catch (SQLException se) {
                // empty catch block
            }
            try {
                ps.setBinaryStream(1, (InputStream)bais, 3);
                ps.executeUpdate();
                JDBCDriverTest.fail((String)"setBinaryStream( InputStream ) unexpectedly worked.");
            }
            catch (SQLException se) {
                // empty catch block
            }
            ps.close();
        }
    }

    private void checkRSMD(Connection conn, String query, String expectedClassName, int expectedDisplaySize, int expectedJDBCType, String expectedSQLTypeName, int expectedPrecision, int expectedScale) throws Exception {
        PreparedStatement ps = conn.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDriverTest.assertEquals((String)expectedClassName, (String)rsmd.getColumnClassName(1));
        JDBCDriverTest.assertEquals((int)expectedDisplaySize, (int)rsmd.getColumnDisplaySize(1));
        JDBCDriverTest.assertEquals((int)expectedJDBCType, (int)rsmd.getColumnType(1));
        JDBCDriverTest.assertEquals((String)expectedSQLTypeName, (String)rsmd.getColumnTypeName(1));
        JDBCDriverTest.assertEquals((int)expectedPrecision, (int)rsmd.getPrecision(1));
        JDBCDriverTest.assertEquals((int)expectedScale, (int)rsmd.getScale(1));
        rs.close();
        ps.close();
    }

    private void checkPMD(Connection conn, String query, String expectedClassName, int expectedJDBCType, String expectedSQLTypeName, int expectedPrecision, int expectedScale) throws Exception {
        PreparedStatement ps = conn.prepareStatement(query);
        ParameterMetaData pmd = ps.getParameterMetaData();
        JDBCDriverTest.assertEquals((String)pmd.getParameterClassName(1), (String)expectedClassName);
        JDBCDriverTest.assertEquals((int)pmd.getParameterType(1), (int)expectedJDBCType);
        JDBCDriverTest.assertEquals((String)pmd.getParameterTypeName(1), (String)expectedSQLTypeName);
        JDBCDriverTest.assertEquals((int)pmd.getPrecision(1), (int)expectedPrecision);
        JDBCDriverTest.assertEquals((int)pmd.getScale(1), (int)expectedScale);
        ps.close();
    }

    private void datatypesTest(Connection conn) throws Exception {
        TypeDescriptor[] types = ALL_TYPES;
        String tableName = ALL_TYPES_TABLE;
        Object[][] rows = new Object[][]{this.makeNullRow(types.length), ROW_1};
        this.checkDBMetadata(conn, tableName);
        this.stuffTable(conn, tableName, types, rows);
        this.readTable(conn, tableName, types, rows, null);
    }

    private void checkDBMetadata(Connection conn, String tableName) throws Exception {
        String normalizedSchema = "APP".toUpperCase();
        String normalizedTable = tableName.toUpperCase();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, normalizedSchema, normalizedTable, "%");
        JDBCDriverTest.println("Pawing through database metadata for " + normalizedSchema + '.' + normalizedTable);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            int actualJdbcType = rs.getInt("DATA_TYPE");
            TypeDescriptor typeDesc = this.getType(columnName);
            if (columnName.equals(KEY_COLUMN)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[ ");
            buffer.append(rs.getString("COLUMN_NAME"));
            buffer.append(",\t");
            buffer.append("type( " + rs.getInt("DATA_TYPE") + " ),\t");
            buffer.append(rs.getString("TYPE_NAME"));
            buffer.append(" ]");
            JDBCDriverTest.println(buffer.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)this.ddmdTypeKludge(typeDesc.getJdbcType()), (int)actualJdbcType);
        }
        JDBCDriverTest.close(rs);
    }

    private void checkProcMetadata(Connection conn, String procName, TypeDescriptor[] signature) throws Exception {
        String normalizedSchema = "APP".toUpperCase();
        String normalizedProc = procName.toUpperCase();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getProcedureColumns(null, normalizedSchema, normalizedProc, "%");
        JDBCDriverTest.println("Pawing through database metadata for " + normalizedSchema + '.' + normalizedProc);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            int actualJdbcType = rs.getInt("DATA_TYPE");
            TypeDescriptor typeDesc = this.getType(signature, columnName);
            if (columnName.equals(KEY_COLUMN)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[ ");
            buffer.append(rs.getString("COLUMN_NAME"));
            buffer.append(",\t");
            buffer.append("type( " + rs.getInt("DATA_TYPE") + " ),\t");
            buffer.append(rs.getString("TYPE_NAME"));
            buffer.append(" ]");
            JDBCDriverTest.println(buffer.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)this.ddmdTypeKludge(typeDesc.getJdbcType()), (int)actualJdbcType);
        }
        JDBCDriverTest.close(rs);
    }

    private void stuffTable(Connection conn, String tableName, TypeDescriptor[] types, Object[][] rows) throws Exception {
        PreparedStatement ps = this.makeInsert(conn, tableName, types);
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            this.setRow(ps, i + 1, types, rows[i]);
        }
        JDBCDriverTest.close(ps);
    }

    private PreparedStatement makeInsert(Connection conn, String tableName, TypeDescriptor[] types) throws Exception {
        StringBuffer masterBuffer = new StringBuffer();
        StringBuffer columnBuffer = new StringBuffer();
        StringBuffer valuesBuffer = new StringBuffer();
        int columnNumber = 0;
        int valuesNumber = 0;
        int typeCount = types.length;
        this.beginColumnList(columnBuffer);
        this.beginColumnList(valuesBuffer);
        this.addColumn(columnBuffer, columnNumber++, this.doubleQuote(KEY_COLUMN));
        this.addColumn(valuesBuffer, valuesNumber++, "?");
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = this.doubleQuote(typeName);
            this.addColumn(columnBuffer, columnNumber++, columnDesc);
            this.addColumn(valuesBuffer, valuesNumber++, "?");
        }
        this.endColumnList(columnBuffer);
        this.endColumnList(valuesBuffer);
        masterBuffer.append("insert into " + tableName + "\n");
        masterBuffer.append(columnBuffer.toString());
        masterBuffer.append("values\n");
        masterBuffer.append(valuesBuffer.toString());
        PreparedStatement ps = JDBCDriverTest.prepare(conn, masterBuffer.toString());
        return ps;
    }

    private void readTable(Connection conn, String tableName, TypeDescriptor[] types, Object[][] rows, List casts) throws Exception {
        PreparedStatement ps = this.readTableQuery(conn, tableName, types);
        ResultSet rs = ps.executeQuery();
        this.checkRSMD(rs);
        JDBCDriverTest.close(rs);
        this.checkRows(ps, types, rows, casts);
        JDBCDriverTest.close(ps);
    }

    private PreparedStatement readTableQuery(Connection conn, String tableName, TypeDescriptor[] types) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int columnNumber = 0;
        int typeCount = types.length;
        buffer.append("select \n");
        this.addColumn(buffer, columnNumber++, this.doubleQuote(KEY_COLUMN));
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = this.doubleQuote(typeName);
            this.addColumn(buffer, columnNumber++, columnDesc);
        }
        buffer.append("\nfrom " + tableName + "\n");
        buffer.append("order by " + this.doubleQuote(KEY_COLUMN));
        PreparedStatement ps = JDBCDriverTest.prepare(conn, buffer.toString());
        return ps;
    }

    private void checkRSMD(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int firstTastyColumn = 0;
        JDBCDriverTest.println("ResultSetMetaData:\n");
        for (int i = ++firstTastyColumn; i < columnCount; ++i) {
            StringBuffer buffer = new StringBuffer();
            int columnID = i + 1;
            String columnName = rsmd.getColumnName(columnID);
            TypeDescriptor typeDesc = this.getType(columnName);
            int expectedType = this.rsmdTypeKludge(typeDesc.getJdbcType());
            int actualType = rsmd.getColumnType(columnID);
            buffer.append("[ ");
            buffer.append(columnName);
            buffer.append(", type( ");
            buffer.append(actualType);
            buffer.append(" ), ");
            buffer.append(rsmd.getColumnTypeName(columnID));
            buffer.append(" ]\n");
            JDBCDriverTest.println(buffer.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)expectedType, (int)actualType);
        }
    }

    private void checkRows(PreparedStatement ps, TypeDescriptor[] types, Object[][] rows, List casts) throws Exception {
        int typeCount = types.length;
        for (int colIndex = 0; colIndex < typeCount; ++colIndex) {
            TypeDescriptor type = types[colIndex];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            JDBCDriverTest.assertEquals((Object)types[colIndex], (Object)type);
            this.checkPlainGet(ps, colIndex, type, rows);
            this.checkCoercions(ps, type, casts);
        }
    }

    private void checkPlainGet(PreparedStatement ps, int columnIndex, TypeDescriptor type, Object[][] rows) throws Exception {
        String columnName = type.getDerbyTypeName();
        ResultSet rs = ps.executeQuery();
        for (int rowId = 0; rowId < rows.length; ++rowId) {
            JDBCDriverTest.assertTrue((String)"Not enough rows in the result", (boolean)rs.next());
            Object expectedValue = rows[rowId][columnIndex];
            Object actualValue = this.getColumn(rs, columnName, type);
            JDBCDriverTest.println("Comparing column " + columnName + ": " + expectedValue + " to " + actualValue);
            this.compareObjects(columnName, expectedValue, actualValue);
        }
        JDBCDriverTest.assertFalse((String)"Remaining rows in result", (boolean)rs.next());
        rs.close();
    }

    private void checkCoercions(PreparedStatement ps, TypeDescriptor type, List casts) throws Exception {
        String columnName = type.getDerbyTypeName();
        T_CN coercionDesc = COERCIONS[this.getCoercionIndex(type.getJdbcType())];
        boolean[] coercions = coercionDesc.getCoercions();
        int count = coercions.length;
        int legalCoercions = 0;
        JDBCDriverTest.println("Checking coercions for " + columnName);
        for (int i = 0; i < count; ++i) {
            if (!coercions[i]) continue;
            ++legalCoercions;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int jdbcType = COERCIONS[i].getJdbcType();
                Object retval = this.getColumn(rs, columnName, jdbcType);
                if (casts != null) {
                    casts.add(retval);
                }
                JDBCDriverTest.println("\t" + jdbcType + ":\t" + retval);
            }
            rs.close();
        }
        JDBCDriverTest.println(legalCoercions + " legal coercions for " + columnName + " (" + "type=" + type.getDerbyTypeName() + ")");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Object objval = rs.getObject(columnName);
            if (objval == null) {
                JDBCDriverTest.println("\tgetObject() = null");
                continue;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("\tgetObject() = ");
            buffer.append(objval.getClass().getName());
            buffer.append("( ");
            buffer.append(objval);
            buffer.append(" )");
            JDBCDriverTest.println(buffer.toString());
        }
        rs.close();
    }

    private int rsmdTypeKludge(int originalJDbcType) {
        if (this.usingEmbeddedClient() && JDBCDriverTest.getServerVMVersion().atLeast(VM_1_4)) {
            return originalJDbcType;
        }
        switch (originalJDbcType) {
            case 2: {
                if (this.usingEmbeddedClient()) {
                    return originalJDbcType;
                }
                return 3;
            }
        }
        return originalJDbcType;
    }

    private int ddmdTypeKludge(int originalJDbcType) {
        switch (originalJDbcType) {
            case 16: {
                if (JDBCDriverTest.getServerVMVersion().atLeast(VM_1_4)) {
                    return originalJDbcType;
                }
                return -7;
            }
        }
        return originalJDbcType;
    }

    private void setRow(PreparedStatement ps, int keyValue, TypeDescriptor[] types, Object[] row) throws Exception {
        int param = 1;
        int typeCount = types.length;
        ps.setInt(param++, keyValue);
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            Object value = row[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            this.setParameter(ps, param++, type, value);
        }
        ps.execute();
    }

    private Object[] makeNullRow(int rowLength) {
        return new Object[rowLength];
    }

    private void buildTypeMap() {
        int typeCount = ALL_TYPES.length;
        for (int i = 0; i < typeCount; ++i) {
            this.putType(ALL_TYPES[i]);
        }
    }

    private void putType(TypeDescriptor type) {
        _types.put(type.getDerbyTypeName(), type);
    }

    private TypeDescriptor getType(String typeName) {
        if (_types.size() == 0) {
            this.buildTypeMap();
        }
        return (TypeDescriptor)_types.get(typeName);
    }

    private TypeDescriptor getType(TypeDescriptor[] types, String typeName) {
        int count = types.length;
        for (int i = 0; i < count; ++i) {
            TypeDescriptor type = types[i];
            if (!type.getDerbyTypeName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    private void buildCoercionMap() {
        int count = COERCIONS.length;
        for (int i = 0; i < count; ++i) {
            this.putCoercionIndex(i);
        }
    }

    private void putCoercionIndex(int index) {
        _coercionIndex.put(new Integer(COERCIONS[index].getJdbcType()), new Integer(index));
    }

    private int getCoercionIndex(int jdbcType) {
        if (_coercionIndex.size() == 0) {
            this.buildCoercionMap();
        }
        return (Integer)_coercionIndex.get(new Integer(jdbcType));
    }

    private void createSchema(Connection conn) throws Exception {
        this.createTable(conn, ALL_TYPES_TABLE, ALL_TYPES);
        this.createUDTObjects(conn);
        this.create_derby_2602_objects(conn);
    }

    private void createTable(Connection conn, String tableName, TypeDescriptor[] types) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int columnNumber = 0;
        int typeCount = types.length;
        buffer.append("create table " + tableName + "\n");
        this.beginColumnList(buffer);
        this.addColumn(buffer, columnNumber++, this.doubleQuote(KEY_COLUMN) + "\tint");
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = this.doubleQuote(typeName) + '\t' + typeName;
            this.addColumn(buffer, columnNumber++, columnDesc);
        }
        this.endColumnList(buffer);
        PreparedStatement ps = JDBCDriverTest.prepare(conn, buffer.toString());
        ps.execute();
        JDBCDriverTest.close(ps);
    }

    private void createUDTObjects(Connection conn) throws Exception {
        if (!this.serverSupportsUDTs()) {
            return;
        }
        PreparedStatement ps = conn.prepareStatement("create type price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        ps.execute();
        ps.close();
        ps = conn.prepareStatement("create function makePrice( ) returns price language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        ps.execute();
        ps.close();
        ps = conn.prepareStatement("create table t_price( a price )\n");
        ps.execute();
        ps.close();
        ps = conn.prepareStatement("insert into t_price( a ) values ( makePrice() )\n");
        ps.execute();
        ps.close();
    }

    private void create_derby_2602_objects(Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("create table t_2602( a timestamp )\n");
        ps.execute();
        ps.close();
    }

    private void beginColumnList(StringBuffer buffer) {
        buffer.append("(\n");
    }

    private void endColumnList(StringBuffer buffer) {
        buffer.append("\n)\n");
    }

    private void addColumn(StringBuffer buffer, int columnNumber, String text) {
        if (columnNumber > 0) {
            buffer.append(",");
        }
        buffer.append("\n\t");
        buffer.append(text);
    }

    private void dropSchema(Connection conn) {
        JDBCDriverTest.dropTable(conn, ALL_TYPES_TABLE);
        this.dropUDTObjects(conn);
        this.drop_derby_2602_objects(conn);
    }

    private void dropUDTObjects(Connection conn) {
        if (!this.serverSupportsUDTs()) {
            return;
        }
        JDBCDriverTest.dropFunction(conn, "MAKEPRICE");
        JDBCDriverTest.dropTable(conn, "T_PRICE");
        JDBCDriverTest.dropUDT(conn, "PRICE");
    }

    private void drop_derby_2602_objects(Connection conn) {
        JDBCDriverTest.dropTable(conn, "T_2602");
    }

    private void setParameter(PreparedStatement ps, int param, TypeDescriptor type, Object value) throws Exception {
        int jdbcType = type.getJdbcType();
        if (value != null) {
            this.setParameter(ps, param, jdbcType, value);
            return;
        }
        if (this.clientSupports(type)) {
            ps.setNull(param, jdbcType);
            return;
        }
        JDBCDriverTest.fail((String)("Unsupported Derby type: " + type.getDerbyTypeName()));
    }

    private boolean clientSupports(TypeDescriptor type) {
        CompatibilitySuite.Version firstSupportedVersion = this.usingDB2Client() ? type.getDb2jccVersion() : type.getDerbyVersion();
        if (firstSupportedVersion == null) {
            return false;
        }
        return this.getDriverVersion().atLeast(firstSupportedVersion);
    }

    private Object getColumn(ResultSet rs, String columnName, TypeDescriptor type) throws Exception {
        int jdbcType = type.getJdbcType();
        return this.getColumn(rs, columnName, jdbcType);
    }

    private String doubleQuote(String text) {
        return '\"' + text + '\"';
    }

    public static final class MyClob
    implements Clob {
        private String _contents;

        public MyClob(String contents) {
            this._contents = contents;
        }

        public InputStream getAsciiStream() {
            try {
                return new ByteArrayInputStream(this._contents.getBytes("UTF-8"));
            }
            catch (Exception e) {
                return null;
            }
        }

        public Reader getCharacterStream() {
            return new CharArrayReader(this._contents.toCharArray());
        }

        public String getSubString(long position, int length) {
            return this._contents.substring((int)position, length);
        }

        public long length() {
            return this._contents.length();
        }

        public long position(Clob searchstr, long start) {
            return 0L;
        }

        public long position(String searchstr, long start) {
            return 0L;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Clob)) {
                return false;
            }
            Clob that = (Clob)other;
            try {
                int nextByte;
                if (this.length() != that.length()) {
                    return false;
                }
                InputStream thisStream = this.getAsciiStream();
                InputStream thatStream = that.getAsciiStream();
                while ((nextByte = thisStream.read()) >= 0) {
                    if (nextByte == thatStream.read()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public int setString(long arg0, String arg1) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public int setString(long arg0, String arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public OutputStream setAsciiStream(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public Writer setCharacterStream(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public void truncate(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }
    }

    public static final class MyBlob
    implements Blob {
        private byte[] _bytes;

        public MyBlob(byte[] bytes) {
            this._bytes = bytes;
        }

        public InputStream getBinaryStream() {
            return new ByteArrayInputStream(this._bytes);
        }

        public byte[] getBytes(long position, int length) {
            return this._bytes;
        }

        public long length() {
            return this._bytes.length;
        }

        public long position(Blob pattern, long start) {
            return 0L;
        }

        public long position(byte[] pattern, long start) {
            return 0L;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Blob)) {
                return false;
            }
            Blob that = (Blob)other;
            try {
                int nextByte;
                if (this.length() != that.length()) {
                    return false;
                }
                InputStream thisStream = this.getBinaryStream();
                InputStream thatStream = that.getBinaryStream();
                while ((nextByte = thisStream.read()) >= 0) {
                    if (nextByte == thatStream.read()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public int setBytes(long arg0, byte[] arg1) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public OutputStream setBinaryStream(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public void truncate(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }
    }

    public static final class T_CN {
        private int _jdbcType;
        private boolean[] _coercions;

        public T_CN(int jdbcType, boolean[] coercions) {
            this._jdbcType = jdbcType;
            this._coercions = coercions;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public boolean[] getCoercions() {
            return this._coercions;
        }
    }

    public static final class TypeDescriptor {
        private int _jdbcType;
        private String _derbyTypeName;
        private CompatibilitySuite.Version _db2jccVersion;
        private CompatibilitySuite.Version _derbyVersion;
        private CompatibilitySuite.Version _vmVersion;

        public TypeDescriptor(int jdbcType, String derbyTypeName, CompatibilitySuite.Version db2jccVersion, CompatibilitySuite.Version derbyVersion, CompatibilitySuite.Version vmVersion) {
            this._jdbcType = jdbcType;
            this._derbyTypeName = derbyTypeName;
            this._db2jccVersion = db2jccVersion;
            this._derbyVersion = derbyVersion;
            this._vmVersion = vmVersion;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public String getDerbyTypeName() {
            return this._derbyTypeName;
        }

        public CompatibilitySuite.Version getDb2jccVersion() {
            return this._db2jccVersion;
        }

        public CompatibilitySuite.Version getDerbyVersion() {
            return this._derbyVersion;
        }

        public CompatibilitySuite.Version getVMVersion() {
            return this._vmVersion;
        }
    }
}

