/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CursorTest
extends BaseJDBCTestCase {
    public CursorTest(String name) {
        super(name);
    }

    public void testCursor() throws SQLException {
        PreparedStatement select = this.prepareStatement("select i, c from t for update");
        ResultSet cursor = select.executeQuery();
        cursor.next();
        CursorTest.assertEquals((int)1956, (int)cursor.getInt(1));
        CursorTest.assertEquals((String)"hello world", (String)cursor.getString(2).trim());
        cursor.close();
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertNextError("XCL16", cursor);
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertNextError("XCL16", cursor);
        }
        cursor = select.executeQuery();
        while (cursor.next()) {
        }
        cursor.next();
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertGetIntError(1, "24000", cursor);
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertGetIntError(1, "XJ121", cursor);
        }
        cursor.close();
    }

    public void testCursorParam() throws SQLException {
        PreparedStatement select = this.prepareStatement("select i, c from t where ?=1 for update");
        select.setInt(1, 1);
        ResultSet cursor = select.executeQuery();
        CursorTest.assertTrue((String)"FAIL: unable to fetch row.", (boolean)cursor.next());
        CursorTest.assertEquals((String)"FAIL: Wrong row on fetch with param", (int)1956, (int)cursor.getInt(1));
        cursor.close();
        CursorTest.assertNextError("XCL16", cursor);
        select.setBoolean(1, false);
        select.setCursorName("ForCoverageSake");
        cursor = select.executeQuery();
        CursorTest.assertEquals((String)"ForCoverageSake", (String)cursor.getCursorName());
        cursor.next();
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertGetIntError(1, "24000", cursor);
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertGetIntError(1, "XJ121", cursor);
        }
        cursor.close();
    }

    public void testGetCursorName() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select * from t");
        if (CursorTest.usingEmbedded()) {
            CursorTest.assertNull((Object)rs.getCursorName());
        } else if (CursorTest.usingDerbyNetClient()) {
            CursorTest.assertNotNull((Object)rs.getCursorName());
        }
        rs.close();
        rs = s.executeQuery("select * from t for update");
        CursorTest.assertNotNull((Object)rs.getCursorName());
        rs.close();
        rs = s.executeQuery("select * from t for update of i");
        CursorTest.assertNotNull((Object)rs.getCursorName());
        rs.close();
        s.setCursorName("myselect");
        rs = s.executeQuery("select * from t");
        CursorTest.assertEquals((String)"myselect", (String)rs.getCursorName());
        rs.close();
        s.setCursorName("myselect2");
        rs = s.executeQuery("select * from t for update");
        CursorTest.assertEquals((String)"myselect2", (String)rs.getCursorName());
        rs.close();
        s.setCursorName("myselect3");
        rs = s.executeQuery("select * from t for update of i");
        CursorTest.assertEquals((String)"myselect3", (String)rs.getCursorName());
        rs.close();
        s.close();
    }

    public void derby2417testSetCursorNextExecute() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select * from t for update");
        s.setCursorName("AFTER_EXECUTE");
        CursorTest.assertFalse((boolean)"AFTER_EXECUTE".equals(rs.getCursorName()));
        rs.close();
        rs = s.executeQuery("select * from t");
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)rs.getCursorName());
        s.setCursorName("CHANGE_AGAIN");
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)rs.getCursorName());
        rs.close();
        rs = s.executeQuery("select * from t");
        CursorTest.assertEquals((String)"CHANGE_AGAIN", (String)rs.getCursorName());
        s.close();
        PreparedStatement ps = this.prepareStatement("select * from t for update");
        rs = ps.executeQuery();
        ps.setCursorName("AFTER_EXECUTE");
        CursorTest.assertFalse((boolean)"AFTER_EXECUTE".equals(rs.getCursorName()));
        rs.close();
        rs = ps.executeQuery();
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)rs.getCursorName());
        ps.setCursorName("CHANGE_AGAIN");
        CursorTest.assertEquals((String)"AFTER_EXECUTE", (String)rs.getCursorName());
        rs.close();
        rs = ps.executeQuery();
        CursorTest.assertEquals((String)"CHANGE_AGAIN", (String)rs.getCursorName());
        ps.close();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("CursorTest");
        suite.addTest(TestConfiguration.defaultSuite(CursorTest.class));
        suite.addTest((Test)new CursorTest("derby2417testSetCursorNextExecute"));
        return suite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t (i int, c char(50))");
        stmt.executeUpdate("create table s (i int, c char(50))");
        stmt.executeUpdate("insert into t values (1956, 'hello world')");
        stmt.executeUpdate("insert into t values (456, 'hi yourself')");
        stmt.executeUpdate("insert into t values (180, 'rubber ducky')");
        stmt.executeUpdate("insert into t values (3, 'you are the one')");
        stmt.close();
        this.commit();
    }

    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        this.rollback();
        stmt.executeUpdate("drop table t");
        stmt.executeUpdate("drop table s");
        stmt.close();
        this.commit();
        super.tearDown();
    }
}

