/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RenameIndexTest
extends BaseJDBCTestCase {
    public RenameIndexTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(RenameIndexTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRenameNonExistingIndex() throws SQLException {
        Statement s = this.createStatement();
        RenameIndexTest.assertStatementError("42X65", s, "rename index i1t1 to i1rt1");
    }

    public void testExistingIndexName() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int, c12 int)");
        s.executeUpdate("create index i1t1 on t1(c11)");
        s.executeUpdate("create index i2t1 on t1(c12)");
        RenameIndexTest.assertStatementError("X0Y32", s, "rename index i1t1 to i2t1");
        s.executeUpdate("drop table t1");
    }

    public void testRenameSystemTableIndex() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("set schema sys");
        RenameIndexTest.assertStatementError("X0Y56", s, "rename index syscolumns_index1 to newName");
        s.executeUpdate("set schema app");
    }

    public void testRenameIndexOfView() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int, c12 int)");
        s.executeUpdate("create index t1i1 on t1(c11)");
        s.executeUpdate("create view v1 as select * from t1");
        ResultSet rs = s.executeQuery("select count(*) from v1");
        JDBC.assertSingleValueResultSet(rs, "0");
        RenameIndexTest.assertUpdateCount(s, 0, "rename index t1i1 to t1i1r");
        rs = s.executeQuery("select count(*) from v1");
        JDBC.assertSingleValueResultSet(rs, "0");
        s.executeUpdate("drop view v1");
        s.executeUpdate("drop table t1");
    }

    public void testDuplicateIndexWithViews() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int not null primary key, c12 int)");
        s.executeUpdate("create index i1t1 on t1(c11)");
        s.executeUpdate("create view v1 as select * from t1");
        RenameIndexTest.assertStatementError("42X65", s, "rename index i1t1 to i1rt1");
        RenameIndexTest.assertUpdateCount(s, 0, "drop view v1");
        RenameIndexTest.assertUpdateCount(s, 0, "create view v1 as select * from t1");
        ResultSet rs = s.executeQuery("select count(*) from v1");
        JDBC.assertSingleValueResultSet(rs, "0");
        RenameIndexTest.assertStatementError("42X65", s, "rename index i1rt1 to i1t1");
        s.executeUpdate("drop view v1");
        s.executeUpdate("drop table t1");
    }

    public void testRenameIndexWithOpenCursor() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.executeUpdate("create table t1(c11 int , c12 int)");
        s.executeUpdate("create index i1 on t1(c11)");
        s.executeUpdate("insert into t1 values(2 , 3)");
        s.executeUpdate("insert into t1 values(3 , 4)");
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        RenameIndexTest.assertStatementError("X0X95", this.createStatement(), "rename index i1 to i1r");
        rs.close();
        RenameIndexTest.assertUpdateCount(s, 0, "rename index i1 to i1r");
        s.executeUpdate("drop table t1");
    }

    public void testWithPreparedStatement() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int not null primary key, c12 int)");
        s.executeUpdate("create index i1 on t1(c11)");
        PreparedStatement pstmt = this.prepareStatement("select * from t1 where c11 > ?");
        pstmt.setInt(1, 1);
        ResultSet rs = pstmt.executeQuery();
        rs.next();
        rs.close();
        RenameIndexTest.assertStatementError("42X65", s, "rename index i1 to i1r");
        pstmt.setInt(1, 1);
        rs = pstmt.executeQuery();
        rs.next();
        rs.close();
        pstmt.close();
        s.executeUpdate("drop table t1");
    }

    public void testRenameColumnWithIndex() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t3(c31 int not null primary key, c32 int)");
        s.executeUpdate("create index i1_t3 on t3(c32)");
        s.executeUpdate("rename index i1_t3 to i1_3r");
        RenameIndexTest.assertStatementError("42X65", s, "rename index i1_t3 to i1_3r");
        s.executeUpdate("drop table t3");
    }

    public void testDuplicateIndexWithPreparedStatement() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t3(c31 int not null primary key, c32 int)");
        s.executeUpdate("create index i1_t3 on t3(c32)");
        PreparedStatement pstmt = this.prepareStatement("select * from t3 where c31 > ?");
        pstmt.setInt(1, 1);
        ResultSet rs = pstmt.executeQuery();
        rs.close();
        RenameIndexTest.assertUpdateCount(s, 0, "rename index i1_t3 to i1_t3r");
        pstmt.setInt(1, 1);
        rs = pstmt.executeQuery();
        rs.close();
        RenameIndexTest.assertUpdateCount(s, 0, "rename index i1_t3r to i1_t3");
        pstmt.close();
        s.executeUpdate("drop table t3");
    }
}

