/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;

class Utils {
    boolean printDebug = false;
    private static final String FS = File.separator;

    Utils() {
    }

    void copyDir(String sourcePath, String destPath) throws IOException {
        this.DEBUG("copyDir from " + sourcePath + " to " + destPath);
        this.copyFiles(sourcePath, destPath);
    }

    void copyFiles(String srcPath, String destPath) throws IOException {
        File src = new File(srcPath);
        File dest = new File(destPath);
        if (src.isDirectory()) {
            this.DEBUG("Make dir: " + dest.getAbsolutePath());
            dest.mkdirs();
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String srcFile = src.getAbsolutePath() + FS + list[i];
                String destFile = dest.getAbsolutePath() + FS + list[i];
                this.copyFiles(srcFile, destFile);
            }
        } else {
            this.copy(src, dest);
        }
    }

    private void copy(File source, File dest) throws IOException {
        int c;
        FileInputStream src = new FileInputStream(source);
        FileOutputStream dst = new FileOutputStream(dest);
        while ((c = src.read()) >= 0) {
            dst.write(c);
        }
        src.close();
        dst.close();
    }

    private void NIOcopy(File source, File dest) throws IOException {
        FileChannel sourceCh = new FileInputStream(source).getChannel();
        FileChannel targetCh = new FileOutputStream(dest).getChannel();
        sourceCh.transferTo(0L, sourceCh.size(), targetCh);
        sourceCh.close();
        targetCh.close();
    }

    void writeToFile(String text, String outFile) throws IOException {
        this.DEBUG("writeToFile " + outFile);
        FileWriter out = new FileWriter(outFile);
        out.write(text);
        out.close();
    }

    void mkDirs(String dirPath) {
        File dir = new File(dirPath);
        dir.mkdirs();
    }

    void DEBUG(String s) {
        if (this.printDebug) {
            System.out.println(s);
        }
    }

    void DEBUG(String s, PrintWriter out) {
        if (this.printDebug) {
            out.println(s);
        }
    }

    void sleep(long sleepTime, String ID) throws InterruptedException {
        this.DEBUG(ID + ": sleep " + sleepTime + "ms.");
        Thread.sleep(sleepTime);
    }
}

