/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_6
extends UpgradeChange {
    private static final String BAD_SYNTAX = "42X01";
    private static final String TABLE_DOES_NOT_EXIST = "42X05";
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String QUERY_4215 = "select r.grantor\nfrom sys.sysroutineperms r, sys.sysaliases a\nwhere r.aliasid = a.aliasid\nand a.alias = 'SYSCS_INPLACE_COMPRESS_TABLE'\n";
    private static final String CREATE_TYPE_DDL = "create type fooType external name 'mypackage.foo' language java\n";
    private static final String DROP_TYPE_DDL = "drop type fooType restrict\n";
    private static final String HASH_ALGORITHM_PROPERTY = "derby.authentication.builtin.algorithm";
    private static final String[][] USERS = new String[][]{{"dbo", "the boss", null, "3b6071d99b1d48ab732e75a8de701b6c77632db65898", "3b6071d99b1d48ab732e75a8de701b6c77632db65898"}, {"pat", "postman", "MD5", "3b609129e181a7f7527697235c8aead65c461a0257f3", "3b61aaca567ed43d1ba2e6402cbf1a723407:MD5"}, {"sam", "fireman", "SHA-1", "3b609e5173cfa03620061518adc92f2a58c7b15cf04f", "3b6197160362c0122fcd7a63a9da58fd0781140901fb:SHA-1"}};

    public Changes10_6(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        TestSuite suite = new TestSuite("Upgrade test for 10.6");
        suite.addTestSuite(Changes10_6.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testSetXplainStyleProcedure() throws SQLException {
        String[] xplainProcedures = new String[]{"call SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA('XPLAIN')", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA('')", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(1)", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(0)", "values SYSCS_UTIL.SYSCS_GET_XPLAIN_SCHEMA()", "values SYSCS_UTIL.SYSCS_GET_XPLAIN_MODE()"};
        switch (this.getPhase()) {
            case 1: 
            case 2: {
                Statement s = this.createStatement();
                for (int i = 0; i < xplainProcedures.length; ++i) {
                    Changes10_6.assertStatementError("42Y03", s, xplainProcedures[i]);
                }
                s.close();
                break;
            }
            case 3: {
                Statement s = this.createStatement();
                for (int i = 0; i < xplainProcedures.length; ++i) {
                    s.execute(xplainProcedures[i]);
                }
                s.close();
            }
        }
    }

    public void testCLOBGETSUBSTRING() throws Exception {
        Version initialVersion = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        Version firstVersionHavingThisFunction = new Version(10, 3, 0, 0);
        Version firstVersionHavingCorrectReturnType = new Version(10, 5, 0, 0);
        int wrongLength = 32672;
        int correctLength = 10890;
        boolean hasFunction = initialVersion.compareTo(firstVersionHavingThisFunction) >= 0;
        boolean hasCorrectReturnType = initialVersion.compareTo(firstVersionHavingCorrectReturnType) >= 0;
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select a.aliasinfo\nfrom sys.sysschemas s, sys.sysaliases a\nwhere s.schemaid = a.schemaid\nand s.schemaname = 'SYSIBM'\nand alias = 'CLOBGETSUBSTRING'\n");
        rs.next();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                if (!hasFunction) break;
                Object returnType = this.getTypeDescriptor(rs.getObject(1));
                int actualJdbcType = this.getJDBCTypeId(returnType);
                int actualLength = this.getMaximumWidth(returnType);
                int expectedLength = hasCorrectReturnType ? correctLength : wrongLength;
                Changes10_6.assertEquals((int)12, (int)actualJdbcType);
                Changes10_6.assertEquals((int)expectedLength, (int)actualLength);
                break;
            }
            case 3: {
                RoutineAliasInfo rai = (RoutineAliasInfo)rs.getObject(1);
                TypeDescriptor td = rai.getReturnType();
                Changes10_6.assertEquals((int)12, (int)td.getJDBCTypeId());
                Changes10_6.assertEquals((int)correctLength, (int)td.getMaximumWidth());
            }
        }
        rs.close();
        s.close();
    }

    public void testSYSCS_INPLACE_COMPRESS_TABLE() throws Exception {
        Version firstVersionHavingPermissions;
        Version initialVersion = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        boolean beforePermissionsWereAdded = initialVersion.compareTo(firstVersionHavingPermissions = new Version(10, 2, 0, 0)) < 0;
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                if (beforePermissionsWereAdded) {
                    Changes10_6.assertStatementError(TABLE_DOES_NOT_EXIST, s, QUERY_4215);
                    break;
                }
                this.vetDERBY_4215(s);
                break;
            }
            case 3: {
                this.vetDERBY_4215(s);
            }
        }
        s.close();
    }

    private void vetDERBY_4215(Statement s) throws Exception {
        String expectedGrantor = "APP";
        ResultSet rs = s.executeQuery(QUERY_4215);
        Changes10_6.assertTrue((boolean)rs.next());
        String actualGrantor = rs.getString(1);
        Changes10_6.assertEquals((String)expectedGrantor, (String)actualGrantor);
        Changes10_6.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testUDTs() throws Exception {
        Statement s = this.createStatement();
        int phase = this.getPhase();
        switch (phase) {
            case 0: 
            case 2: {
                Changes10_6.assertStatementError(BAD_SYNTAX, s, CREATE_TYPE_DDL);
                Changes10_6.assertStatementError(BAD_SYNTAX, s, DROP_TYPE_DDL);
                break;
            }
            case 1: {
                Changes10_6.assertStatementError(UPGRADE_REQUIRED, s, CREATE_TYPE_DDL);
                Changes10_6.assertStatementError(UPGRADE_REQUIRED, s, DROP_TYPE_DDL);
                break;
            }
            case 3: {
                s.execute(CREATE_TYPE_DDL);
                s.execute(DROP_TYPE_DDL);
            }
        }
        s.close();
    }

    private Object getTypeDescriptor(Object routineAliasDescriptor) throws Exception {
        Method meth = routineAliasDescriptor.getClass().getMethod("getReturnType", null);
        return meth.invoke(routineAliasDescriptor, null);
    }

    private int getJDBCTypeId(Object typeDescriptor) throws Exception {
        Method meth = typeDescriptor.getClass().getMethod("getJDBCTypeId", null);
        return (Integer)meth.invoke(typeDescriptor, null);
    }

    private int getMaximumWidth(Object typeDescriptor) throws Exception {
        Method meth = typeDescriptor.getClass().getMethod("getMaximumWidth", null);
        return (Integer)meth.invoke(typeDescriptor, null);
    }

    public void testBuiltinAuthenticationHashNotChangedOnUpgrade() throws SQLException {
        Changes10_6.assertNull((Object)this.getDatabaseProperty(HASH_ALGORITHM_PROPERTY));
    }

    public void testBuiltinAuthenticationWithConfigurableHash() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical("BUILTIN_10_6");
        if (this.getPhase() == 0) {
            JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        } else if (this.getPhase() == 3) {
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true");
        }
        Connection c = ds.getConnection("dbo", "the boss");
        this.verifyCanConnect(ds);
        CallableStatement setProp = c.prepareCall("call syscs_util.syscs_set_database_property(?, ?)");
        if (this.getPhase() == 0) {
            setProp.setString(1, "derby.connection.requireAuthentication");
            setProp.setString(2, "true");
            setProp.execute();
            setProp.setString(1, "derby.authentication.provider");
            setProp.setString(2, "BUILTIN");
            setProp.execute();
        }
        this.setPasswords(setProp);
        setProp.close();
        this.verifyCanConnect(ds);
        this.verifyPasswords(c, this.getPhase() == 3);
        c.close();
        JDBCDataSource.setBeanProperty(ds, "user", "dbo");
        JDBCDataSource.setBeanProperty(ds, "password", "the boss");
        JDBCDataSource.shutdownDatabase(ds);
    }

    private void setPasswords(CallableStatement cs) throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            cs.setString(1, HASH_ALGORITHM_PROPERTY);
            cs.setString(2, USERS[i][2]);
            cs.execute();
            cs.setString(1, "derby.user." + USERS[i][0]);
            cs.setString(2, USERS[i][1]);
            cs.execute();
        }
    }

    private void verifyPasswords(Connection c, boolean newScheme) throws SQLException {
        PreparedStatement ps = c.prepareStatement("values syscs_util.syscs_get_database_property(?)");
        for (int i = 0; i < USERS.length; ++i) {
            String expectedToken = USERS[i][newScheme ? 4 : 3];
            ps.setString(1, "derby.user." + USERS[i][0]);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), expectedToken);
        }
        ps.close();
    }

    private void verifyCanConnect(DataSource ds) throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            Connection c = ds.getConnection(USERS[i][0], USERS[i][1]);
            c.close();
        }
    }
}

