/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class OldVersions {
    private static int[][] VERSIONS = new int[][]{{10, 0, 2, 1}, {10, 1, 1, 0}, {10, 1, 2, 1}, {10, 1, 3, 1}, {10, 2, 1, 6}, {10, 2, 2, 0}, {10, 3, 1, 4}, {10, 3, 3, 0}, {10, 4, 1, 3}, {10, 4, 2, 0}, {10, 5, 1, 1}, {10, 5, 3, 0}, {10, 6, 1, 0}, {10, 6, 2, 1}, {10, 7, 1, 1}};
    public static int[] VERSION_10_3_3_0 = new int[]{10, 3, 3, 0};

    public static int[][] getSupportedVersions() {
        int[][] old = null;
        if (UpgradeRun.oldVersionsPath != null) {
            old = OldVersions.getVersions(UpgradeRun.oldVersionsPath);
        }
        if (old == null) {
            old = VERSIONS;
        }
        OldVersions.show(old);
        return OldVersions.getSupportedVersions(old);
    }

    private static int[][] getSupportedVersions(int[][] old) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        int count = old.length;
        for (int i = 0; i < count; ++i) {
            if (JDBC.vmSupportsJSR169() && old[i][0] == 10 && old[i][1] == 0) {
                OldVersions.traceit("Skipping 10.0 on JSR169");
                continue;
            }
            if (BaseTestCase.isPhoneME() && old[i][0] == 10 && old[i][1] == 3 && old[i][2] == 1 && old[i][3] == 4) {
                OldVersions.traceit("Skipping 10.3.1.4 on CVM/phoneme");
                continue;
            }
            list.add(old[i]);
        }
        int[][] result = new int[list.size()][4];
        list.toArray((T[])result);
        return result;
    }

    private static int[][] getVersions(String oldVersionsPath) {
        BufferedReader br = null;
        try {
            FileReader fr = new FileReader(oldVersionsPath);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException fNFE) {
            OldVersions.alarm("File '" + oldVersionsPath + "' was not found, using default old versions for upgrade tests.");
            return null;
        }
        OldVersions.traceit("Run upgrade tests on versions defined in '" + oldVersionsPath + "'");
        return OldVersions.getVersions(br, oldVersionsPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[][] getVersions(BufferedReader br, String oldVersionsPath) {
        int[][] versionArray = new int[256][4];
        int versions = 0;
        String line = null;
        int lineNum = 0;
        try {
            while ((line = br.readLine()) != null) {
                ++lineNum;
                try {
                    String[] parts = OldVersions.split4(line, '.');
                    if (parts.length >= 3) {
                        int[] vstr = new int[4];
                        for (int i = 0; i < 4; ++i) {
                            String str = parts[i];
                            if (i == 3) {
                                str = OldVersions.clean(str, "0123456789");
                            }
                            vstr[i] = Integer.parseInt(str);
                        }
                        versionArray[versions++] = vstr;
                        continue;
                    }
                    OldVersions.alarm("Illegal version format on: " + line);
                }
                catch (NumberFormatException nfe) {
                    OldVersions.alarm("NumberFormatException on line " + lineNum + ": " + line + ": " + " " + nfe.getMessage());
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    OldVersions.alarm("ArrayIndexOutOfBoundsException on line " + lineNum + ": " + line + ": " + " " + aie.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            OldVersions.alarm("Error reading from file: " + oldVersionsPath + ioe.getMessage());
        }
        int[][] finalVERSIONS = new int[versions][4];
        int v = 0;
        while (v < versions) {
            finalVERSIONS[v] = versionArray[v];
            ++v;
        }
        return finalVERSIONS;
    }

    private static void show(int[][] old) {
        OldVersions.traceit("Upgrade test versions listed:");
        for (int o = 0; o < old.length; ++o) {
            String ver = "";
            for (int i = 0; i < old[o].length; ++i) {
                ver = i == 0 ? "" + old[o][i] : ver + "." + old[o][i];
            }
            OldVersions.traceit(ver);
        }
    }

    private static String[] split4(String l, char c) {
        String[] res = new String[4];
        try {
            int p0 = l.indexOf(c);
            if (p0 < 0) {
                return res;
            }
            res[0] = l.substring(0, p0);
            int p1 = l.indexOf(c, p0 + 1);
            if (p1 < 0) {
                return res;
            }
            res[1] = l.substring(p0 + 1, p1);
            int p2 = l.indexOf(c, p1 + 1);
            if (p2 < 0) {
                return res;
            }
            res[2] = l.substring(p1 + 1, p2);
            int p3 = l.indexOf(c, p2 + 1);
            if (p3 < 0) {
                p3 = l.length();
            }
            res[3] = l.substring(p2 + 1, p3);
        }
        catch (StringIndexOutOfBoundsException sie) {
            OldVersions.println("split4 StringIndexOutOfBoundsException: " + sie.getMessage());
            sie.printStackTrace();
        }
        return res;
    }

    private static String clean(String l, String allowed) {
        for (int i = 0; i < l.length(); ++i) {
            if (OldVersions.matches(l.charAt(i), allowed)) continue;
            return l.substring(0, i);
        }
        return l;
    }

    private static boolean matches(char c, String allowed) {
        for (int j = 0; j < allowed.length(); ++j) {
            if (allowed.charAt(j) != c) continue;
            return true;
        }
        return false;
    }

    private static void println(String text) {
        BaseTestCase.println(text);
    }

    private static void traceit(String text) {
        BaseTestCase.traceit(text);
    }

    private static void alarm(String text) {
        BaseTestCase.alarm(text);
    }
}

