/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ValuesTest
extends JDBCPerfTestCase {
    private PreparedStatement ps;

    public static Test suite() {
        int iterations = 100000;
        int repeats = 4;
        TestSuite suite = new TestSuite("ValuesTest");
        suite.addTest((Test)new ValuesTest("fetchByColumnName", iterations, repeats));
        suite.addTest((Test)new ValuesTest("fetchByColumnNumber", iterations, repeats));
        TestSuite client = new TestSuite("Client_ValuesTest");
        client.addTest((Test)new ValuesTest("fetchByColumnName", iterations, repeats));
        client.addTest((Test)new ValuesTest("fetchByColumnNumber", iterations, repeats));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)client));
        return suite;
    }

    public ValuesTest(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    public ValuesTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        ValuesTest.println("Setup()::ValuesTest");
        this.ps = this.openDefaultConnection().prepareStatement("SELECT * FROM TABLE(VALUES (1,1,1), (2,2,2), (3,3,3), (4,4,4), (5,5,5)) AS T(\"cOlumN1\", COLUMN2, \"column3\")", 1003, 1007, 2);
    }

    public void fetchByColumnName() throws SQLException {
        ResultSet rs = this.ps.executeQuery();
        while (rs.next()) {
            rs.getInt("column1");
            rs.getInt("COLUMN2");
            rs.getInt("column3");
        }
        rs.close();
    }

    public void fetchByColumnNumber() throws SQLException {
        ResultSet rs = this.ps.executeQuery();
        while (rs.next()) {
            rs.getInt(1);
            rs.getInt(2);
            rs.getInt(3);
        }
        rs.close();
    }

    public void tearDown() throws Exception {
        ValuesTest.println("ValuesTest::tearDown");
        this.ps.close();
        this.ps = null;
        super.tearDown();
    }
}

