/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;

public class SingleRecordSelectClient
implements Client {
    private Connection conn;
    private final PreparedStatement[] pss;
    private final Random r;
    private final int tableSize;
    private final int dataType;
    private final boolean secondaryIndex;
    private final boolean noIndex;

    public SingleRecordSelectClient(int records, int tables) {
        this(records, tables, 12, false, false);
    }

    public SingleRecordSelectClient(int records, int tables, int type, boolean secIndex, boolean nonIndexed) {
        this.tableSize = records;
        this.r = new Random();
        this.pss = new PreparedStatement[tables];
        this.dataType = type;
        if (secIndex && nonIndexed) {
            throw new IllegalArgumentException("Cannot select on both secondary index and non-index column");
        }
        this.secondaryIndex = secIndex;
        this.noIndex = nonIndexed;
    }

    public void init(Connection c) throws SQLException {
        for (int i = 0; i < this.pss.length; ++i) {
            String tableName = SingleRecordFiller.getTableName(this.tableSize, i, this.dataType, this.secondaryIndex, this.noIndex);
            String column = "ID";
            if (this.secondaryIndex) {
                column = "SEC";
            } else if (this.noIndex) {
                column = "NI";
            }
            String sql = "SELECT ID, TEXT FROM " + tableName + " WHERE " + column + " = ?";
            this.pss[i] = c.prepareStatement(sql);
        }
        c.setAutoCommit(false);
        this.conn = c;
    }

    public void doWork() throws SQLException {
        PreparedStatement ps = this.pss[this.r.nextInt(this.pss.length)];
        ps.setInt(1, this.r.nextInt(this.tableSize));
        ResultSet rs = ps.executeQuery();
        rs.next();
        rs.getInt(1);
        this.fetchTextColumn(rs, 2);
        rs.close();
        this.conn.commit();
    }

    public void printReport(PrintStream out) {
    }

    private void fetchTextColumn(ResultSet rs, int column) throws SQLException {
        if (this.dataType == 12) {
            rs.getString(column);
        } else if (this.dataType == 2005) {
            rs.getClob(column).getSubString(1L, 100);
        } else if (this.dataType == 2004) {
            rs.getBlob(column).getBytes(1L, 100);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

