/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import jdbcacsess2.connect.ConfigConnect;
import jdbcacsess2.connect.ConfigDbms;
import jdbcacsess2.connect.ConnectView;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.main.MainView;
import jdbcacsess2.main.OneLinenFormatter;
import jdbcacsess2.sqlService.history.ExecHistory;
import net.java.ao.DBParam;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class Config {
    private static final String CONFIG_DIR = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".jdbcacsess2";
    private static final String CONFIG_DB = "config.derby";
    private static final String CONFIG_JDBCURL = "jdbc:derby:" + CONFIG_DIR + System.getProperty("file.separator") + "config.derby" + ";create=true";
    private static final String CONFIG_JDBCCLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String USER = "";
    private static final String PASS = "";
    private final EntityManager entityManager;

    public Config() throws IOException, ClassNotFoundException, SQLException {
        OneLinenFormatter oneLine = new OneLinenFormatter();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(oneLine);
        consoleHandler.setLevel(Level.ALL);
        Jdbcacsess2.logger.addHandler(consoleHandler);
        Jdbcacsess2.logger.setUseParentHandlers(false);
        Jdbcacsess2.loggerActiveObjects.addHandler(consoleHandler);
        Jdbcacsess2.loggerActiveObjects.setUseParentHandlers(false);
        File configDir = new File(CONFIG_DIR);
        if (!configDir.exists() && !configDir.mkdir()) {
            throw new IOException("Couldnt create diretrory:" + configDir.getAbsolutePath());
        }
        FileHandler fileHandler = new FileHandler(String.valueOf(CONFIG_DIR) + File.separator + "message.log", 0x100000, 5);
        fileHandler.setFormatter(oneLine);
        fileHandler.setLevel(Level.ALL);
        Jdbcacsess2.logger.addHandler(fileHandler);
        Jdbcacsess2.loggerActiveObjects.addHandler(fileHandler);
        Jdbcacsess2.logger.info("file logger start");
        Jdbcacsess2.logger.info("configure directory:" + CONFIG_DIR);
        if (Jdbcacsess2.logger.isLoggable(Level.FINE)) {
            Properties prop = System.getProperties();
            ArrayList<String> aList = Collections.list(this.extracted(prop));
            Collections.sort(aList);
            for (String string : aList) {
                Jdbcacsess2.logger.fine(String.valueOf(string) + ":" + System.getProperty(string));
            }
        } else {
            Jdbcacsess2.logger.info(String.valueOf(System.getProperty("java.vm.vendor")) + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
            Jdbcacsess2.logger.info(System.getProperty("java.home"));
            Jdbcacsess2.logger.info(System.getProperty("java.class.path"));
            Jdbcacsess2.logger.info(System.getProperty("java.library.path"));
            Jdbcacsess2.logger.info(System.getProperty("java.ext.dirs"));
        }
        Class.forName(CONFIG_JDBCCLASS);
        this.entityManager = new EntityManager(CONFIG_JDBCURL, "", "");
        Jdbcacsess2.loggerActiveObjects.setLevel(Level.WARNING);
        this.migrate();
        this.setUpConfigDbms();
        Jdbcacsess2.logger.info("Config end");
    }

    private Enumeration<String> extracted(Properties prop) {
        return prop.propertyNames();
    }

    private void migrate() throws SQLException {
        this.getEntityManager().migrate(new Class[]{ConfigDbms.class, ConfigConnect.class, ConnectView.ConfigViewConnect.class, MainView.ConfigViewMain.class, ExecHistory.class});
    }

    public ConfigDbms[] getConfigDbms() throws SQLException {
        return (ConfigDbms[])this.getEntityManager().find(ConfigDbms.class, Query.select().order("dbmsname"));
    }

    public ConfigConnect[] getConfigConnect() throws SQLException {
        return (ConfigConnect[])this.getEntityManager().find(ConfigConnect.class, Query.select());
    }

    public ConfigConnect getConfigConnectRow(String connectName) throws SQLException {
        ConfigConnect[] configConnects = (ConfigConnect[])this.getEntityManager().find(ConfigConnect.class, Query.select().where("connectname=?", new Object[]{connectName}));
        ConfigConnect rtn = (long)configConnects.length == 0L ? (ConfigConnect)this.getEntityManager().create(ConfigConnect.class, new DBParam[]{new DBParam("connectname", (Object)connectName)}) : configConnects[0];
        return rtn;
    }

    public <T extends RawEntity<K>, K> T getConfigWindow(Class<T> type) throws SQLException {
        RawEntity[] e = this.getEntityManager().find(type);
        if (e.length != 0) {
            return (T)e[0];
        }
        return (T)this.getEntityManager().create(type, new DBParam[0]);
    }

    private void setUpConfigDbms() throws SQLException {
        String[] colnames = new String[]{"dbmsname", "subprotocol", "subname", "driverclass", "urloption"};
        String[][] rows = new String[][]{{"PostgreSQL", "postgresql", "//%HostName%%PortNumber%/%DataBaseName%", "org.postgresql.Driver", ""}, {"MySQL", "mysql", "//%HostName%%PortNumber%/%DataBaseName%", "org.gjt.mm.mysql.Driver", ""}, {"MySQL(com)", "mysql", "//%HostName%%PortNumber%/%DataBaseName%", "com.mysql.jdbc.Driver", ""}, {"HSQL", "hsqldb:hsql", "//%HostName%%PortNumber%/%DataBaseName%", "org.hsqldb.jdbcDriver", ""}, {"Oracle(TYPE4:Pure Java)", "oracle:thin", "@%HostName%%PortNumber%:%DataBaseName%", "oracle.jdbc.driver.OracleDriver", ""}, {"Oracle(TYPE2:NET)", "oracle:oci", "@%DataBaseName%", "oracle.jdbc.driver.OracleDriver", ""}, {"Oracle(TYPE2:NET8)", "oracle:oci8", "@%DataBaseName%", "oracle.jdbc.driver.OracleDriver", ""}, {"DB2(TYPE4:Universal)", "db2", "//%HostName%%PortNumber%/%DataBaseName%", "com.ibm.db2.jcc.DB2Driver", ""}, {"DB2(TYPE2:Universal)", "db2", "%DataBaseName%", "com.ibm.db2.jcc.DB2Driver", ""}, {"DB2(TYPE2:App)", "db2", "%DataBaseName%", "COM.ibm.db2.jdbc.app.DB2Driver", ""}, {"DB2(TYPE3:Net)", "db2", "//%HostName%%PortNumber%/%DataBaseName%", "COM.ibm.db2.jdbc.net.DB2Driver", ""}, {"SQL Server", "sqlserver", "//%HostName%%PortNumber%;databaseName=%DataBaseName%", "com.microsoft.sqlserver.jdbc.SQLServerDriver", ""}, {"SQL Server(2000)", "microsoft:sqlserver", "//%HostName%%PortNumber%;databaseName=%DataBaseName%", "com.microsoft.jdbc.sqlserver.SQLServerDriver", ""}, {"Derby(Embedded)", "derby", "%DataBaseName%", CONFIG_JDBCCLASS, ""}, {"Derby(Client)", "derby", "%DataBaseName%", "org.apache.derby.jdbc.ClientDriver", ""}, {"SQLite", "sqlite", "/%DataBaseName%", "org.sqlite.JDBC", ""}, {"Firebird", "firebirdsql", "//%HostName%%PortNumber%/%DataBaseName%", "org.firebirdsql.jdbc.FBDriver", ""}, {"Symfoware", "symford", "//%HostName%%PortNumber%/%DataBaseName%", "com.fujitsu.symfoware.jdbc.SYMDriver", ""}, {"HiRDB", "hitachi:hirdb", "//DBID=%PortNumberRAW%,DBHOST=%HostName%", "JP.co.Hitachi.soft.HiRDB.JDBC.HiRDBDriver", ""}, {"ODBC(TYPE1)", "odbc", "%DataBaseName%", "sun.jdbc.odbc.JdbcOdbcDriver", ""}, {"free format", "", "", "", ""}};
        int i = 0;
        while (i < rows.length) {
            ConfigDbms[] dbms = (ConfigDbms[])this.getEntityManager().find(ConfigDbms.class, Query.select().where("dbmsname=?", new Object[]{rows[i][0]}));
            if (dbms.length == 0) {
                HashMap<String, String> m = new HashMap<String, String>();
                int j = 0;
                while (j < colnames.length) {
                    m.put(colnames[j], rows[i][j]);
                    ++j;
                }
                this.getEntityManager().create(ConfigDbms.class, m);
                Jdbcacsess2.logger.info("not exists:" + rows[i][0]);
            }
            ++i;
        }
    }

    public void close() {
        this.getEntityManager().flushAll();
        this.getEntityManager().getProvider().dispose();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

