/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class FontZoom {
    public static void setMouseWheel(Component component) {
        component.addKeyListener(new MouseWheelControl());
    }

    private static class MouseWheelControl
    implements KeyListener {
        private boolean press = false;
        private final MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!e.isControlDown()) {
                    return;
                }
                Component c = e.getComponent();
                Font font = c.getFont();
                float size = font.getSize() + e.getWheelRotation();
                if (4.0f < size && size < 30.0f) {
                    c.setFont(font.deriveFont(size));
                }
                e.consume();
            }
        };

        private MouseWheelControl() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.press) {
                return;
            }
            if (e.getKeyCode() == 17) {
                e.getComponent().addMouseWheelListener(this.mouseWheelListener);
                this.press = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                e.getComponent().removeMouseWheelListener(this.mouseWheelListener);
                this.press = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

