/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.ColumnAttributeResult;
import jdbcacsess2.sqlService.SqlExecuteTask;
import jdbcacsess2.sqlService.SqlExecutedListener;
import jdbcacsess2.sqlService.parse.SqlExecuteSentencies;

public class ResultsTableModel
extends AbstractTableModel
implements SqlExecutedListener,
TableModelListener {
    private static final long serialVersionUID = -4605343361563115844L;
    private List<ColumnAttributeResult> headerList = Collections.synchronizedList(new ArrayList());
    private List<List<Object>> detailList = Collections.synchronizedList(new ArrayList());
    private volatile boolean tableEditable = false;

    @Override
    public void taskAccept(SqlExecuteTask sqlExecuteTask) {
    }

    @Override
    public void executBegin(SqlExecuteSentencies.SqlExecuteSentence sqlExecuteSentence) {
        this.tableEditable = sqlExecuteSentence.isEditable();
    }

    @Override
    public void executNormalFinish(int count) {
    }

    @Override
    public void executeException(Throwable t) {
    }

    @Override
    public void resultHeader(final List<ColumnAttributeResult> header) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultsTableModel.this.headerList.clear();
                ResultsTableModel.this.detailList.clear();
                ResultsTableModel.this.headerList.addAll(header);
                ResultsTableModel.this.fireTableStructureChanged();
            }
        });
    }

    @Override
    public void resultDetail(final int seq, final List<Object> results) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultsTableModel.this.detailList.add(results);
                ResultsTableModel.this.fireTableRowsInserted(seq - 1, seq - 1);
            }
        });
    }

    @Override
    public void statusContinue(int seqNo) {
    }

    @Override
    public void executeAllEnd() {
    }

    @Override
    public int getColumnCount() {
        return this.headerList.size();
    }

    @Override
    public int getRowCount() {
        return this.detailList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.detailList.get(rowIndex).get(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.headerList.get(column).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.headerList.get(columnIndex).getColumnClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableEditable;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Jdbcacsess2.logger.info("setValueAt:row=" + rowIndex + ",col=" + columnIndex + ",val=" + aValue);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == -1) {
            Jdbcacsess2.logger.info("tableChanged(DELETE):row=" + e.getFirstRow() + "," + e.getLastRow());
        }
    }
}

