/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.sqlService.ColumnAttributeResult;
import jdbcacsess2.sqlService.ConstSqlTypes;
import jdbcacsess2.sqlService.DataBaseConnection;
import jdbcacsess2.sqlService.DataBaseConnectionListener;
import jdbcacsess2.sqlService.SqlExecuteParmeter;
import jdbcacsess2.sqlService.SqlExecuteTask;
import jdbcacsess2.sqlService.SqlExecutedListener;
import jdbcacsess2.sqlService.exception.DbConnectIllgalStateException;
import jdbcacsess2.sqlService.parse.SqlExecuteSentencies;
import jdbcacsess2.sqlService.parse.SqlInputParameter;

public class SqlAsyncExecute {
    private volatile int resultRowLimitCnt = 5000;
    private final ArrayList<SqlExecuteSentencies.SqlExecuteSentence> sqlExecuteSentenceList;
    private final EventListenerList sqlExecutedListeners = new EventListenerList();
    private Thread thread;

    public SqlAsyncExecute(String sqlSentence, String sentenceSeparator) {
        this.sqlExecuteSentenceList = new SqlExecuteSentencies(sqlSentence, sentenceSeparator).getSqlExecuteSentenceList();
    }

    public boolean isDuplxSelect() {
        int cnt = 0;
        for (SqlExecuteSentencies.SqlExecuteSentence sqlExecuteSentence : this.sqlExecuteSentenceList) {
            if (!sqlExecuteSentence.getSqlCommand().equals("SELECT") || ++cnt != 2) continue;
            return true;
        }
        return false;
    }

    public ArrayList<SqlExecuteSentencies.SqlExecuteSentence> getSqlExecuteSentencies() {
        return this.sqlExecuteSentenceList;
    }

    public int getResultRowLimitCnt() {
        return this.resultRowLimitCnt;
    }

    public void setResultRowLimitCnt(int resultRowLimitCnt) {
        this.resultRowLimitCnt = resultRowLimitCnt;
    }

    public void addSqlExcutedListener(SqlExecutedListener listener) {
        this.sqlExecutedListeners.add(SqlExecutedListener.class, listener);
    }

    public void removeSqlExcutedListener(SqlExecutedListener listener) {
        this.sqlExecutedListeners.remove(SqlExecutedListener.class, listener);
    }

    public SqlExecuteTask executeAsync(DataBaseConnection dataBaseConnection) throws DbConnectIllgalStateException {
        dataBaseConnection.lockConnection(this.sqlExecuteSentenceList.size() == 0 ? "" : this.sqlExecuteSentenceList.get(0).getSqlCommand());
        SqlTask sqlTask = new SqlTask(dataBaseConnection);
        this.thread = new Thread(sqlTask);
        this.thread.start();
        SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
        int n = sqlExecutedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlExecutedListener l = sqlExecutedListenerArray[n2];
            l.taskAccept(sqlTask);
            ++n2;
        }
        Jdbcacsess2.logger.fine("(execute) return.");
        return sqlTask;
    }

    class SqlTask
    implements Runnable,
    SqlExecuteTask {
        private final DataBaseConnection dataBaseConnection;
        private PreparedStatement preparedStatement;
        private int rowCnt;
        private boolean available = false;
        private Throwable sqlTaskThrow;
        private volatile long timeMillisThreadStart;
        private volatile long timeMillisThreadEnd;
        private final DataBaseConnectionListener changeConnection = new DataBaseConnectionListener(){

            @Override
            public void dataBaseConnectionOpened(DataBaseConnection dataBaseConnection) {
            }

            @Override
            public void dataBaseConnectionClosing(DataBaseConnection dataBaseConnection) {
                if (SqlTask.this.preparedStatement != null) {
                    try {
                        SqlTask.this.preparedStatement.cancel();
                    }
                    catch (Exception e) {
                        ShowDialog.errorMessage(e);
                    }
                }
                SqlTask.this.taskCancel();
                SqlTask.this.taskJoin(3);
            }

            @Override
            public void dataBaseConnectionClosed(DataBaseConnection dataBaseConnection) {
            }
        };

        public SqlTask(DataBaseConnection dataBaseConnection) {
            this.dataBaseConnection = dataBaseConnection;
        }

        @Override
        public void run() {
            Jdbcacsess2.logger.info("(task)beging.");
            this.dataBaseConnection.addConnectionListener(this.changeConnection);
            for (SqlExecuteSentencies.SqlExecuteSentence sentence : SqlAsyncExecute.this.sqlExecuteSentenceList) {
                if (Thread.interrupted()) {
                    Jdbcacsess2.logger.info("  (task)canceled.");
                    break;
                }
                this.sqlExec(sentence);
            }
            try {
                this.dataBaseConnection.unlockConnection();
            }
            catch (DbConnectIllgalStateException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.dataBaseConnection.removeConnectionlisteners(this.changeConnection);
            SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
            int n = sqlExecutedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SqlExecutedListener l = sqlExecutedListenerArray[n2];
                l.executeAllEnd();
                ++n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sqlExec(SqlExecuteSentencies.SqlExecuteSentence sqlExecuteSentence) {
            block71: {
                Throwable throwable5;
                block73: {
                    int n;
                    int n2;
                    SqlExecutedListener[] sqlExecutedListenerArray;
                    block74: {
                        block72: {
                            int n3;
                            int n4;
                            SqlExecutedListener[] sqlExecutedListenerArray2;
                            block63: {
                                Throwable throwable22;
                                block67: {
                                    Throwable throwable32;
                                    block69: {
                                        int n5;
                                        int n6;
                                        SqlExecutedListener[] sqlExecutedListenerArray3;
                                        block70: {
                                            block68: {
                                                block64: {
                                                    Throwable throwable42;
                                                    block66: {
                                                        block65: {
                                                            int n7;
                                                            int n8;
                                                            SqlExecutedListener[] sqlExecutedListenerArray4;
                                                            this.sqlTaskThrow = null;
                                                            this.timeMillisThreadStart = System.currentTimeMillis();
                                                            this.timeMillisThreadEnd = 0L;
                                                            this.rowCnt = 0;
                                                            try {
                                                                try {
                                                                    Jdbcacsess2.logger.info("  (Statement)EXECSQL=[" + sqlExecuteSentence.getSqlSentence() + "]");
                                                                    SqlExecutedListener[] sqlExecutedListenerArray5 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                                    int n9 = sqlExecutedListenerArray5.length;
                                                                    int n10 = 0;
                                                                    while (true) {
                                                                        if (n10 >= n9) {
                                                                            this.preparedStatement = sqlExecuteSentence.getSqlCommand().equals("CALL") ? this.dataBaseConnection.prepareCall(sqlExecuteSentence.getSqlSentence()) : this.dataBaseConnection.prepareStatement(sqlExecuteSentence.getSqlSentence());
                                                                        }
                                                                        SqlExecutedListener l = sqlExecutedListenerArray5[n10];
                                                                        l.executBegin(sqlExecuteSentence);
                                                                        ++n10;
                                                                    }
                                                                    SqlInputParameter sqlInputParameter = sqlExecuteSentence.getSqlInputParameter();
                                                                    while (sqlInputParameter.getSqlExecuteParmeter().hasNext()) {
                                                                        if (Thread.interrupted()) {
                                                                            Jdbcacsess2.logger.info("  (task)canceled.");
                                                                            break block63;
                                                                        }
                                                                        SqlExecuteParmeter.Parameter parameter = sqlInputParameter.getSqlExecuteParmeter().getParameter();
                                                                        this.setParameters(sqlInputParameter.getInputItemNames(), parameter);
                                                                        if (this.preparedStatement.execute()) {
                                                                            this.readResultSet();
                                                                            continue;
                                                                        }
                                                                        this.rowCnt += this.preparedStatement.getUpdateCount();
                                                                    }
                                                                    break block63;
                                                                }
                                                                catch (Throwable t) {
                                                                    int n11;
                                                                    int n12;
                                                                    SqlExecutedListener[] sqlExecutedListenerArray6;
                                                                    t.printStackTrace();
                                                                    this.sqlTaskThrow = t;
                                                                    try {
                                                                        try {
                                                                            if (this.preparedStatement != null) {
                                                                                this.preparedStatement.close();
                                                                                Jdbcacsess2.logger.info("  (task)Statement closed");
                                                                            }
                                                                            break block64;
                                                                        }
                                                                        catch (SQLException e) {
                                                                            Jdbcacsess2.logger.log(Level.WARNING, "WARNING", e);
                                                                            this.preparedStatement = null;
                                                                            this.timeMillisThreadEnd = System.currentTimeMillis();
                                                                            if (this.sqlTaskThrow != null) break block65;
                                                                            sqlExecutedListenerArray6 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                                            n12 = sqlExecutedListenerArray6.length;
                                                                            n11 = 0;
                                                                        }
                                                                    }
                                                                    catch (Throwable throwable42) {
                                                                        this.preparedStatement = null;
                                                                        this.timeMillisThreadEnd = System.currentTimeMillis();
                                                                        if (this.sqlTaskThrow != null) break block66;
                                                                        sqlExecutedListenerArray4 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                                        n8 = sqlExecutedListenerArray4.length;
                                                                        n7 = 0;
                                                                    }
                                                                    while (true) {
                                                                        if (n11 >= n12) {
                                                                            Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                                            return;
                                                                        }
                                                                        SqlExecutedListener l = sqlExecutedListenerArray6[n11];
                                                                        l.executNormalFinish(this.rowCnt);
                                                                        ++n11;
                                                                    }
                                                                }
                                                            }
                                                            catch (Throwable throwable22) {
                                                                int n13;
                                                                int n14;
                                                                SqlExecutedListener[] sqlExecutedListenerArray7;
                                                                try {
                                                                    try {
                                                                        if (this.preparedStatement != null) {
                                                                            this.preparedStatement.close();
                                                                            Jdbcacsess2.logger.info("  (task)Statement closed");
                                                                        }
                                                                        break block67;
                                                                    }
                                                                    catch (SQLException e) {
                                                                        Jdbcacsess2.logger.log(Level.WARNING, "WARNING", e);
                                                                        this.preparedStatement = null;
                                                                        this.timeMillisThreadEnd = System.currentTimeMillis();
                                                                        if (this.sqlTaskThrow != null) break block68;
                                                                        sqlExecutedListenerArray7 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                                        n14 = sqlExecutedListenerArray7.length;
                                                                        n13 = 0;
                                                                    }
                                                                }
                                                                catch (Throwable throwable32) {
                                                                    this.preparedStatement = null;
                                                                    this.timeMillisThreadEnd = System.currentTimeMillis();
                                                                    if (this.sqlTaskThrow != null) break block69;
                                                                    sqlExecutedListenerArray3 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                                    n6 = sqlExecutedListenerArray3.length;
                                                                    n5 = 0;
                                                                    break block70;
                                                                }
                                                                while (true) {
                                                                    if (n13 >= n14) {
                                                                        Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                                        throw throwable22;
                                                                    }
                                                                    SqlExecutedListener l = sqlExecutedListenerArray7[n13];
                                                                    l.executNormalFinish(this.rowCnt);
                                                                    ++n13;
                                                                }
                                                            }
                                                            while (true) {
                                                                if (n7 >= n8) {
                                                                    Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                                    throw throwable42;
                                                                }
                                                                SqlExecutedListener l = sqlExecutedListenerArray4[n7];
                                                                l.executNormalFinish(this.rowCnt);
                                                                ++n7;
                                                            }
                                                        }
                                                        SqlExecutedListener[] sqlExecutedListenerArray8 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                        int n15 = sqlExecutedListenerArray8.length;
                                                        int n16 = 0;
                                                        while (true) {
                                                            if (n16 >= n15) {
                                                                Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                                return;
                                                            }
                                                            SqlExecutedListener l = sqlExecutedListenerArray8[n16];
                                                            l.executeException(this.sqlTaskThrow);
                                                            ++n16;
                                                        }
                                                    }
                                                    SqlExecutedListener[] sqlExecutedListenerArray9 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                    int n17 = sqlExecutedListenerArray9.length;
                                                    int n18 = 0;
                                                    while (true) {
                                                        if (n18 >= n17) {
                                                            Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                            throw throwable42;
                                                        }
                                                        SqlExecutedListener l = sqlExecutedListenerArray9[n18];
                                                        l.executeException(this.sqlTaskThrow);
                                                        ++n18;
                                                    }
                                                }
                                                this.preparedStatement = null;
                                                this.timeMillisThreadEnd = System.currentTimeMillis();
                                                if (this.sqlTaskThrow == null) {
                                                    SqlExecutedListener[] sqlExecutedListenerArray10 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                    int n19 = sqlExecutedListenerArray10.length;
                                                    int n20 = 0;
                                                    while (true) {
                                                        if (n20 >= n19) {
                                                            Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                            return;
                                                        }
                                                        SqlExecutedListener l = sqlExecutedListenerArray10[n20];
                                                        l.executNormalFinish(this.rowCnt);
                                                        ++n20;
                                                    }
                                                }
                                                SqlExecutedListener[] sqlExecutedListenerArray11 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                                int n21 = sqlExecutedListenerArray11.length;
                                                int n22 = 0;
                                                while (true) {
                                                    if (n22 >= n21) {
                                                        Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                        return;
                                                    }
                                                    SqlExecutedListener l = sqlExecutedListenerArray11[n22];
                                                    l.executeException(this.sqlTaskThrow);
                                                    ++n22;
                                                }
                                            }
                                            SqlExecutedListener[] sqlExecutedListenerArray12 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                            int n23 = sqlExecutedListenerArray12.length;
                                            int n24 = 0;
                                            while (true) {
                                                if (n24 >= n23) {
                                                    Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                    throw throwable22;
                                                }
                                                SqlExecutedListener l = sqlExecutedListenerArray12[n24];
                                                l.executeException(this.sqlTaskThrow);
                                                ++n24;
                                            }
                                        }
                                        while (true) {
                                            if (n5 >= n6) {
                                                Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                                throw throwable32;
                                            }
                                            SqlExecutedListener l = sqlExecutedListenerArray3[n5];
                                            l.executNormalFinish(this.rowCnt);
                                            ++n5;
                                        }
                                    }
                                    SqlExecutedListener[] sqlExecutedListenerArray13 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                    int n25 = sqlExecutedListenerArray13.length;
                                    int n26 = 0;
                                    while (true) {
                                        if (n26 >= n25) {
                                            Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                            throw throwable32;
                                        }
                                        SqlExecutedListener l = sqlExecutedListenerArray13[n26];
                                        l.executeException(this.sqlTaskThrow);
                                        ++n26;
                                    }
                                }
                                this.preparedStatement = null;
                                this.timeMillisThreadEnd = System.currentTimeMillis();
                                if (this.sqlTaskThrow == null) {
                                    SqlExecutedListener[] sqlExecutedListenerArray14 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                    int n27 = sqlExecutedListenerArray14.length;
                                    int n28 = 0;
                                    while (true) {
                                        if (n28 >= n27) {
                                            Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                            throw throwable22;
                                        }
                                        SqlExecutedListener l = sqlExecutedListenerArray14[n28];
                                        l.executNormalFinish(this.rowCnt);
                                        ++n28;
                                    }
                                }
                                SqlExecutedListener[] sqlExecutedListenerArray15 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                int n29 = sqlExecutedListenerArray15.length;
                                int n30 = 0;
                                while (true) {
                                    if (n30 >= n29) {
                                        Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                        throw throwable22;
                                    }
                                    SqlExecutedListener l = sqlExecutedListenerArray15[n30];
                                    l.executeException(this.sqlTaskThrow);
                                    ++n30;
                                }
                            }
                            try {
                                try {
                                    if (this.preparedStatement != null) {
                                        this.preparedStatement.close();
                                        Jdbcacsess2.logger.info("  (task)Statement closed");
                                    }
                                    break block71;
                                }
                                catch (SQLException e) {
                                    Jdbcacsess2.logger.log(Level.WARNING, "WARNING", e);
                                    this.preparedStatement = null;
                                    this.timeMillisThreadEnd = System.currentTimeMillis();
                                    if (this.sqlTaskThrow != null) break block72;
                                    sqlExecutedListenerArray2 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                    n4 = sqlExecutedListenerArray2.length;
                                    n3 = 0;
                                }
                            }
                            catch (Throwable throwable5) {
                                this.preparedStatement = null;
                                this.timeMillisThreadEnd = System.currentTimeMillis();
                                if (this.sqlTaskThrow != null) break block73;
                                sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                n2 = sqlExecutedListenerArray.length;
                                n = 0;
                                break block74;
                            }
                            while (true) {
                                if (n3 >= n4) {
                                    Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                    return;
                                }
                                SqlExecutedListener l = sqlExecutedListenerArray2[n3];
                                l.executNormalFinish(this.rowCnt);
                                ++n3;
                            }
                        }
                        SqlExecutedListener[] sqlExecutedListenerArray16 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                        int n31 = sqlExecutedListenerArray16.length;
                        int n32 = 0;
                        while (true) {
                            if (n32 >= n31) {
                                Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                                return;
                            }
                            SqlExecutedListener l = sqlExecutedListenerArray16[n32];
                            l.executeException(this.sqlTaskThrow);
                            ++n32;
                        }
                    }
                    while (true) {
                        if (n >= n2) {
                            Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                            throw throwable5;
                        }
                        SqlExecutedListener l = sqlExecutedListenerArray[n];
                        l.executNormalFinish(this.rowCnt);
                        ++n;
                    }
                }
                SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                int n = sqlExecutedListenerArray.length;
                int n33 = 0;
                while (true) {
                    if (n33 >= n) {
                        Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                        throw throwable5;
                    }
                    SqlExecutedListener l = sqlExecutedListenerArray[n33];
                    l.executeException(this.sqlTaskThrow);
                    ++n33;
                }
            }
            this.preparedStatement = null;
            this.timeMillisThreadEnd = System.currentTimeMillis();
            if (this.sqlTaskThrow == null) {
                SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                int n = sqlExecutedListenerArray.length;
                int n34 = 0;
                while (true) {
                    if (n34 >= n) {
                        Jdbcacsess2.logger.info("  (task)noramal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                        return;
                    }
                    SqlExecutedListener l = sqlExecutedListenerArray[n34];
                    l.executNormalFinish(this.rowCnt);
                    ++n34;
                }
            }
            SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
            int n = sqlExecutedListenerArray.length;
            int n35 = 0;
            while (true) {
                if (n35 >= n) {
                    Jdbcacsess2.logger.info("  (task)abnormal end. cnt=[" + this.rowCnt + "] " + (this.timeMillisThreadEnd - this.timeMillisThreadStart) + "ms");
                    return;
                }
                SqlExecutedListener l = sqlExecutedListenerArray[n35];
                l.executeException(this.sqlTaskThrow);
                ++n35;
            }
        }

        private void setParameters(ArrayList<String> sqlInputItems, SqlExecuteParmeter.Parameter p) throws SQLException {
            Jdbcacsess2.logger.fine("  (setParameters)VALUES=" + p.values + "SQLTYPES=" + p.sqlTypes);
            if (sqlInputItems.size() != p.values.size()) {
                throw new IllegalArgumentException("\u5165\u529b\u30d1\u30e9\u6570\u304c\u5206\u6790\u7d50\u679c\u3068\u4e0d\u4e00\u81f4:Input=" + p.values.size() + " analized=" + sqlInputItems);
            }
            int i = 0;
            while (i < p.values.size()) {
                Object o = p.values.get(i);
                ConstSqlTypes constSqlTypes = p.sqlTypes.get(i);
                if (constSqlTypes == null) {
                    this.preparedStatement.setObject(i + 1, o);
                } else {
                    this.preparedStatement.setObject(i + 1, o, constSqlTypes.getValue());
                    Jdbcacsess2.logger.fine("  (setParameters)" + (Object)((Object)constSqlTypes));
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readResultSet() throws Throwable {
            ResultSet resultSet = this.preparedStatement.getResultSet();
            List<ColumnAttributeResult> list = ColumnAttributeResult.convColumnAttributeResult(resultSet.getMetaData());
            Jdbcacsess2.logger.info("  (task)resultSet opened.");
            SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
            int n = sqlExecutedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SqlExecutedListener l = sqlExecutedListenerArray[n2];
                l.resultHeader(list);
                ++n2;
            }
            int columnCnt = list.size();
            try {
                while (resultSet.next()) {
                    SqlTask sqlTask = this;
                    synchronized (sqlTask) {
                        if (Thread.interrupted()) {
                            Jdbcacsess2.logger.info("  (task)canceled.");
                            break;
                        }
                        ArrayList<Object> results = new ArrayList<Object>(columnCnt);
                        int i = 1;
                        while (i <= columnCnt) {
                            results.add(resultSet.getObject(i));
                            ++i;
                        }
                        ++this.rowCnt;
                        SqlExecutedListener[] sqlExecutedListenerArray2 = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                        int n3 = sqlExecutedListenerArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            SqlExecutedListener l = sqlExecutedListenerArray2[n4];
                            l.resultDetail(this.rowCnt, results);
                            ++n4;
                        }
                        Jdbcacsess2.logger.finest("  (task)results notified.");
                        if (this.rowCnt % SqlAsyncExecute.this.resultRowLimitCnt == 0) {
                            this.available = true;
                            new Thread(){

                                @Override
                                public void run() {
                                    SqlExecutedListener[] sqlExecutedListenerArray = (SqlExecutedListener[])SqlAsyncExecute.this.sqlExecutedListeners.getListeners(SqlExecutedListener.class);
                                    int n = sqlExecutedListenerArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        SqlExecutedListener l = sqlExecutedListenerArray[n2];
                                        l.statusContinue(SqlTask.this.rowCnt);
                                        ++n2;
                                    }
                                }
                            }.start();
                            Jdbcacsess2.logger.info("  (task)waiting.");
                            while (this.available) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    Jdbcacsess2.logger.fine("  (task)interrupted.");
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                            }
                            Jdbcacsess2.logger.info("  (task)wake up.");
                        }
                    }
                }
            }
            finally {
                resultSet.close();
                Jdbcacsess2.logger.info("  (task)resultSet closed.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taskWakeUp() {
            SqlTask sqlTask = this;
            synchronized (sqlTask) {
                this.available = false;
                this.notifyAll();
            }
        }

        @Override
        public void taskCancel() {
            SqlAsyncExecute.this.thread.interrupt();
        }

        @Override
        public void taskJoin(int timeoutSeconds) {
            Jdbcacsess2.logger.info("  (join)joining...");
            try {
                Executors.newSingleThreadExecutor().submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        SqlAsyncExecute.this.thread.join();
                        return null;
                    }
                }).get(timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Jdbcacsess2.logger.log(Level.WARNING, "WARNING", e);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                ShowDialog.errorMessage(e);
            }
            Jdbcacsess2.logger.info("  (join)joined.");
        }

        @Override
        public long getExecutionTime() {
            if (this.timeMillisThreadStart == 0L) {
                return 0L;
            }
            if (this.timeMillisThreadEnd == 0L) {
                return 0L;
            }
            return this.timeMillisThreadEnd - this.timeMillisThreadStart;
        }

        @Override
        public int getCnt() {
            return SqlAsyncExecute.this.sqlExecuteSentenceList.size();
        }
    }
}

