/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

public class SchemaTableName
implements Comparable<SchemaTableName> {
    private String schemaName = "";
    private String tableName = "";
    private String aliasName = "";
    private boolean storesLowerCaseIdentifiers = false;
    private boolean storesUpperCaseIdentifiers = false;

    public SchemaTableName() {
    }

    public SchemaTableName(boolean storesLowerCaseIdentifiers, boolean storesUpperCaseIdentifiers, String completeTableName) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
        if (completeTableName == null) {
            return;
        }
        int idx = completeTableName.indexOf(46);
        if (idx == -1) {
            this.setTableName(completeTableName);
            return;
        }
        this.setSchemaName(completeTableName.substring(0, idx));
        this.setTableName(completeTableName.substring(idx + 1));
    }

    public SchemaTableName(boolean storesLowerCaseIdentifiers, boolean storesUpperCaseIdentifiers, String schemaName, String tableName) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
        this.setSchemaName(schemaName);
        this.setTableName(tableName);
    }

    private void setSchemaName(String schemaName) {
        this.schemaName = schemaName == null ? "" : this.convertStoresIdentifiers(schemaName);
    }

    private void setTableName(String tableName) {
        this.tableName = tableName == null ? "" : this.convertStoresIdentifiers(tableName);
    }

    private String convertStoresIdentifiers(String str) {
        if (this.storesLowerCaseIdentifiers) {
            return str.toLowerCase().trim();
        }
        if (this.storesUpperCaseIdentifiers) {
            return str.toUpperCase().trim();
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTableName other = (SchemaTableName)obj;
        return other.getSchemaName().toUpperCase().equals(this.schemaName.toUpperCase()) && other.getTableName().toUpperCase().equals(this.tableName.toUpperCase());
    }

    public int hashCode() {
        return (String.valueOf(this.schemaName) + this.tableName).hashCode();
    }

    public String getCompleteTableName() {
        if (this.schemaName.equals("")) {
            return this.tableName;
        }
        return String.valueOf(this.schemaName) + "." + this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return this.getCompleteTableName();
    }

    @Override
    public int compareTo(SchemaTableName o) {
        return this.getCompleteTableName().compareTo(o.getCompleteTableName());
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }
}

