/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDelegate {
    private final Method method1;
    private final Method method2;

    AnnotationDelegate(Method method1, Method method2) {
        this.method1 = method1;
        this.method2 = method2;
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        T back = this.method1.getAnnotation(type);
        if (back == null && this.method2 != null) {
            back = this.method2.getAnnotation(type);
        }
        return back;
    }

    public Annotation[] getAnnotations() {
        ArrayList<Annotation> back = new ArrayList<Annotation>();
        back.addAll(Arrays.asList(this.method1.getAnnotations()));
        if (this.method2 != null) {
            back.addAll(Arrays.asList(this.method2.getAnnotations()));
        }
        return back.toArray(new Annotation[back.size()]);
    }

    public Method getMethod1() {
        return this.method1;
    }

    public Method getMethod2() {
        return this.method2;
    }
}

