/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.DefaultPolymorphicTypeMapper;
import net.java.ao.EntityProxy;
import net.java.ao.Generator;
import net.java.ao.MethodFinder;
import net.java.ao.PolymorphicTypeMapper;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.SoftHashMap;
import net.java.ao.ValueGenerator;
import net.java.ao.cache.Cache;
import net.java.ao.cache.CacheLayer;
import net.java.ao.cache.RAMCache;
import net.java.ao.cache.RAMRelationsCache;
import net.java.ao.cache.RelationsCache;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.CamelCaseFieldNameConverter;
import net.java.ao.schema.CamelCaseTableNameConverter;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.SchemaGenerator;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.types.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManager {
    private final DatabaseProvider provider;
    private final boolean weaklyCache;
    private Map<RawEntity<?>, EntityProxy<? extends RawEntity<?>, ?>> proxies;
    private final ReadWriteLock proxyLock = new ReentrantReadWriteLock();
    private Map<CacheKey<?>, Reference<RawEntity<?>>> entityCache;
    private final ReadWriteLock entityCacheLock = new ReentrantReadWriteLock();
    private Cache cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private TableNameConverter tableNameConverter;
    private final ReadWriteLock tableNameConverterLock = new ReentrantReadWriteLock();
    private FieldNameConverter fieldNameConverter;
    private final ReadWriteLock fieldNameConverterLock = new ReentrantReadWriteLock();
    private PolymorphicTypeMapper typeMapper;
    private final ReadWriteLock typeMapperLock = new ReentrantReadWriteLock();
    private Map<Class<? extends ValueGenerator<?>>, ValueGenerator<?>> valGenCache;
    private final ReadWriteLock valGenCacheLock = new ReentrantReadWriteLock();
    private final RelationsCache relationsCache = new RAMRelationsCache();

    public EntityManager(DatabaseProvider provider) {
        this(provider, false);
    }

    public EntityManager(DatabaseProvider provider, boolean weaklyCache) {
        this.provider = provider;
        this.weaklyCache = weaklyCache;
        this.proxies = weaklyCache ? new WeakHashMap() : new SoftHashMap();
        this.entityCache = new HashMap();
        this.cache = new RAMCache();
        this.valGenCache = new HashMap();
        this.tableNameConverter = new CamelCaseTableNameConverter();
        this.fieldNameConverter = new CamelCaseFieldNameConverter();
        this.typeMapper = new DefaultPolymorphicTypeMapper(new HashMap());
    }

    public EntityManager(String uri, String username, String password) {
        this(DatabaseProvider.getInstance(uri, username, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Class<? extends RawEntity<?>> ... entities) throws SQLException {
        this.tableNameConverterLock.readLock().lock();
        this.fieldNameConverterLock.readLock().lock();
        try {
            SchemaGenerator.migrate(this.provider, this.tableNameConverter, this.fieldNameConverter, entities);
        }
        finally {
            this.fieldNameConverterLock.readLock().unlock();
            this.tableNameConverterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        this.proxyLock.readLock().lock();
        try {
            for (EntityProxy<RawEntity<?>, ?> proxy : this.proxies.values()) {
                proxy.flushCache();
            }
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
        this.relationsCache.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(RawEntity<?> ... entities) {
        this.proxyLock.readLock().lock();
        try {
            ArrayList types = new ArrayList(entities.length);
            for (RawEntity<?> entity : entities) {
                types.add(entity.getEntityType());
                this.proxies.get(entity).flushCache();
            }
            this.relationsCache.remove(types.toArray(new Class[types.size()]));
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] get(Class<T> type, K ... keys) {
        RawEntity[] back = (RawEntity[])Array.newInstance(type, keys.length);
        int index = 0;
        for (K key : keys) {
            this.entityCacheLock.writeLock().lock();
            try {
                RawEntity<?> entity;
                Reference<RawEntity<?>> reference;
                Reference<RawEntity<?>> ref = reference = this.entityCache.get(new CacheKey<K>(key, type));
                RawEntity<?> rawEntity = entity = ref == null ? null : ref.get();
                if (entity != null) {
                    back[index++] = entity;
                    continue;
                }
                back[index++] = this.getAndInstantiate(type, key);
            }
            finally {
                this.entityCacheLock.writeLock().unlock();
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends RawEntity<K>, K> T getAndInstantiate(Class<T> type, K key) {
        EntityProxy<T, K> proxy = new EntityProxy<T, K>(this, type, key);
        RawEntity entity = (RawEntity)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, proxy);
        this.proxyLock.writeLock().lock();
        try {
            this.proxies.put(entity, proxy);
        }
        finally {
            this.proxyLock.writeLock().unlock();
        }
        this.entityCache.put(new CacheKey<K>(key, type), this.createRef(entity));
        return (T)entity;
    }

    public <T extends RawEntity<K>, K> T get(Class<T> type, K key) {
        return this.get(type, (K)new Object[]{key})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T create(Class<T> type, DBParam ... params) throws SQLException {
        RawEntity back = null;
        String table = null;
        this.tableNameConverterLock.readLock().lock();
        try {
            table = this.tableNameConverter.getName(type);
        }
        finally {
            this.tableNameConverterLock.readLock().unlock();
        }
        HashSet<DBParam> listParams = new HashSet<DBParam>();
        listParams.addAll(Arrays.asList(params));
        this.fieldNameConverterLock.readLock().lock();
        try {
            for (Method method : MethodFinder.getInstance().findAnnotation(Generator.class, type)) {
                ValueGenerator<?> generator;
                Generator genAnno = method.getAnnotation(Generator.class);
                String field = this.fieldNameConverter.getName(method);
                this.valGenCacheLock.writeLock().lock();
                try {
                    if (this.valGenCache.containsKey(genAnno.value())) {
                        generator = this.valGenCache.get(genAnno.value());
                    } else {
                        generator = genAnno.value().newInstance();
                        this.valGenCache.put(genAnno.value(), generator);
                    }
                }
                catch (InstantiationException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                finally {
                    this.valGenCacheLock.writeLock().unlock();
                }
                listParams.add(new DBParam(field, generator.generateValue(this)));
            }
        }
        finally {
            this.fieldNameConverterLock.readLock().unlock();
        }
        Connection conn = this.getProvider().getConnection();
        try {
            this.relationsCache.remove(type);
            Method pkMethod = Common.getPrimaryKeyMethod(type);
            back = (RawEntity)this.get(type, (K)this.provider.insertReturningKey(conn, Common.getPrimaryKeyClassType(type), Common.getPrimaryKeyField(type, this.getFieldNameConverter()), pkMethod.getAnnotation(AutoIncrement.class) != null, table, listParams.toArray(new DBParam[listParams.size()])));
        }
        finally {
            conn.close();
        }
        back.init();
        return (T)back;
    }

    public <T extends RawEntity<K>, K> T create(Class<T> type, Map<String, Object> params) throws SQLException {
        DBParam[] arrParams = new DBParam[params.size()];
        int i = 0;
        for (String key : params.keySet()) {
            arrParams[i++] = new DBParam(key, params.get(key));
        }
        return this.create(type, arrParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RawEntity<?> ... entities) throws SQLException {
        if (entities.length == 0) {
            return;
        }
        HashMap organizedEntities = new HashMap();
        for (RawEntity<?> entity : entities) {
            Class<RawEntity<?>> type = this.getProxyForEntity(entity).getType();
            if (!organizedEntities.containsKey(type)) {
                organizedEntities.put(type, new LinkedList());
            }
            ((List)organizedEntities.get(type)).add(entity);
        }
        this.entityCacheLock.writeLock().lock();
        try {
            Connection conn = this.getProvider().getConnection();
            try {
                for (Class type : organizedEntities.keySet()) {
                    List entityList = (List)organizedEntities.get(type);
                    StringBuilder sql = new StringBuilder("DELETE FROM ");
                    this.tableNameConverterLock.readLock().lock();
                    try {
                        sql.append(this.tableNameConverter.getName(type));
                    }
                    finally {
                        this.tableNameConverterLock.readLock().unlock();
                    }
                    sql.append(" WHERE ").append(Common.getPrimaryKeyField(type, this.getFieldNameConverter())).append(" IN (?");
                    for (int i = 1; i < entityList.size(); ++i) {
                        sql.append(",?");
                    }
                    sql.append(')');
                    Logger.getLogger("net.java.ao").log(Level.INFO, sql.toString());
                    PreparedStatement stmt = conn.prepareStatement(sql.toString());
                    int index = 1;
                    for (RawEntity entity : entityList) {
                        TypeManager.getInstance().getType(entity.getEntityType()).putToDatabase(index++, stmt, entity);
                    }
                    this.relationsCache.remove(type);
                    stmt.executeUpdate();
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
            for (RawEntity<?> entity : entities) {
                this.entityCache.remove(new CacheKey(Common.getPrimaryKeyValue(entity), entity.getEntityType()));
            }
            this.proxyLock.writeLock().lock();
            try {
                for (RawEntity<?> entity : entities) {
                    this.proxies.remove(entity);
                }
            }
            finally {
                this.proxyLock.writeLock().unlock();
            }
        }
        finally {
            this.entityCacheLock.writeLock().unlock();
        }
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type) throws SQLException {
        return this.find(type, Query.select());
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String criteria, Object ... parameters) throws SQLException {
        return this.find(type, Query.select().where(criteria, parameters));
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> type, Query query) throws SQLException {
        String selectField = Common.getPrimaryKeyField(type, this.getFieldNameConverter());
        query.resolveFields(type, this.getFieldNameConverter());
        String[] fields = query.getFields();
        if (fields.length == 1) {
            selectField = fields[0];
        }
        return this.find(type, selectField, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String field, Query query) throws SQLException {
        int i;
        ArrayList<T> back = new ArrayList<T>();
        query.resolveFields(type, this.getFieldNameConverter());
        Preload preloadAnnotation = type.getAnnotation(Preload.class);
        if (preloadAnnotation != null && !query.getFields()[0].equals("*") && query.getJoins().isEmpty()) {
            String[] oldFields = query.getFields();
            ArrayList<String> newFields = new ArrayList<String>();
            for (String newField : preloadAnnotation.value()) {
                newField = newField.trim();
                int fieldLoc = -1;
                for (i = 0; i < oldFields.length; ++i) {
                    if (!oldFields[i].equals(newField)) continue;
                    fieldLoc = i;
                    break;
                }
                if (fieldLoc < 0) {
                    newFields.add(newField);
                    continue;
                }
                newFields.add(oldFields[fieldLoc]);
            }
            if (!newFields.contains("*")) {
                for (String oldField : oldFields) {
                    if (newFields.contains(oldField)) continue;
                    newFields.add(oldField);
                }
            }
            query.setFields(newFields.toArray(new String[newFields.size()]));
        }
        Connection conn = this.getProvider().getConnection();
        try {
            String sql = null;
            this.tableNameConverterLock.readLock().lock();
            try {
                sql = query.toSQL(type, this.provider, this.tableNameConverter, this.getFieldNameConverter(), false);
            }
            finally {
                this.tableNameConverterLock.readLock().unlock();
            }
            Logger.getLogger("net.java.ao").log(Level.INFO, sql);
            PreparedStatement stmt = conn.prepareStatement(sql, 1004, 1007);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            ResultSet res = stmt.executeQuery();
            ResultSetMetaData md = res.getMetaData();
            this.provider.setQueryResultSetProperties(res, query);
            while (res.next()) {
                T entity = this.get(type, (K)Common.getPrimaryKeyType(type).pullFromDatabase(this, res, Common.getPrimaryKeyClassType(type), field));
                CacheLayer cacheLayer = this.getCache().getCacheLayer((RawEntity<?>)entity);
                for (i = 0; i < md.getColumnCount(); ++i) {
                    cacheLayer.put(md.getColumnLabel(i + 1), res.getObject(i + 1));
                }
                back.add(entity);
            }
            res.close();
            stmt.close();
        }
        finally {
            conn.close();
        }
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> type, String keyField, String sql, Object ... parameters) throws SQLException {
        ArrayList<T> back = new ArrayList<T>();
        Connection conn = this.getProvider().getConnection();
        try {
            Logger.getLogger("net.java.ao").log(Level.INFO, sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            TypeManager manager = TypeManager.getInstance();
            for (int i = 0; i < parameters.length; ++i) {
                Class<Object> javaType = parameters[i].getClass();
                if (parameters[i] instanceof RawEntity) {
                    javaType = ((RawEntity)parameters[i]).getEntityType();
                }
                manager.getType(javaType).putToDatabase(i + 1, stmt, parameters[i]);
            }
            ResultSet res = stmt.executeQuery();
            while (res.next()) {
                back.add(this.get(type, (K)Common.getPrimaryKeyType(type).pullFromDatabase(this, res, type, keyField)));
            }
            res.close();
            stmt.close();
        }
        finally {
            conn.close();
        }
        return back.toArray((RawEntity[])Array.newInstance(type, back.size()));
    }

    public <K> int count(Class<? extends RawEntity<K>> type) throws SQLException {
        return this.count(type, Query.select());
    }

    public <K> int count(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) throws SQLException {
        return this.count(type, Query.select().where(criteria, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> int count(Class<? extends RawEntity<K>> type, Query query) throws SQLException {
        int back = -1;
        Connection conn = this.getProvider().getConnection();
        try {
            String sql = null;
            this.tableNameConverterLock.readLock().lock();
            try {
                sql = query.toSQL(type, this.provider, this.tableNameConverter, this.getFieldNameConverter(), true);
            }
            finally {
                this.tableNameConverterLock.readLock().unlock();
            }
            Logger.getLogger("net.java.ao").log(Level.INFO, sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            this.provider.setQueryStatementProperties(stmt, query);
            query.setParameters(this, stmt);
            ResultSet res = stmt.executeQuery();
            if (res.next()) {
                back = res.getInt(1);
            }
            res.close();
            stmt.close();
        }
        finally {
            conn.close();
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableNameConverter(TableNameConverter tableNameConverter) {
        this.tableNameConverterLock.writeLock().lock();
        try {
            this.tableNameConverter = tableNameConverter;
        }
        finally {
            this.tableNameConverterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableNameConverter getTableNameConverter() {
        this.tableNameConverterLock.readLock().lock();
        try {
            TableNameConverter tableNameConverter = this.tableNameConverter;
            return tableNameConverter;
        }
        finally {
            this.tableNameConverterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldNameConverter(FieldNameConverter fieldNameConverter) {
        this.fieldNameConverterLock.writeLock().lock();
        try {
            this.fieldNameConverter = fieldNameConverter;
        }
        finally {
            this.fieldNameConverterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldNameConverter getFieldNameConverter() {
        this.fieldNameConverterLock.readLock().lock();
        try {
            FieldNameConverter fieldNameConverter = this.fieldNameConverter;
            return fieldNameConverter;
        }
        finally {
            this.fieldNameConverterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolymorphicTypeMapper(PolymorphicTypeMapper typeMapper) {
        this.typeMapperLock.writeLock().lock();
        try {
            this.typeMapper = typeMapper;
            if (typeMapper instanceof DefaultPolymorphicTypeMapper) {
                ((DefaultPolymorphicTypeMapper)typeMapper).resolveMappings(this.getTableNameConverter());
            }
        }
        finally {
            this.typeMapperLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolymorphicTypeMapper getPolymorphicTypeMapper() {
        this.typeMapperLock.readLock().lock();
        try {
            if (this.typeMapper == null) {
                throw new RuntimeException("No polymorphic type mapper was specified");
            }
            PolymorphicTypeMapper polymorphicTypeMapper = this.typeMapper;
            return polymorphicTypeMapper;
        }
        finally {
            this.typeMapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(Cache cache) {
        this.cacheLock.writeLock().lock();
        try {
            if (!this.cache.equals(cache)) {
                this.cache.dispose();
                this.cache = cache;
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.cacheLock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public DatabaseProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends RawEntity<K>, K> EntityProxy<T, K> getProxyForEntity(T entity) {
        this.proxyLock.readLock().lock();
        try {
            EntityProxy<? extends RawEntity<?>, ?> entityProxy = this.proxies.get(entity);
            return entityProxy;
        }
        finally {
            this.proxyLock.readLock().unlock();
        }
    }

    RelationsCache getRelationsCache() {
        return this.relationsCache;
    }

    private Reference<RawEntity<?>> createRef(RawEntity<?> entity) {
        if (this.weaklyCache) {
            return new WeakReference(entity);
        }
        return new SoftReference(entity);
    }

    static {
        Logger.getLogger("net.java.ao").setLevel(Level.OFF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheKey<T> {
        private T key;
        private Class<? extends RawEntity<?>> type;

        public CacheKey(T key, Class<? extends RawEntity<T>> type) {
            this.key = key;
            this.type = type;
        }

        public int hashCode() {
            return (this.type.hashCode() + this.key.hashCode()) % 65536;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey keyObj = (CacheKey)obj;
                if (this.key.equals(keyObj.key) && this.type.equals(keyObj.type)) {
                    return true;
                }
            }
            return false;
        }
    }
}

