/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import net.java.ao.db.DerbyDatabaseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedDerbyDatabaseProvider
extends DerbyDatabaseProvider {
    private Properties dbProperties = new Properties();

    public EmbeddedDerbyDatabaseProvider(String uri, String username, String password) {
        super(uri, username, password);
        this.dbProperties.setProperty("user", username);
        this.dbProperties.setProperty("password", password);
    }

    @Override
    public Class<? extends Driver> getDriverClass() throws ClassNotFoundException {
        return Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
    }

    @Override
    protected Connection getConnectionImpl() throws SQLException {
        try {
            this.getDriverClass();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return DriverManager.getConnection(this.getURI(), this.dbProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Connection conn = null;
        try {
            this.getDriverClass();
            conn = DriverManager.getConnection(this.getURI() + ";shutdown=true");
        }
        catch (SQLException e) {
        }
        catch (ClassNotFoundException e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException t) {}
            }
        }
        super.dispose();
    }
}

