/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexRow;
import org.apache.derby.impl.sql.execute.ScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;

class DependentResultSet
extends ScanResultSet
implements CursorResultSet {
    ConglomerateController heapCC;
    RowLocation baseRowLocation;
    ExecRow indexRow;
    IndexRow indexQualifierRow;
    ScanController indexSC;
    StaticCompiledOpenConglomInfo indexScoci;
    DynamicCompiledOpenConglomInfo indexDcoci;
    int numFkColumns;
    boolean isOpen;
    boolean deferred;
    TemporaryRowHolderResultSet source;
    TransactionController tc;
    String parentResultSetId;
    int[] fkColArray;
    RowLocation rowLocation;
    TemporaryRowHolder[] sourceRowHolders;
    TemporaryRowHolderResultSet[] sourceResultSets;
    int[] sourceOpened;
    int sArrayIndex;
    Vector sVector;
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo heapDcoci;
    protected StaticCompiledOpenConglomInfo heapScoci;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    public int rowsPerRead;
    public boolean forUpdate;
    private boolean sameStartStopPosition;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    ExecRow searchRow = null;

    DependentResultSet(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, GeneratedMethod generatedMethod, int n, GeneratedMethod generatedMethod2, int n2, GeneratedMethod generatedMethod3, int n3, boolean bl, Qualifier[][] qualifierArray, String string, String string2, String string3, boolean bl2, boolean bl3, int n4, int n5, boolean bl4, int n6, int n7, boolean bl5, double d, double d2, String string4, long l2, int n8, int n9) throws StandardException {
        super(activation, n, generatedMethod, n5, bl4, 4, n4, d, d2);
        this.conglomId = l;
        this.heapScoci = staticCompiledOpenConglomInfo;
        this.heapDcoci = activation.getTransactionController().getDynamicCompiledConglomInfo(l);
        this.resultRowAllocator = generatedMethod;
        this.startKeyGetter = generatedMethod2;
        this.startSearchOperator = n2;
        this.stopKeyGetter = generatedMethod3;
        this.stopSearchOperator = n3;
        this.sameStartStopPosition = bl;
        this.qualifiers = qualifierArray;
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = "On Foreign Key";
        this.isConstraint = bl2;
        this.forUpdate = bl3;
        this.rowsPerRead = n7;
        this.oneRowScan = bl5;
        this.runTimeStatisticsOn = activation != null && activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.tc = activation.getTransactionController();
        this.indexDcoci = this.tc.getDynamicCompiledConglomInfo(l2);
        this.indexScoci = this.tc.getStaticCompiledConglomInfo(l2);
        this.parentResultSetId = string4;
        this.fkColArray = (int[])activation.getPreparedStatement().getSavedObject(n8);
        this.rowLocation = (RowLocation)activation.getPreparedStatement().getSavedObject(n9);
        this.numFkColumns = this.fkColArray.length;
        this.indexQualifierRow = new IndexRow(this.numFkColumns);
        this.recordConstructorTime();
    }

    private ScanController openIndexScanController(ExecRow execRow) throws StandardException {
        this.setupQualifierRow(execRow);
        this.indexSC = this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, this.indexScoci, this.indexDcoci);
        return this.indexSC;
    }

    private void reopenIndexScanController(ExecRow execRow) throws StandardException {
        this.setupQualifierRow(execRow);
        this.indexSC.reopenScan(this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1);
    }

    private void setupQualifierRow(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = this.indexQualifierRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        for (int i = 0; i < this.numFkColumns; ++i) {
            dataValueDescriptorArray[i] = dataValueDescriptorArray2[this.fkColArray[i] - 1];
        }
    }

    private void openIndexScan(ExecRow execRow) throws StandardException {
        if (this.indexSC == null) {
            this.indexSC = this.openIndexScanController(execRow);
            this.indexRow = this.indexQualifierRow.getClone();
            this.indexRow.setColumn(this.numFkColumns + 1, this.rowLocation.cloneValue(false));
        } else {
            this.reopenIndexScanController(execRow);
        }
    }

    private ExecRow fetchIndexRow() throws StandardException {
        if (!this.indexSC.fetchNext(this.indexRow.getRowArray())) {
            return null;
        }
        return this.indexRow;
    }

    private ExecRow fetchBaseRow() throws StandardException {
        if (this.currentRow == null) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        }
        this.baseRowLocation = (RowLocation)this.indexRow.getColumn(this.indexRow.getRowArray().length);
        boolean bl = this.heapCC.fetch(this.baseRowLocation, this.candidate.getRowArray(), this.accessedCols);
        return this.currentRow;
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.searchRow == null && (this.searchRow = this.getNextParentRow()) != null) {
            this.openIndexScan(this.searchRow);
        }
        ExecRow execRow = null;
        while (this.searchRow != null && (execRow = this.fetchIndexRow()) == null) {
            this.searchRow = this.getNextParentRow();
            if (this.searchRow == null) continue;
            this.openIndexScan(this.searchRow);
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (execRow != null) {
            ++this.rowsSeen;
            return this.fetchBaseRow();
        }
        return execRow;
    }

    private ExecRow getNextParentRow() throws StandardException {
        TemporaryRowHolder temporaryRowHolder;
        if (this.sourceOpened[this.sArrayIndex] == 0) {
            temporaryRowHolder = this.sourceRowHolders[this.sArrayIndex];
            this.source = (TemporaryRowHolderResultSet)temporaryRowHolder.getResultSet();
            this.source.open();
            this.sourceOpened[this.sArrayIndex] = -1;
            this.sourceResultSets[this.sArrayIndex] = this.source;
        }
        if (this.sourceOpened[this.sArrayIndex] == 1) {
            this.source = this.sourceResultSets[this.sArrayIndex];
            this.source.reStartScan(this.sourceRowHolders[this.sArrayIndex].getTemporaryConglomId(), this.sourceRowHolders[this.sArrayIndex].getPositionIndexConglomId());
            this.sourceOpened[this.sArrayIndex] = -1;
        }
        if (this.sVector.size() > this.sourceRowHolders.length) {
            this.addNewSources();
        }
        ExecRow execRow = this.source.getNextRow();
        while (execRow == null && this.sArrayIndex + 1 < this.sourceRowHolders.length) {
            ++this.sArrayIndex;
            if (this.sourceOpened[this.sArrayIndex] == 0) {
                temporaryRowHolder = this.sourceRowHolders[this.sArrayIndex];
                this.source = (TemporaryRowHolderResultSet)temporaryRowHolder.getResultSet();
                this.source.open();
                this.sourceOpened[this.sArrayIndex] = -1;
                this.sourceResultSets[this.sArrayIndex] = this.source;
            }
            if (this.sourceOpened[this.sArrayIndex] == 1) {
                this.source = this.sourceResultSets[this.sArrayIndex];
                this.source.reStartScan(this.sourceRowHolders[this.sArrayIndex].getTemporaryConglomId(), this.sourceRowHolders[this.sArrayIndex].getPositionIndexConglomId());
                this.sourceOpened[this.sArrayIndex] = -1;
            }
            execRow = this.source.getNextRow();
        }
        if (execRow == null) {
            this.sArrayIndex = 0;
            for (int i = 0; i < this.sourceOpened.length; ++i) {
                this.sourceOpened[i] = 1;
            }
        }
        return execRow;
    }

    public ConglomerateController openHeapConglomerateController() throws StandardException {
        return this.tc.openCompiledConglomerate(false, 4, this.lockMode, this.isolationLevel, this.heapScoci, this.heapDcoci);
    }

    public void close() throws StandardException {
        if (this.runTimeStatisticsOn) {
            this.startPositionString = this.printStartPosition();
            this.stopPositionString = this.printStopPosition();
            this.scanProperties = this.getScanProperties();
        }
        if (this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
        if (this.heapCC != null) {
            this.heapCC.close();
            this.heapCC = null;
        }
        if (this.isOpen) {
            this.source.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        if (this.source != null) {
            this.source.finish();
        }
        this.finishAndRTS();
    }

    public void openCore() throws StandardException {
        this.initIsolationLevel();
        this.sVector = this.activation.getParentResultSet(this.parentResultSetId);
        int n = this.sVector.size();
        this.sourceRowHolders = new TemporaryRowHolder[n];
        this.sourceOpened = new int[n];
        this.sourceResultSets = new TemporaryRowHolderResultSet[n];
        for (int i = 0; i < n; ++i) {
            this.sourceRowHolders[i] = (TemporaryRowHolder)this.sVector.elementAt(i);
            this.sourceOpened[i] = 0;
        }
        this.heapCC = this.openHeapConglomerateController();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void addNewSources() {
        int n = this.sVector.size();
        TemporaryRowHolder[] temporaryRowHolderArray = new TemporaryRowHolder[n];
        int[] nArray = new int[n];
        TemporaryRowHolderResultSet[] temporaryRowHolderResultSetArray = new TemporaryRowHolderResultSet[n];
        System.arraycopy(this.sourceRowHolders, 0, temporaryRowHolderArray, 0, this.sourceRowHolders.length);
        System.arraycopy(this.sourceOpened, 0, nArray, 0, this.sourceOpened.length);
        System.arraycopy(this.sourceResultSets, 0, temporaryRowHolderResultSetArray, 0, this.sourceResultSets.length);
        for (int i = this.sourceRowHolders.length; i < n; ++i) {
            temporaryRowHolderArray[i] = (TemporaryRowHolder)this.sVector.elementAt(i);
            nArray[i] = 0;
        }
        this.sourceRowHolders = temporaryRowHolderArray;
        this.sourceOpened = nArray;
        this.sourceResultSets = temporaryRowHolderResultSetArray;
    }

    boolean canGetInstantaneousLocks() {
        return false;
    }

    public long getTimeSpent(int n) {
        return this.constructorTime + this.openTime + this.nextTime + this.closeTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.indexSC != null) {
                this.indexSC.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.indexSC.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    public String printStartPosition() {
        return this.printPosition(1, this.indexQualifierRow);
    }

    public String printStopPosition() {
        return this.printPosition(-1, this.indexQualifierRow);
    }

    private String printPosition(int n, ExecIndexRow execIndexRow) {
        String string = "";
        String string2 = "";
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = ">=";
                break;
            }
            case -1: {
                string3 = ">";
                break;
            }
            default: {
                string3 = "unknown value (" + n + ")";
            }
        }
        if (execIndexRow != null) {
            string2 = string2 + "\t" + MessageService.getTextMessage("42Z40.U", string3, String.valueOf(execIndexRow.nColumns())) + "\n";
            string2 = string2 + "\t" + MessageService.getTextMessage("42Z41.U") + "\n";
            boolean bl = false;
            for (int i = 0; i < execIndexRow.nColumns(); ++i) {
                if (execIndexRow.areNullsOrdered(i)) {
                    string2 = string2 + i + " ";
                    bl = true;
                }
                if (!bl || i != execIndexRow.nColumns() - 1) continue;
                string2 = string2 + "\n";
            }
        }
        return string2;
    }

    public String printQualifiers() {
        String string = "";
        return string + MessageService.getTextMessage("42Z37.U");
    }
}

